/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.Trigger;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.liquids.LiquidTank;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.power.PowerProvider;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.CoreProxy;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.energy.Engine;
import buildcraft.energy.EngineIron;
import buildcraft.energy.EngineStone;
import buildcraft.energy.EngineWood;
import buildcraft.energy.IEngineProvider;
import java.util.LinkedList;

public class TileEngine
extends TileBuildCraft
implements IPowerReceptor,
ni,
ITankContainer,
IEngineProvider,
IOverrideDefaultTriggers,
IPipeConnection,
IBuilderInventory {
    @TileNetworkData
    public Engine engine;
    @TileNetworkData
    public int progressPart = 0;
    @TileNetworkData
    public float serverPistonSpeed = 0.0f;
    @TileNetworkData
    public boolean isActive = false;
    boolean lastPower = false;
    public int orientation;
    IPowerProvider provider = PowerFramework.currentFramework.createPowerProvider();
    public boolean isRedstonePowered = false;

    @Override
    public void initialize() {
        if (!CoreProxy.isClient(this.k)) {
            if (this.engine == null) {
                this.createEngineIfNeeded();
            }
            this.engine.orientation = Orientations.values()[this.orientation];
            this.provider.configure(0, 1, this.engine.maxEnergyReceived(), 1, this.engine.maxEnergy);
            this.checkRedstonePower();
        }
    }

    @Override
    public void q_() {
        super.q_();
        if (this.engine == null) {
            return;
        }
        if (CoreProxy.isClient(this.k)) {
            if (this.progressPart != 0) {
                this.engine.progress += this.serverPistonSpeed;
                if (this.engine.progress > 1.0f) {
                    this.progressPart = 0;
                    this.engine.progress = 0.0f;
                }
            } else if (this.isActive) {
                this.progressPart = 1;
            }
            return;
        }
        this.engine.update();
        float newPistonSpeed = this.engine.getPistonSpeed();
        if (newPistonSpeed != this.serverPistonSpeed) {
            this.serverPistonSpeed = newPistonSpeed;
            this.sendNetworkUpdate();
        }
        if (this.progressPart != 0) {
            this.engine.progress += this.engine.getPistonSpeed();
            if ((double)this.engine.progress > 0.5 && this.progressPart == 1) {
                IPowerReceptor receptor;
                float extracted;
                this.progressPart = 2;
                Position pos = new Position(this.l, this.m, this.n, this.engine.orientation);
                pos.moveForwards(1.0);
                qj tile = this.k.b((int)pos.x, (int)pos.y, (int)pos.z);
                if (this.isPoweredTile(tile) && (extracted = this.engine.extractEnergy((receptor = (IPowerReceptor)tile).getPowerProvider().getMinEnergyReceived(), receptor.getPowerProvider().getMaxEnergyReceived(), true)) > 0.0f) {
                    receptor.getPowerProvider().receiveEnergy(extracted, this.engine.orientation.reverse());
                }
            } else if (this.engine.progress >= 1.0f) {
                this.engine.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.engine.isActive()) {
            Position pos = new Position(this.l, this.m, this.n, this.engine.orientation);
            pos.moveForwards(1.0);
            qj tile = this.k.b((int)pos.x, (int)pos.y, (int)pos.z);
            if (this.isPoweredTile(tile)) {
                IPowerReceptor receptor = (IPowerReceptor)tile;
                if (this.engine.extractEnergy(receptor.getPowerProvider().getMinEnergyReceived(), receptor.getPowerProvider().getMaxEnergyReceived(), false) > 0.0f) {
                    this.progressPart = 1;
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.engine.burn();
    }

    private void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
        this.sendNetworkUpdate();
    }

    private void createEngineIfNeeded() {
        if (this.engine == null) {
            int kind = this.k.c(this.l, this.m, this.n);
            this.engine = this.newEngine(kind);
            this.engine.orientation = Orientations.values()[this.orientation];
            this.k.f(this.l, this.m, this.n, BuildCraftEnergy.engineBlock.bO);
        }
    }

    public void switchOrientation() {
        for (int i = this.orientation + 1; i <= this.orientation + 6; ++i) {
            Orientations o = Orientations.values()[i % 6];
            Position pos = new Position(this.l, this.m, this.n, o);
            pos.moveForwards(1.0);
            qj tile = this.k.b((int)pos.x, (int)pos.y, (int)pos.z);
            if (!this.isPoweredTile(tile)) continue;
            if (this.engine != null) {
                this.engine.orientation = o;
            }
            this.orientation = o.ordinal();
            this.k.k(this.l, this.m, this.n);
            break;
        }
    }

    public void delete() {
        if (this.engine != null) {
            this.engine.delete();
        }
    }

    public Engine newEngine(int meta) {
        if (meta == 0) {
            return new EngineWood(this);
        }
        if (meta == 1) {
            return new EngineStone(this);
        }
        if (meta == 2) {
            return new EngineIron(this);
        }
        return null;
    }

    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        int kind = nbttagcompound.f("kind");
        this.engine = this.newEngine(kind);
        this.orientation = nbttagcompound.f("orientation");
        if (this.engine != null) {
            this.engine.progress = nbttagcompound.h("progress");
            this.engine.energy = nbttagcompound.h("energyF");
            this.engine.orientation = Orientations.values()[this.orientation];
        }
        if (this.engine != null) {
            this.engine.readFromNBT(nbttagcompound);
        }
    }

    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("kind", this.k.c(this.l, this.m, this.n));
        if (this.engine != null) {
            nbttagcompound.a("orientation", this.orientation);
            nbttagcompound.a("progress", this.engine.progress);
            nbttagcompound.a("energyF", this.engine.energy);
        }
        if (this.engine != null) {
            this.engine.writeToNBT(nbttagcompound);
        }
    }

    public int c() {
        if (this.engine != null) {
            return this.engine.getSizeInventory();
        }
        return 0;
    }

    public kp g_(int i) {
        if (this.engine != null) {
            return this.engine.getStackInSlot(i);
        }
        return null;
    }

    public kp a(int i, int j) {
        if (this.engine != null) {
            return this.engine.decrStackSize(i, j);
        }
        return null;
    }

    public kp b(int i) {
        if (this.engine != null) {
            return this.engine.getStackInSlotOnClosing(i);
        }
        return null;
    }

    public void a(int i, kp itemstack) {
        if (this.engine != null) {
            this.engine.setInventorySlotContents(i, itemstack);
        }
    }

    public String e() {
        return "Engine";
    }

    public int a() {
        return 64;
    }

    public boolean a(ih entityplayer) {
        return this.k.b(this.l, this.m, this.n) == this;
    }

    public boolean isBurning() {
        return this.engine != null && this.engine.isBurning();
    }

    public int getScaledBurnTime(int i) {
        if (this.engine != null) {
            return this.engine.getScaledBurnTime(i);
        }
        return 0;
    }

    @Override
    public lx d() {
        this.createEngineIfNeeded();
        return super.d();
    }

    @Override
    public lx getUpdatePacket() {
        if (this.engine != null) {
            this.serverPistonSpeed = this.engine.getPistonSpeed();
        }
        return super.getUpdatePacket();
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        this.createEngineIfNeeded();
        super.handleDescriptionPacket(packet);
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        this.createEngineIfNeeded();
        super.handleUpdatePacket(packet);
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.provider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    @Override
    public void doWork() {
        if (CoreProxy.isClient(this.k)) {
            return;
        }
        this.engine.addEnergy((int)(this.provider.useEnergy(1.0f, this.engine.maxEnergyReceived(), true) * 0.95f));
    }

    public boolean isPoweredTile(qj tile) {
        if (tile instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)tile;
            IPowerProvider provider = receptor.getPowerProvider();
            return provider != null && provider.getClass().getSuperclass().equals(PowerProvider.class);
        }
        return false;
    }

    public void f() {
    }

    public void g() {
    }

    @Override
    public int powerRequest() {
        return 0;
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public LinkedList getTriggers() {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        triggers.add(BuildCraftEnergy.triggerBlueEngineHeat);
        triggers.add(BuildCraftEnergy.triggerGreenEngineHeat);
        triggers.add(BuildCraftEnergy.triggerYellowEngineHeat);
        triggers.add(BuildCraftEnergy.triggerRedEngineHeat);
        if (this.engine instanceof EngineIron) {
            triggers.add(BuildCraftCore.triggerEmptyLiquid);
            triggers.add(BuildCraftCore.triggerContainsLiquid);
            triggers.add(BuildCraftCore.triggerSpaceLiquid);
            triggers.add(BuildCraftCore.triggerFullLiquid);
        } else if (this.engine instanceof EngineStone) {
            triggers.add(BuildCraftCore.triggerEmptyInventory);
            triggers.add(BuildCraftCore.triggerContainsInventory);
            triggers.add(BuildCraftCore.triggerSpaceInventory);
            triggers.add(BuildCraftCore.triggerFullInventory);
        }
        return triggers;
    }

    @Override
    public boolean isPipeConnected(Orientations with) {
        if (this.engine instanceof EngineWood) {
            return false;
        }
        return with.ordinal() != this.orientation;
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return false;
    }

    public void checkRedstonePower() {
        this.isRedstonePowered = this.k.x(this.l, this.m, this.n);
    }

    @Override
    public int fill(Orientations from, LiquidStack resource, boolean doFill) {
        if (this.engine instanceof EngineIron) {
            return ((EngineIron)this.engine).fill(from, resource, doFill);
        }
        return 0;
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public LiquidStack drain(Orientations from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidTank[] getTanks() {
        if (this.engine == null) {
            return new LiquidTank[0];
        }
        return this.engine.getLiquidSlots();
    }
}

