/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.energy.ContainerEngine;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;

public class EngineStone
extends Engine {
    int burnTime = 0;
    int totalBurnTime = 0;
    private kp itemInInventory;

    public EngineStone(TileEngine engine) {
        super(engine);
        this.maxEnergy = 10000;
        this.maxEnergyExtracted = 100;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_PATH_BLOCKS + "/base_stone.png";
    }

    @Override
    public int explosionRange() {
        return 4;
    }

    @Override
    public int maxEnergyReceived() {
        return 200;
    }

    @Override
    public float getPistonSpeed() {
        switch (this.getEnergyStage()) {
            case Blue: {
                return 0.02f;
            }
            case Green: {
                return 0.04f;
            }
            case Yellow: {
                return 0.08f;
            }
            case Red: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void burn() {
        this.currentOutput = 0.0f;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.currentOutput = 1.0f;
            this.addEnergy(1.0f);
        }
        if (this.burnTime == 0 && this.tile.isRedstonePowered) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.tile.g_(0));
            if (this.burnTime > 0) {
                this.tile.a(0, Utils.consumeItem(this.tile.g_(0)));
            }
        }
    }

    @Override
    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    private int getItemBurnTime(kp itemstack) {
        if (itemstack == null) {
            return 0;
        }
        return tr.a((kp)itemstack);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        this.burnTime = nbttagcompound.f("burnTime");
        this.totalBurnTime = nbttagcompound.f("totalBurnTime");
        if (nbttagcompound.c("itemInInventory")) {
            ph cpt = nbttagcompound.m("itemInInventory");
            this.itemInInventory = kp.a((ph)cpt);
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        nbttagcompound.a("burnTime", this.burnTime);
        nbttagcompound.a("totalBurnTime", this.totalBurnTime);
        if (this.itemInInventory != null) {
            ph cpt = new ph();
            this.itemInInventory.b(cpt);
            nbttagcompound.a("itemInInventory", (jz)cpt);
        }
    }

    @Override
    public void delete() {
        kp stack = this.tile.g_(0);
        if (stack != null) {
            Utils.dropItems(this.tile.k, stack, this.tile.l, this.tile.m, this.tile.n);
        }
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.energy = j;
                break;
            }
            case 1: {
                this.currentOutput = j;
                break;
            }
            case 2: {
                this.burnTime = j;
                break;
            }
            case 3: {
                this.totalBurnTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ff iCrafting) {
        iCrafting.a((ew)containerEngine, 0, Math.round(this.energy));
        iCrafting.a((ew)containerEngine, 1, Math.round(this.currentOutput));
        iCrafting.a((ew)containerEngine, 2, this.burnTime);
        iCrafting.a((ew)containerEngine, 3, this.totalBurnTime);
    }

    @Override
    public int getHeat() {
        return Math.round(this.energy);
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public kp getStackInSlot(int i) {
        return this.itemInInventory;
    }

    @Override
    public void setInventorySlotContents(int i, kp itemstack) {
        this.itemInInventory = itemstack;
    }

    @Override
    public kp decrStackSize(int i, int j) {
        if (this.itemInInventory != null) {
            kp newStack = this.itemInInventory.a(j);
            if (this.itemInInventory.a == 0) {
                this.itemInInventory = null;
            }
            return newStack;
        }
        return null;
    }

    @Override
    public kp getStackInSlotOnClosing(int var1) {
        if (this.itemInInventory == null) {
            return null;
        }
        kp toReturn = this.itemInInventory;
        this.itemInInventory = null;
        return toReturn;
    }
}

