/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.core.Orientations;
import buildcraft.api.liquids.LiquidTank;
import buildcraft.core.CoreProxy;
import buildcraft.core.network.TileNetworkData;
import buildcraft.energy.ContainerEngine;
import buildcraft.energy.TileEngine;

public abstract class Engine {
    public int maxEnergy;
    protected float currentOutput = 0.0f;
    @TileNetworkData
    public float progress;
    @TileNetworkData
    public Orientations orientation;
    public float energy;
    @TileNetworkData
    public EnergyStage energyStage = EnergyStage.Blue;
    public int maxEnergyExtracted = 1;
    protected TileEngine tile;

    public Engine(TileEngine tile) {
        this.tile = tile;
    }

    protected void computeEnergyStage() {
        this.energyStage = (double)this.energy / (double)this.maxEnergy * 100.0 <= 25.0 ? EnergyStage.Blue : ((double)this.energy / (double)this.maxEnergy * 100.0 <= 50.0 ? EnergyStage.Green : ((double)this.energy / (double)this.maxEnergy * 100.0 <= 75.0 ? EnergyStage.Yellow : ((double)this.energy / (double)this.maxEnergy * 100.0 <= 100.0 ? EnergyStage.Red : EnergyStage.Explosion)));
    }

    public final EnergyStage getEnergyStage() {
        if (!CoreProxy.isClient(this.tile.k)) {
            this.computeEnergyStage();
        }
        return this.energyStage;
    }

    public void update() {
        if (!this.tile.isRedstonePowered && this.energy > 1.0f) {
            this.energy -= 1.0f;
        }
    }

    public abstract String getTextureFile();

    public abstract int explosionRange();

    public abstract int maxEnergyReceived();

    public abstract float getPistonSpeed();

    public abstract boolean isBurning();

    public abstract void delete();

    public void addEnergy(float addition) {
        this.energy += addition;
        if (this.getEnergyStage() == EnergyStage.Explosion) {
            this.tile.k.a(null, (double)this.tile.l, (double)this.tile.m, (double)this.tile.n, (float)this.explosionRange());
        }
        if (this.energy > (float)this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
    }

    public float extractEnergy(int min, int max, boolean doExtract) {
        float extracted;
        if (this.energy < (float)min) {
            return 0.0f;
        }
        int actualMax = max > this.maxEnergyExtracted ? this.maxEnergyExtracted : max;
        if (this.energy >= (float)actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.energy -= (float)actualMax;
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0.0f;
            }
        }
        return extracted;
    }

    public abstract int getScaledBurnTime(int var1);

    public abstract void burn();

    public void readFromNBT(ph nbttagcompound) {
    }

    public void writeToNBT(ph nbttagcompound) {
    }

    public void getGUINetworkData(int i, int j) {
    }

    public void sendGUINetworkData(ContainerEngine containerEngine, ff iCrafting) {
    }

    public boolean isActive() {
        return true;
    }

    public int getHeat() {
        return 0;
    }

    public float getEnergyStored() {
        return this.energy;
    }

    public float getCurrentOutput() {
        return this.currentOutput;
    }

    public LiquidTank[] getLiquidSlots() {
        return new LiquidTank[0];
    }

    public int getSizeInventory() {
        return 0;
    }

    public kp getStackInSlot(int i) {
        return null;
    }

    public kp decrStackSize(int i, int j) {
        return null;
    }

    public kp getStackInSlotOnClosing(int i) {
        return this.getStackInSlot(i);
    }

    public void setInventorySlotContents(int i, kp itemstack) {
    }

    public static enum EnergyStage {
        Blue,
        Green,
        Yellow,
        Red,
        Explosion;

    }
}

