/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.liquids.ILiquid;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.core.BlockIndex;
import buildcraft.core.CoreProxy;
import buildcraft.core.EntityBlock;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.IFramePipeConnection;
import buildcraft.core.PacketIds;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketUpdate;
import java.util.Arrays;
import java.util.LinkedList;

public class Utils {
    public static final float pipeMinPos = 0.25f;
    public static final float pipeMaxPos = 0.75f;
    public static float pipeNormalSpeed = 0.01f;

    public static float getPipeFloorOf(kp item) {
        return 0.25f;
    }

    public static Orientations get2dOrientation(Position pos1, Position pos2) {
        double Dz = pos1.z - pos2.z;
        double Dx = pos1.x - pos2.x;
        double angle = Math.atan2(Dz, Dx) / Math.PI * 180.0 + 180.0;
        if (angle < 45.0 || angle > 315.0) {
            return Orientations.XPos;
        }
        if (angle < 135.0) {
            return Orientations.ZPos;
        }
        if (angle < 225.0) {
            return Orientations.XNeg;
        }
        return Orientations.ZNeg;
    }

    public static Orientations get3dOrientation(Position pos1, Position pos2) {
        double Dy = pos1.y - pos2.y;
        double Dx = pos1.x - pos2.x;
        double angle = Math.atan2(Dy, Dx) / Math.PI * 180.0 + 180.0;
        if (angle > 45.0 && angle < 135.0) {
            return Orientations.YPos;
        }
        if (angle > 225.0 && angle < 315.0) {
            return Orientations.YNeg;
        }
        return Utils.get2dOrientation(pos1, pos2);
    }

    public static boolean addToRandomPipeEntry(qj tile, Orientations from, kp items) {
        ge w = tile.k;
        LinkedList<Orientations> possiblePipes = new LinkedList<Orientations>();
        for (int j = 0; j < 6; ++j) {
            if (from.reverse().ordinal() == j) continue;
            Position pos = new Position(tile.l, tile.m, tile.n, Orientations.values()[j]);
            pos.moveForwards(1.0);
            qj pipeEntry = w.b((int)pos.x, (int)pos.y, (int)pos.z);
            if (!(pipeEntry instanceof IPipeEntry) || !((IPipeEntry)pipeEntry).acceptItems()) continue;
            possiblePipes.add(Orientations.values()[j]);
        }
        if (possiblePipes.size() > 0) {
            int choice = w.r.nextInt(possiblePipes.size());
            Position entityPos = new Position(tile.l, tile.m, tile.n, (Orientations)((Object)possiblePipes.get(choice)));
            Position pipePos = new Position(tile.l, tile.m, tile.n, (Orientations)((Object)possiblePipes.get(choice)));
            entityPos.x += 0.5;
            entityPos.y += (double)Utils.getPipeFloorOf(items);
            entityPos.z += 0.5;
            entityPos.moveForwards(0.5);
            pipePos.moveForwards(1.0);
            IPipeEntry pipeEntry = (IPipeEntry)w.b((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
            EntityPassiveItem entity = new EntityPassiveItem(w, entityPos.x, entityPos.y, entityPos.z, items);
            pipeEntry.entityEntering(entity, entityPos.orientation);
            items.a = 0;
            return true;
        }
        return false;
    }

    public static void dropItems(ge world, kp stack, int i, int j, int k2) {
        if (stack.a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.r.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.r.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.r.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        ja entityitem = new ja(world, (double)i + d, (double)j + d1, (double)k2 + d2, stack);
        entityitem.c = 10;
        world.b((tv)entityitem);
    }

    public static void dropItems(ge world, ni inventory, int i, int j, int k2) {
        for (int l = 0; l < inventory.c(); ++l) {
            kp items = inventory.g_(l);
            if (items == null || items.a <= 0) continue;
            Utils.dropItems(world, inventory.g_(l).j(), i, j, k2);
        }
    }

    public static qj getTile(ge world, Position pos, Orientations step) {
        Position tmp = new Position(pos);
        tmp.orientation = step;
        tmp.moveForwards(1.0);
        return world.b((int)tmp.x, (int)tmp.y, (int)tmp.z);
    }

    public static ni getInventory(ni inv) {
        if (inv instanceof lh) {
            lh chest = (lh)inv;
            Position pos = new Position(chest.l, chest.m, chest.n);
            ni chest2 = null;
            qj tile = Utils.getTile(chest.k, pos, Orientations.XNeg);
            if (tile instanceof lh) {
                chest2 = (ni)tile;
            }
            if ((tile = Utils.getTile(chest.k, pos, Orientations.XPos)) instanceof lh) {
                chest2 = (ni)tile;
            }
            if ((tile = Utils.getTile(chest.k, pos, Orientations.ZNeg)) instanceof lh) {
                chest2 = (ni)tile;
            }
            if ((tile = Utils.getTile(chest.k, pos, Orientations.ZPos)) instanceof lh) {
                chest2 = (ni)tile;
            }
            if (chest2 != null) {
                return new pt("", inv, chest2);
            }
        }
        return inv;
    }

    public static IAreaProvider getNearbyAreaProvider(ge world, int i, int j, int k2) {
        qj a1 = world.b(i + 1, j, k2);
        qj a2 = world.b(i - 1, j, k2);
        qj a3 = world.b(i, j, k2 + 1);
        qj a4 = world.b(i, j, k2 - 1);
        qj a5 = world.b(i, j + 1, k2);
        qj a6 = world.b(i, j - 1, k2);
        if (a1 instanceof IAreaProvider) {
            return (IAreaProvider)a1;
        }
        if (a2 instanceof IAreaProvider) {
            return (IAreaProvider)a2;
        }
        if (a3 instanceof IAreaProvider) {
            return (IAreaProvider)a3;
        }
        if (a4 instanceof IAreaProvider) {
            return (IAreaProvider)a4;
        }
        if (a5 instanceof IAreaProvider) {
            return (IAreaProvider)a5;
        }
        if (a6 instanceof IAreaProvider) {
            return (IAreaProvider)a6;
        }
        return null;
    }

    public static EntityBlock createLaser(ge world, Position p1, Position p2, LaserKind kind) {
        if (p1.equals(p2)) {
            return null;
        }
        double iSize = p2.x - p1.x;
        double jSize = p2.y - p1.y;
        double kSize = p2.z - p1.z;
        double i = p1.x;
        double j = p1.y;
        double k2 = p1.z;
        if (iSize != 0.0) {
            i += 0.5;
            j += 0.45;
            k2 += 0.45;
            jSize = 0.1;
            kSize = 0.1;
        } else if (jSize != 0.0) {
            i += 0.45;
            j += 0.5;
            k2 += 0.45;
            iSize = 0.1;
            kSize = 0.1;
        } else if (kSize != 0.0) {
            i += 0.45;
            j += 0.45;
            k2 += 0.5;
            iSize = 0.1;
            jSize = 0.1;
        }
        int texture = BuildCraftCore.redLaserTexture;
        switch (kind) {
            case Blue: {
                texture = BuildCraftCore.blueLaserTexture;
                break;
            }
            case Red: {
                texture = BuildCraftCore.redLaserTexture;
                break;
            }
            case Stripes: {
                texture = BuildCraftCore.stripesLaserTexture;
            }
        }
        EntityBlock block = new EntityBlock(world, i, j, k2, iSize, jSize, kSize, texture);
        world.b((tv)block);
        return block;
    }

    public static EntityBlock[] createLaserBox(ge world, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, LaserKind kind) {
        EntityBlock[] lasers = new EntityBlock[12];
        Position[] p = new Position[]{new Position(xMin, yMin, zMin), new Position(xMax, yMin, zMin), new Position(xMin, yMax, zMin), new Position(xMax, yMax, zMin), new Position(xMin, yMin, zMax), new Position(xMax, yMin, zMax), new Position(xMin, yMax, zMax), new Position(xMax, yMax, zMax)};
        lasers[0] = Utils.createLaser(world, p[0], p[1], kind);
        lasers[1] = Utils.createLaser(world, p[0], p[2], kind);
        lasers[2] = Utils.createLaser(world, p[2], p[3], kind);
        lasers[3] = Utils.createLaser(world, p[1], p[3], kind);
        lasers[4] = Utils.createLaser(world, p[4], p[5], kind);
        lasers[5] = Utils.createLaser(world, p[4], p[6], kind);
        lasers[6] = Utils.createLaser(world, p[5], p[7], kind);
        lasers[7] = Utils.createLaser(world, p[6], p[7], kind);
        lasers[8] = Utils.createLaser(world, p[0], p[4], kind);
        lasers[9] = Utils.createLaser(world, p[1], p[5], kind);
        lasers[10] = Utils.createLaser(world, p[2], p[6], kind);
        lasers[11] = Utils.createLaser(world, p[3], p[7], kind);
        return lasers;
    }

    public static void handleBufferedDescription(ISynchronizedTile tileSynch) {
        qj tile = (qj)tileSynch;
        BlockIndex index = new BlockIndex(tile.l, tile.m, tile.n);
        if (BuildCraftCore.bufferedDescriptions.containsKey(index)) {
            PacketUpdate payload = (PacketUpdate)((Object)BuildCraftCore.bufferedDescriptions.get(index));
            BuildCraftCore.bufferedDescriptions.remove(index);
            tileSynch.handleDescriptionPacket(payload);
            tileSynch.postPacketHandling(payload);
        }
    }

    public static int liquidId(int blockId) {
        if (blockId == vz.B.bO || blockId == vz.A.bO) {
            return vz.B.bO;
        }
        if (blockId == vz.D.bO || blockId == vz.C.bO) {
            return vz.D.bO;
        }
        if (vz.m[blockId] instanceof ILiquid) {
            return ((ILiquid)vz.m[blockId]).stillLiquidId();
        }
        return 0;
    }

    public static int packetIdToInt(PacketIds id2) {
        switch (id2) {
            case DiamondPipeGUI: {
                return 70;
            }
            case AutoCraftingGUI: {
                return 71;
            }
            case FillerGUI: {
                return 72;
            }
            case TemplateGUI: {
                return 73;
            }
            case BuilderGUI: {
                return 74;
            }
            case EngineSteamGUI: {
                return 75;
            }
            case EngineCombustionGUI: {
                return 76;
            }
            case AssemblyTableGUI: {
                return 77;
            }
        }
        throw new RuntimeException("Invalid GUI id: " + (Object)((Object)id2));
    }

    public static PacketIds intToPacketId(int id2) {
        switch (id2) {
            case 70: {
                return PacketIds.DiamondPipeGUI;
            }
            case 71: {
                return PacketIds.AutoCraftingGUI;
            }
            case 72: {
                return PacketIds.FillerGUI;
            }
            case 73: {
                return PacketIds.TemplateGUI;
            }
            case 74: {
                return PacketIds.BuilderGUI;
            }
            case 75: {
                return PacketIds.EngineSteamGUI;
            }
            case 76: {
                return PacketIds.EngineCombustionGUI;
            }
            case 77: {
                return PacketIds.AssemblyTableGUI;
            }
        }
        throw new RuntimeException("Invalid GUI number: " + id2);
    }

    public static void preDestroyBlock(ge world, int i, int j, int k2) {
        qj tile = world.b(i, j, k2);
        if (tile instanceof ni && !CoreProxy.isClient(world) && (!(tile instanceof IDropControlInventory) || ((IDropControlInventory)tile).doDrop())) {
            Utils.dropItems(world, (ni)tile, i, j, k2);
        }
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).destroy();
        }
    }

    public static boolean checkPipesConnections(qj tile1, qj tile2) {
        if (tile1 == null || tile2 == null) {
            return false;
        }
        if (!(tile1 instanceof IPipeConnection) && !(tile2 instanceof IPipeConnection)) {
            return false;
        }
        Orientations o = Orientations.Unknown;
        if (tile1.l - 1 == tile2.l) {
            o = Orientations.XNeg;
        } else if (tile1.l + 1 == tile2.l) {
            o = Orientations.XPos;
        } else if (tile1.m - 1 == tile2.m) {
            o = Orientations.YNeg;
        } else if (tile1.m + 1 == tile2.m) {
            o = Orientations.YPos;
        } else if (tile1.n - 1 == tile2.n) {
            o = Orientations.ZNeg;
        } else if (tile1.n + 1 == tile2.n) {
            o = Orientations.ZPos;
        }
        if (tile1 instanceof IPipeConnection && !((IPipeConnection)tile1).isPipeConnected(o)) {
            return false;
        }
        return !(tile2 instanceof IPipeConnection) || ((IPipeConnection)tile2).isPipeConnected(o.reverse());
    }

    public static boolean checkPipesConnections(zy blockAccess, qj tile1, int x2, int y2, int z2) {
        qj tile2 = blockAccess.b(x2, y2, z2);
        return Utils.checkPipesConnections(tile1, tile2);
    }

    public static boolean checkLegacyPipesConnections(zy blockAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        vz b1 = vz.m[blockAccess.a(x1, y1, z1)];
        vz b2 = vz.m[blockAccess.a(x2, y2, z2)];
        if (!(b1 instanceof IFramePipeConnection) && !(b2 instanceof IFramePipeConnection)) {
            return false;
        }
        if (b1 instanceof IFramePipeConnection && !((IFramePipeConnection)b1).isPipeConnected(blockAccess, x1, y1, z1, x2, y2, z2)) {
            return false;
        }
        return !(b2 instanceof IFramePipeConnection) || ((IFramePipeConnection)b2).isPipeConnected(blockAccess, x2, y2, z2, x1, y1, z1);
    }

    public static void readStacksFromNBT(ph nbt, String name, kp[] stacks) {
        tx nbttaglist = nbt.n(name);
        for (int i = 0; i < stacks.length; ++i) {
            if (i < nbttaglist.d()) {
                ph nbttagcompound2 = (ph)nbttaglist.a(i);
                stacks[i] = kp.a((ph)nbttagcompound2);
                continue;
            }
            stacks[i] = null;
        }
    }

    public static void writeStacksToNBT(ph nbt, String name, kp[] stacks) {
        tx nbttaglist = new tx();
        for (int i = 0; i < stacks.length; ++i) {
            ph cpt = new ph();
            nbttaglist.a((jz)cpt);
            if (stacks[i] == null) continue;
            stacks[i].b(cpt);
        }
        nbt.a(name, (jz)nbttaglist);
    }

    public static kp consumeItem(kp stack) {
        if (stack.a == 1) {
            if (stack.a().j() != null) {
                return new kp(stack.a().j(), 1);
            }
            return null;
        }
        stack.a(1);
        return stack;
    }

    public static Object[] concat(Object[] first, Object[] second) {
        Object[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static float[] concat(float[] first, float[] second) {
        float[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

