/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;

public class TriggerInventory
extends Trigger {
    public State state;

    public TriggerInventory(int id2, State state) {
        super(id2);
        this.state = state;
    }

    @Override
    public int getIndexInTexture() {
        switch (this.state) {
            case Empty: {
                return 36;
            }
            case Contains: {
                return 37;
            }
            case Space: {
                return 38;
            }
        }
        return 39;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Inventory Empty";
            }
            case Contains: {
                return "Items in Inventory";
            }
            case Space: {
                return "Space in Inventory";
            }
        }
        return "Inventory Full";
    }

    @Override
    public boolean isTriggerActive(qj tile, ITriggerParameter parameter) {
        kp searchedStack = null;
        if (parameter != null) {
            searchedStack = parameter.getItem();
        }
        if (tile instanceof ni && ((ni)tile).c() > 0) {
            ni inv = Utils.getInventory((ni)tile);
            boolean foundItems = false;
            boolean foundSpace = false;
            for (int i = 0; i < inv.c(); ++i) {
                kp stack = inv.g_(i);
                if (parameter == null || parameter.getItemStack() == null) {
                    foundItems = foundItems || stack != null && stack.a > 0;
                } else if (stack != null && stack.a > 0) {
                    boolean bl = foundItems = foundItems || stack.c == parameter.getItemStack().c && stack.h() == parameter.getItemStack().h();
                }
                if (stack == null || stack.a == 0) {
                    foundSpace = true;
                    continue;
                }
                if (searchedStack == null || stack.a >= stack.b() || stack.c != searchedStack.c || stack.h() != searchedStack.h()) continue;
                foundSpace = true;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

