/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.CoreProxy;
import buildcraft.mod_BuildCraftCore;
import forge.Configuration;
import forge.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class BuildCraftConfiguration
extends Configuration {
    public BuildCraftConfiguration(File file, boolean loadLegacy) {
        super(file);
        if (loadLegacy) {
            this.loadLegacyProperties();
        }
    }

    public void loadLegacyProperties() {
        File cfgfile = CoreProxy.getPropertyFile();
        Properties props = new Properties();
        try {
            if (!cfgfile.exists()) {
                return;
            }
            if (cfgfile.canRead()) {
                FileInputStream fileinputstream = new FileInputStream(cfgfile);
                props.load(fileinputstream);
                fileinputstream.close();
            }
            this.getOrCreateProperty("stonePipe.id", "block", props.getProperty("stonePipe.blockId"));
            this.getOrCreateProperty("woodenPipe.id", "block", props.getProperty("woodenPipe.blockId"));
            this.getOrCreateProperty("ironPipe.id", "block", props.getProperty("ironPipe.blockId"));
            this.getOrCreateProperty("goldenPipe.id", "block", props.getProperty("goldenPipe.blockId"));
            this.getOrCreateProperty("diamondPipe.id", "block", props.getProperty("diamondPipe.blockId"));
            this.getOrCreateProperty("obsidianPipe.id", "block", props.getProperty("obsidianPipeBlock.blockId"));
            this.getOrCreateProperty("autoWorkbench.id", "block", props.getProperty("autoWorkbench.blockId"));
            this.getOrCreateProperty("miningWell.id", "block", props.getProperty("miningWell.blockId"));
            this.getOrCreateProperty("quarry.id", "block", props.getProperty("quarry.blockId"));
            this.getOrCreateProperty("drill.id", "block", props.getProperty("drill.blockId"));
            this.getOrCreateProperty("frame.id", "block", props.getProperty("frame.blockId"));
            this.getOrCreateProperty("marker.id", "block", props.getProperty("marker.blockId"));
            this.getOrCreateProperty("filler.id", "block", props.getProperty("filler.blockId"));
            this.getOrCreateProperty("woodenGearItem.id", "item", props.getProperty("woodenGearItem.id"));
            this.getOrCreateProperty("stoneGearItem.id", "item", props.getProperty("stoneGearItem.id"));
            this.getOrCreateProperty("ironGearItem.id", "item", props.getProperty("ironGearItem.id"));
            this.getOrCreateProperty("goldenGearItem.id", "item", props.getProperty("goldGearItem.id"));
            this.getOrCreateProperty("diamondGearItem.id", "item", props.getProperty("diamondGearItem.id"));
            this.getOrCreateProperty("mining.enabled", "general", props.getProperty("mining.enabled"));
            this.getOrCreateProperty("current.continuous", "general", props.getProperty("current.continous"));
            cfgfile.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        Property versionProp = null;
        if (!this.generalProperties.containsKey("version")) {
            versionProp = new Property();
            versionProp.name = "version";
            this.generalProperties.put("version", versionProp);
        } else {
            versionProp = (Property)this.generalProperties.get("version");
        }
        versionProp.value = mod_BuildCraftCore.version();
        super.save();
    }
}

