/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class BptDataStream
implements DataInput,
DataOutput {
    Writer writer;
    Reader reader;
    public boolean isFirst = true;

    public BptDataStream(Writer writer) {
        this.writer = writer;
    }

    public BptDataStream(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        char[] c = new char[b.length];
        this.reader.read(c);
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)c[i];
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.reader.read(new char[n]);
    }

    @Override
    public boolean readBoolean() throws IOException {
        String s = this.readUTF();
        return "T".equals(s);
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readLong();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return (short)this.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readLong();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (int)this.readLong();
    }

    @Override
    public char readChar() throws IOException {
        return this.readUTF().charAt(0);
    }

    @Override
    public int readInt() throws IOException {
        return (int)this.readLong();
    }

    @Override
    public long readLong() throws IOException {
        int i;
        StringBuilder builder = new StringBuilder();
        boolean exit = false;
        block3: while (!exit && (i = this.reader.read()) >= 0) {
            char c = (char)i;
            switch (c) {
                case ',': {
                    exit = true;
                    continue block3;
                }
            }
            builder.append(c);
        }
        return Long.parseLong(builder.toString());
    }

    @Override
    public float readFloat() throws IOException {
        return (float)this.readDouble();
    }

    @Override
    public double readDouble() throws IOException {
        int i;
        StringBuilder builder = new StringBuilder();
        boolean exit = false;
        block3: while (!exit && (i = this.reader.read()) >= 0) {
            char c = (char)i;
            switch (c) {
                case ',': {
                    exit = true;
                    continue block3;
                }
            }
            builder.append(c);
        }
        return Double.parseDouble(builder.toString());
    }

    @Override
    public String readLine() throws IOException {
        return null;
    }

    @Override
    public String readUTF() throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean exit = false;
        char c = (char)this.reader.read();
        if (c != '\"') {
            throw new IOException("String does not start with '\"' character");
        }
        block10: while (this.reader.ready() && !exit) {
            c = (char)this.reader.read();
            switch (c) {
                case '\\': {
                    c = (char)this.reader.read();
                    switch (c) {
                        case 'n': {
                            builder.append('\n');
                        }
                        case 'r': {
                            builder.append('\r');
                        }
                        case '\\': {
                            builder.append('\\');
                        }
                        case '\"': {
                            builder.append('\"');
                        }
                    }
                }
                case '\"': {
                    exit = true;
                    continue block10;
                }
            }
            builder.append(c);
        }
        int i = this.reader.read();
        c = (char)i;
        if (c != ',' && i > 0) {
            throw new IOException("Missing ',' at end of attribute");
        }
        return builder.toString();
    }

    @Override
    public void write(int b) throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.writeUTF("T");
        } else {
            this.writeUTF("F");
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeLong(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeUTF((char)v + "");
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeLong(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.handleWriteComma();
        this.writer.append(Long.toString(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeDouble(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.handleWriteComma();
        this.writer.append(Double.toString(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.handleWriteComma();
        this.writer.write("\"");
        for (char c : s.toCharArray()) {
            switch (c) {
                case '\n': {
                    this.writer.write("\\n");
                }
                case '\r': {
                    this.writer.write("\\r");
                }
                case '\"': {
                    this.writer.write("\\\"");
                }
                case '\\': {
                    this.writer.write("\\\\");
                }
            }
            this.writer.write(c);
        }
        this.writer.write("\"");
    }

    private void handleWriteComma() throws IOException {
        if (!this.isFirst) {
            this.writer.append(",");
        }
        this.isFirst = false;
    }
}

