/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.BptBlueprint;
import buildcraft.core.BptBuilderBase;
import buildcraft.core.BptSlot;
import buildcraft.core.IBuilderInventory;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;

public class BptBuilderBlueprint
extends BptBuilderBase {
    LinkedList clearList = new LinkedList();
    LinkedList primaryList = new LinkedList();
    LinkedList secondaryList = new LinkedList();
    LinkedList postProcessingList = new LinkedList();
    public TreeSet neededItems = new TreeSet(new Comparator(){

        public int compare(kp o1, kp o2) {
            if (o1.a > o2.a) {
                return -1;
            }
            if (o1.a < o2.a) {
                return 1;
            }
            if (o1.c > o2.c) {
                return -1;
            }
            if (o1.c < o2.c) {
                return 1;
            }
            if (o1.h() > o2.h()) {
                return -1;
            }
            if (o1.h() < o2.h()) {
                return 1;
            }
            return 0;
        }
    });

    public BptBuilderBlueprint(BptBlueprint bluePrint, ge world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
        BptSlot slot;
        int zCoord;
        int yCoord;
        int xCoord;
        int k2;
        int i;
        int j;
        for (j = bluePrint.sizeY - 1; j >= 0; --j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k2 = 0; k2 < bluePrint.sizeZ; ++k2) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y - bluePrint.anchorY;
                    zCoord = k2 + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k2];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.blockId = 0;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.ClearIfInvalid;
                    this.clearList.add(slot);
                }
            }
        }
        for (j = 0; j < bluePrint.sizeY; ++j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k2 = 0; k2 < bluePrint.sizeZ; ++k2) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y - bluePrint.anchorY;
                    zCoord = k2 + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k2];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.blockId = 0;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.Build;
                    if (slot.blockId != 0 && vz.m[slot.blockId].a()) {
                        this.primaryList.add(slot);
                    } else {
                        this.secondaryList.add(slot);
                    }
                    if (slot.blockId == 0) continue;
                    this.postProcessingList.add(slot.clone());
                }
            }
        }
        this.recomputeNeededItems();
    }

    private void checkDone() {
        this.recomputeNeededItems();
        this.done = this.clearList.size() == 0 && this.primaryList.size() == 0 && this.secondaryList.size() == 0;
    }

    @Override
    public BptSlot getNextBlock(ge world, IBuilderInventory inv) {
        if (this.clearList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.clearList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.primaryList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.primaryList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.secondaryList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.secondaryList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        this.checkDone();
        return null;
    }

    public BptSlot internalGetNextBlock(ge world, IBuilderInventory inv, LinkedList list) {
        LinkedList<BptSlot> failSlots = new LinkedList<BptSlot>();
        BptSlot result = null;
        while (list.size() > 0) {
            BptSlot slot = (BptSlot)list.removeFirst();
            boolean getNext = false;
            try {
                getNext = !slot.isValid(this.context) && !slot.ignoreBuilding();
            }
            catch (Throwable t) {
                t.printStackTrace();
                ModLoader.getLogger().throwing("BptBuilderBlueprint", "internalGetBlock", t);
                getNext = false;
            }
            if (!getNext) continue;
            if (slot.mode == BptSlot.Mode.ClearIfInvalid) {
                if (BuildCraftAPI.softBlock(world.a(slot.x, slot.y, slot.z))) continue;
                result = slot;
                break;
            }
            if (world.s().m() == 1) {
                result = slot;
                break;
            }
            if (this.checkRequirements(inv, slot)) {
                this.useRequirements(inv, slot);
                result = slot;
                break;
            }
            failSlots.add(slot);
        }
        list.addAll(failSlots);
        return result;
    }

    public boolean checkRequirements(IBuilderInventory inv, BptSlot slot) {
        if (slot.blockId == 0) {
            return true;
        }
        LinkedList<kp> tmpReq = new LinkedList<kp>();
        LinkedList<kp> tmpInv = new LinkedList<kp>();
        try {
            for (kp stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.j());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ModLoader.getLogger().throwing("BptBuilderBlueprint", "checkRequirements", t);
        }
        int size = inv.c();
        for (int i = 0; i < size; ++i) {
            if (!inv.isBuildingMaterial(i) || inv.g_(i) == null) continue;
            tmpInv.add(inv.g_(i).j());
        }
        for (kp reqStk : tmpReq) {
            for (kp invStk : tmpInv) {
                if (invStk == null || reqStk.c != invStk.c || invStk.a <= 0 || !invStk.d() && reqStk.h() != invStk.h()) continue;
                try {
                    slot.useItem(this.context, reqStk, invStk);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ModLoader.getLogger().throwing("BptBuilderBlueprint", "checkRequirements", t);
                }
                if (reqStk.a != 0) continue;
                break;
            }
            if (reqStk.a == 0) continue;
            return false;
        }
        return true;
    }

    public void useRequirements(IBuilderInventory inv, BptSlot slot) {
        if (slot.blockId == 0) {
            return;
        }
        LinkedList<kp> tmpReq = new LinkedList<kp>();
        try {
            for (kp stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.j());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ModLoader.getLogger().throwing("BptBuilderBlueprint", "useRequirements", t);
        }
        for (kp reqStk : tmpReq) {
            int size = inv.c();
            for (int i = 0; i <= size; ++i) {
                kp invStk;
                if (!inv.isBuildingMaterial(i)) {
                    // empty if block
                }
                if ((invStk = inv.g_(i)) == null || reqStk.c != invStk.c || invStk.a <= 0 || !invStk.d() && reqStk.h() != invStk.h()) continue;
                try {
                    slot.useItem(this.context, reqStk, invStk);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ModLoader.getLogger().throwing("BptBuilderBlueprint", "useRequirements", t);
                }
                if (invStk.a == 0) {
                    inv.a(i, null);
                } else {
                    inv.a(i, invStk);
                }
                if (reqStk.a == 0) break;
            }
            if (reqStk.a == 0) continue;
            return;
        }
    }

    public void recomputeNeededItems() {
        Integer num;
        LinkedList stacks;
        this.neededItems.clear();
        TreeMap<kp, Integer> computeStacks = new TreeMap<kp, Integer>(new Comparator(){

            public int compare(kp o1, kp o2) {
                if (o1.c > o2.c) {
                    return 1;
                }
                if (o1.c < o2.c) {
                    return -1;
                }
                if (o1.h() > o2.h()) {
                    return 1;
                }
                if (o1.h() < o2.h()) {
                    return -1;
                }
                return 0;
            }
        });
        for (BptSlot slot : this.primaryList) {
            stacks = new LinkedList();
            try {
                stacks = slot.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                ModLoader.getLogger().throwing("BptBuilderBlueprint", "recomputeIfNeeded", t);
            }
            for (kp stack : stacks) {
                if (stack == null || stack.c == 0) continue;
                if (!computeStacks.containsKey(stack)) {
                    computeStacks.put(stack.j(), stack.a);
                    continue;
                }
                num = (Integer)computeStacks.get(stack);
                num = num + stack.a;
                computeStacks.put(stack, num);
            }
        }
        for (BptSlot slot : this.secondaryList) {
            stacks = slot.getRequirements(this.context);
            for (kp stack : stacks) {
                if (stack == null || stack.c == 0 || stack.a == 0) continue;
                if (!computeStacks.containsKey(stack)) {
                    computeStacks.put(stack.j(), stack.a);
                    continue;
                }
                num = (Integer)computeStacks.get(stack);
                num = num + stack.a;
                computeStacks.put(stack, num);
            }
        }
        for (kp stack : computeStacks.keySet()) {
            if (stack.d()) {
                this.neededItems.add(new kp(stack.a()));
                continue;
            }
            this.neededItems.add(new kp(stack.c, ((Integer)computeStacks.get(stack)).intValue(), stack.h()));
        }
    }

    @Override
    public void postProcessing(ge world) {
        for (BptSlot s : this.postProcessingList) {
            try {
                s.postProcessing(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                ModLoader.getLogger().throwing("BptBuilderBlueprint", "postProcessing", t);
            }
        }
    }
}

