/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.core.BlockIndex;
import buildcraft.core.CoreProxy;
import buildcraft.core.EntityBlock;
import buildcraft.core.Utils;
import buildcraft.core.network.TileNetworkData;
import java.util.ArrayList;
import java.util.List;

public class Box
implements IBox {
    @TileNetworkData
    public int xMin;
    @TileNetworkData
    public int yMin;
    @TileNetworkData
    public int zMin;
    @TileNetworkData
    public int xMax;
    @TileNetworkData
    public int yMax;
    @TileNetworkData
    public int zMax;
    @TileNetworkData
    public boolean initialized;
    private EntityBlock[] lasers;

    public Box() {
        this.reset();
    }

    public void reset() {
        this.initialized = false;
        this.xMin = Integer.MAX_VALUE;
        this.yMin = Integer.MAX_VALUE;
        this.zMin = Integer.MAX_VALUE;
        this.xMax = Integer.MAX_VALUE;
        this.yMax = Integer.MAX_VALUE;
        this.zMax = Integer.MAX_VALUE;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.zMin = zMin;
        this.xMax = xMax;
        this.yMax = yMax;
        this.zMax = zMax;
        this.initialized = true;
    }

    public void initialize(Box box) {
        this.initialize(box.xMin, box.yMin, box.zMin, box.xMax, box.yMax, box.zMax);
    }

    public void initialize(IAreaProvider a) {
        this.initialize(a.xMin(), a.yMin(), a.zMin(), a.xMax(), a.yMax(), a.zMax());
    }

    public void initialize(ph nbttagcompound) {
        this.initialize(nbttagcompound.f("xMin"), nbttagcompound.f("yMin"), nbttagcompound.f("zMin"), nbttagcompound.f("xMax"), nbttagcompound.f("yMax"), nbttagcompound.f("zMax"));
    }

    public void initialize(int centerX, int centerY, int centerZ, int size) {
        this.initialize(centerX - size, centerY - size, centerZ - size, centerX + size, centerY + size, centerZ + size);
    }

    public List getBlocksInArea() {
        ArrayList<BlockIndex> blocks = new ArrayList<BlockIndex>();
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                for (int z = this.zMin; z <= this.zMax; ++z) {
                    blocks.add(new BlockIndex(x, y, z));
                }
            }
        }
        return blocks;
    }

    @Override
    public void expand(int amount) {
        this.xMin += amount;
        this.yMin += amount;
        this.zMin += amount;
        this.xMax += amount;
        this.yMax += amount;
        this.zMax += amount;
    }

    @Override
    public void contract(int amount) {
        this.expand(-amount);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return x >= this.xMin && x <= this.xMax && y >= this.yMin && y <= this.yMax && z >= this.zMin && z <= this.zMax;
    }

    public boolean contains(Position p) {
        return this.contains((int)p.x, (int)p.y, (int)p.z);
    }

    public boolean contains(BlockIndex i) {
        return this.contains(i.i, i.j, i.k);
    }

    @Override
    public Position pMin() {
        return new Position(this.xMin, this.yMin, this.zMin);
    }

    @Override
    public Position pMax() {
        return new Position(this.xMax, this.yMax, this.zMax);
    }

    public int sizeX() {
        return this.xMax - this.xMin + 1;
    }

    public int sizeY() {
        return this.yMax - this.yMin + 1;
    }

    public int sizeZ() {
        return this.zMax - this.zMin + 1;
    }

    public double centerX() {
        return (double)this.xMin + (double)this.sizeX() / 2.0;
    }

    public double centerY() {
        return (double)this.yMin + (double)this.sizeY() / 2.0;
    }

    public double centerZ() {
        return (double)this.zMin + (double)this.sizeZ() / 2.0;
    }

    public Box rotateLeft() {
        Box nBox = new Box();
        nBox.xMin = this.sizeZ() - 1 - this.zMin;
        nBox.yMin = this.yMin;
        nBox.zMin = this.xMin;
        nBox.xMax = this.sizeZ() - 1 - this.zMax;
        nBox.yMax = this.yMax;
        nBox.zMax = this.xMax;
        nBox.reorder();
        return nBox;
    }

    public void reorder() {
        int tmp;
        if (this.xMin > this.xMax) {
            tmp = this.xMin;
            this.xMin = this.xMax;
            this.xMax = tmp;
        }
        if (this.yMin > this.yMax) {
            tmp = this.yMin;
            this.yMin = this.yMax;
            this.yMax = tmp;
        }
        if (this.zMin > this.zMax) {
            tmp = this.zMin;
            this.zMin = this.zMax;
            this.zMax = tmp;
        }
    }

    @Override
    public void createLasers(ge world, LaserKind kind) {
        if (this.lasers == null) {
            this.lasers = Utils.createLaserBox(world, this.xMin, this.yMin, this.zMin, this.xMax, this.yMax, this.zMax, kind);
        }
    }

    @Override
    public void deleteLasers() {
        if (this.lasers != null) {
            for (EntityBlock b : this.lasers) {
                CoreProxy.removeEntity(b);
            }
            this.lasers = null;
        }
    }

    public void writeToNBT(ph nbttagcompound) {
        nbttagcompound.a("xMin", this.xMin);
        nbttagcompound.a("yMin", this.yMin);
        nbttagcompound.a("zMin", this.zMin);
        nbttagcompound.a("xMax", this.xMax);
        nbttagcompound.a("yMax", this.yMax);
        nbttagcompound.a("zMax", this.zMax);
    }

    public String toString() {
        return "{" + this.xMin + ", " + this.xMax + "}, {" + this.yMin + ", " + this.yMax + "}, {" + this.zMin + ", " + this.zMax + "}";
    }
}

