/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.Position;
import buildcraft.builders.TileMarker;
import buildcraft.core.BlockIndex;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import java.util.LinkedList;
import java.util.TreeSet;

public class TilePathMarker
extends TileMarker {
    public EntityLaser[] lasers = new EntityLaser[2];
    public int x0;
    public int y0;
    public int z0;
    public int x1;
    public int y1;
    public int z1;
    public boolean loadLink0 = false;
    public boolean loadLink1 = false;
    public boolean tryingToConnect = false;
    public TilePathMarker[] links = new TilePathMarker[2];
    public static int searchSize = 64;
    private static LinkedList availableMarkers = new LinkedList();

    public TilePathMarker() {
        availableMarkers.add(this);
    }

    public boolean isFullyConnected() {
        return this.lasers[0] != null && this.lasers[1] != null;
    }

    public boolean isLinkedTo(TilePathMarker pathMarker) {
        return this.links[0] == pathMarker || this.links[1] == pathMarker;
    }

    public void connect(TilePathMarker marker, EntityLaser laser) {
        if (this.lasers[0] == null) {
            this.lasers[0] = laser;
            this.links[0] = marker;
        } else if (this.lasers[1] == null) {
            this.lasers[1] = laser;
            this.links[1] = marker;
        }
        if (this.isFullyConnected()) {
            availableMarkers.remove(this);
        }
    }

    public void createLaserAndConnect(TilePathMarker pathMarker) {
        if (CoreProxy.isClient(this.k)) {
            return;
        }
        EntityLaser laser = new EntityLaser(this.k, new Position((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5), new Position((double)pathMarker.l + 0.5, (double)pathMarker.m + 0.5, (double)pathMarker.n + 0.5));
        laser.show();
        laser.setTexture(DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png");
        this.k.b((tv)laser);
        this.connect(pathMarker, laser);
        pathMarker.connect(this, laser);
    }

    private TilePathMarker findNearestAvailablePathMarker() {
        TilePathMarker nearestAvailable = null;
        double nearestDistance = 0.0;
        for (TilePathMarker t : availableMarkers) {
            double distance;
            if (t == this || t == this.links[0] || t == this.links[1] || (distance = Math.sqrt(Math.pow(this.l - t.l, 2.0) + Math.pow(this.m - t.m, 2.0) + Math.pow(this.n - t.n, 2.0))) > (double)searchSize || nearestAvailable != null && !(distance < nearestDistance)) continue;
            nearestAvailable = t;
            nearestDistance = distance;
        }
        return nearestAvailable;
    }

    @Override
    public void tryConnection() {
        if (this.isFullyConnected()) {
            return;
        }
        this.tryingToConnect = !this.tryingToConnect;
        this.k.j(this.l, this.m, this.n);
    }

    @Override
    public void q_() {
        TilePathMarker nearestPathMarker;
        super.q_();
        if (this.tryingToConnect && (nearestPathMarker = this.findNearestAvailablePathMarker()) != null) {
            this.createLaserAndConnect(nearestPathMarker);
            this.tryingToConnect = false;
            this.k.j(this.l, this.m, this.n);
        }
    }

    public LinkedList getPath() {
        TreeSet<BlockIndex> visitedPaths = new TreeSet<BlockIndex>();
        LinkedList<BlockIndex> res = new LinkedList<BlockIndex>();
        TilePathMarker nextTile = this;
        while (nextTile != null) {
            BlockIndex b = new BlockIndex(nextTile.l, nextTile.m, nextTile.n);
            visitedPaths.add(b);
            res.add(b);
            if (nextTile.links[0] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[0].l, nextTile.links[0].m, nextTile.links[0].n))) {
                nextTile = nextTile.links[0];
                continue;
            }
            if (nextTile.links[1] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[1].l, nextTile.links[1].m, nextTile.links[1].n))) {
                nextTile = nextTile.links[1];
                continue;
            }
            nextTile = null;
        }
        return res;
    }

    @Override
    public void j() {
        super.j();
        if (this.lasers[0] != null) {
            this.links[0].unlink(this);
            this.lasers[0].X();
        }
        if (this.lasers[1] != null) {
            this.links[1].unlink(this);
            this.lasers[1].X();
        }
        this.lasers = new EntityLaser[2];
        this.links = new TilePathMarker[2];
        availableMarkers.remove(this);
        this.tryingToConnect = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.loadLink0) {
            qj e0 = this.k.b(this.x0, this.y0, this.z0);
            if (this.links[0] != e0 && this.links[1] != e0 && e0 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e0);
            }
            this.loadLink0 = false;
        }
        if (this.loadLink1) {
            qj e1 = this.k.b(this.x1, this.y1, this.z1);
            if (this.links[0] != e1 && this.links[1] != e1 && e1 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e1);
            }
            this.loadLink1 = false;
        }
    }

    private void unlink(TilePathMarker tile) {
        if (this.links[0] == tile) {
            this.lasers[0] = null;
            this.links[0] = null;
        }
        if (this.links[1] == tile) {
            this.lasers[1] = null;
            this.links[1] = null;
        }
        if (!this.isFullyConnected() && !availableMarkers.contains(this)) {
            availableMarkers.add(this);
        }
    }

    @Override
    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.c("x0")) {
            this.x0 = nbttagcompound.f("x0");
            this.y0 = nbttagcompound.f("y0");
            this.z0 = nbttagcompound.f("z0");
            this.loadLink0 = true;
        }
        if (nbttagcompound.c("x1")) {
            this.x1 = nbttagcompound.f("x1");
            this.y1 = nbttagcompound.f("y1");
            this.z1 = nbttagcompound.f("z1");
            this.loadLink1 = true;
        }
    }

    @Override
    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        if (this.links[0] != null) {
            nbttagcompound.a("x0", this.links[0].l);
            nbttagcompound.a("y0", this.links[0].m);
            nbttagcompound.a("z0", this.links[0].n);
        }
        if (this.links[1] != null) {
            nbttagcompound.a("x1", this.links[1].l);
            nbttagcompound.a("y1", this.links[1].m);
            nbttagcompound.a("z1", this.links[1].n);
        }
    }

    public void onChunkUnload() {
        availableMarkers.remove(this);
    }

    public static void clearAvailableMarkersList() {
        availableMarkers.clear();
    }
}

