/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IBox;
import buildcraft.builders.FillerPattern;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;

public class FillerFlattener
extends FillerPattern {
    @Override
    public boolean iteratePattern(qj tile, IBox box, kp stackToPlace) {
        int xMin = (int)box.pMin().x;
        int yMin = (int)box.pMin().y;
        int zMin = (int)box.pMin().z;
        int xMax = (int)box.pMax().x;
        int zMax = (int)box.pMax().z;
        int sizeX = xMax - xMin + 1;
        int sizeZ = zMax - zMin + 1;
        boolean[][] blockedColumns = new boolean[sizeX][sizeZ];
        for (int i = 0; i < blockedColumns.length; ++i) {
            for (int j = 0; j < blockedColumns[0].length; ++j) {
                blockedColumns[i][j] = false;
            }
        }
        boolean found = false;
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int y = yMin - 1; y >= 0; --y) {
            found = false;
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (blockedColumns[x - xMin][z - zMin]) continue;
                    if (!BuildCraftAPI.softBlock(tile.k.a(x, y, z))) {
                        blockedColumns[x - xMin][z - zMin] = true;
                        continue;
                    }
                    found = true;
                    lastX = x;
                    lastY = y;
                    lastZ = z;
                }
            }
            if (!found) break;
        }
        if (lastX != Integer.MAX_VALUE && stackToPlace != null) {
            stackToPlace.a().a(stackToPlace, CoreProxy.getBuildCraftPlayer(tile.k), tile.k, lastX, lastY - 1, lastZ, 1);
        }
        if (lastX != Integer.MAX_VALUE) {
            return false;
        }
        return this.empty(xMin, yMin, zMin, xMax, 128, zMax, tile.k);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex() {
        return 69;
    }

    @Override
    public String getName() {
        return "Flatten";
    }
}

