/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import buildcraft.api.core.Orientations;

public class Position {
    public double x;
    public double y;
    public double z;
    public Orientations orientation;

    public Position(double ci, double cj2, double ck) {
        this.x = ci;
        this.y = cj2;
        this.z = ck;
        this.orientation = Orientations.Unknown;
    }

    public Position(double ci, double cj2, double ck, Orientations corientation) {
        this.x = ci;
        this.y = cj2;
        this.z = ck;
        this.orientation = corientation;
    }

    public Position(Position p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public Position(ph nbttagcompound) {
        this.x = nbttagcompound.i("i");
        this.y = nbttagcompound.i("j");
        this.z = nbttagcompound.i("k");
        this.orientation = Orientations.Unknown;
    }

    public Position(qj tile) {
        this.x = tile.l;
        this.y = tile.m;
        this.z = tile.n;
    }

    public void moveRight(double step) {
        switch (this.orientation) {
            case ZPos: {
                this.x -= step;
                break;
            }
            case ZNeg: {
                this.x += step;
                break;
            }
            case XPos: {
                this.z += step;
                break;
            }
            case XNeg: {
                this.z -= step;
                break;
            }
        }
    }

    public void moveLeft(double step) {
        this.moveRight(-step);
    }

    public void moveForwards(double step) {
        switch (this.orientation) {
            case YPos: {
                this.y += step;
                break;
            }
            case YNeg: {
                this.y -= step;
                break;
            }
            case ZPos: {
                this.z += step;
                break;
            }
            case ZNeg: {
                this.z -= step;
                break;
            }
            case XPos: {
                this.x += step;
                break;
            }
            case XNeg: {
                this.x -= step;
                break;
            }
        }
    }

    public void moveBackwards(double step) {
        this.moveForwards(-step);
    }

    public void moveUp(double step) {
        switch (this.orientation) {
            case ZPos: 
            case ZNeg: 
            case XPos: 
            case XNeg: {
                this.y += step;
                break;
            }
        }
    }

    public void moveDown(double step) {
        this.moveUp(-step);
    }

    public void writeToNBT(ph nbttagcompound) {
        nbttagcompound.a("i", this.x);
        nbttagcompound.a("j", this.y);
        nbttagcompound.a("k", this.z);
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public Position min(Position p) {
        return new Position(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public Position max(Position p) {
        return new Position(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }
}

