/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.BlockSignature;
import buildcraft.api.blueprints.BlueprintManager;
import buildcraft.api.blueprints.BptSlotInfo;
import buildcraft.api.blueprints.IBptContext;
import java.util.ArrayList;
import java.util.LinkedList;

public class BptBlock {
    public final int blockId;

    public BptBlock(int blockId) {
        this.blockId = blockId;
        BlueprintManager.blockBptProps[blockId] = this;
    }

    public void addRequirements(BptSlotInfo slot, IBptContext context, LinkedList requirements) {
        if (slot.blockId != 0) {
            if (slot.storedRequirements.size() != 0) {
                requirements.addAll(slot.storedRequirements);
            } else {
                requirements.add(new kp(slot.blockId, 1, slot.meta));
            }
        }
    }

    public void useItem(BptSlotInfo slot, IBptContext context, kp req, kp stack) {
        if (stack.d()) {
            if (req.h() + stack.h() <= stack.i()) {
                stack.b(req.h() + stack.h());
                req.a = 0;
            }
            if (stack.h() >= stack.i()) {
                stack.a = 0;
            }
        } else if (stack.a >= req.a) {
            stack.a -= req.a;
            req.a = 0;
        } else {
            req.a -= stack.a;
            stack.a = 0;
        }
        if (stack.a == 0 && stack.a().j() != null) {
            id container = stack.a().j();
            stack.c = container.bP;
            stack.a = 1;
            stack.b(0);
        }
    }

    public boolean isValid(BptSlotInfo slot, IBptContext context) {
        return slot.blockId == context.world().a(slot.x, slot.y, slot.z) && slot.meta == context.world().c(slot.x, slot.y, slot.z);
    }

    public void rotateLeft(BptSlotInfo slot, IBptContext context) {
    }

    public void buildBlock(BptSlotInfo slot, IBptContext context) {
        context.world().b(slot.x, slot.y, slot.z, slot.blockId, slot.meta);
        context.world().c(slot.x, slot.y, slot.z, slot.meta);
        if (vz.m[slot.blockId] instanceof sz) {
            qj tile = context.world().b(slot.x, slot.y, slot.z);
            slot.cpt.a("x", slot.x);
            slot.cpt.a("y", slot.y);
            slot.cpt.a("z", slot.z);
            if (tile != null) {
                tile.a(slot.cpt);
            }
        }
    }

    public boolean ignoreBuilding(BptSlotInfo slot) {
        return false;
    }

    public void initializeFromWorld(BptSlotInfo slot, IBptContext context, int x, int y, int z) {
        ArrayList req;
        qj tile;
        if (vz.m[slot.blockId] instanceof sz && (tile = context.world().b(x, y, z)) != null) {
            tile.b(slot.cpt);
        }
        if (vz.m[slot.blockId] != null && (req = vz.m[slot.blockId].getBlockDropped(context.world(), x, y, z, context.world().c(x, y, z), 0)) != null) {
            slot.storedRequirements.addAll(req);
        }
    }

    public void postProcessing(BptSlotInfo slot, IBptContext context) {
    }

    public BlockSignature getSignature(vz block) {
        BlockSignature sig = new BlockSignature();
        if (block.bO > 122) {
            qj tile;
            sig.blockClassName = block.getClass().getSimpleName();
            if (block instanceof sz && (tile = ((sz)block).a_()) != null) {
                sig.tileClassName = tile.getClass().getSimpleName();
            }
        }
        sig.blockName = block.q();
        sig.replaceNullWithStar();
        return sig;
    }

    public boolean match(vz block, BlockSignature sig) {
        if (block == null) {
            return false;
        }
        BlockSignature inst = BlueprintManager.getBlockSignature(block);
        return this.starMatch(sig.blockName, inst.blockName) && this.starMatch(sig.blockClassName, inst.blockClassName) && this.starMatch(sig.tileClassName, inst.tileClassName) && this.starMatch(sig.customField, inst.customField) && this.starMatch(sig.mod, inst.mod);
    }

    private boolean starMatch(String s1, String s2) {
        return s1.equals("*") || s2.equals("*") || s1.equals(s2);
    }
}

