/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.gates.Action;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.Trigger;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.transport.IExtractionHandler;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemBuildCraft;
import buildcraft.mod_BuildCraftCore;
import buildcraft.mod_BuildCraftTransport;
import buildcraft.transport.ActionEnergyPulser;
import buildcraft.transport.ActionSignalOutput;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.BptBlockPipe;
import buildcraft.transport.BptItemPipeDiamond;
import buildcraft.transport.BptItemPipeIron;
import buildcraft.transport.BptItemPipeWodden;
import buildcraft.transport.GuiHandler;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGate;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TileDummyGenericPipe;
import buildcraft.transport.TileDummyGenericPipe2;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TriggerPipeContents;
import buildcraft.transport.TriggerPipeSignal;
import buildcraft.transport.network.ConnectionHandler;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsStripes;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLiquidsCobblestone;
import buildcraft.transport.pipes.PipeLiquidsGold;
import buildcraft.transport.pipes.PipeLiquidsIron;
import buildcraft.transport.pipes.PipeLiquidsSandstone;
import buildcraft.transport.pipes.PipeLiquidsStone;
import buildcraft.transport.pipes.PipeLiquidsVoid;
import buildcraft.transport.pipes.PipeLiquidsWood;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import forge.IConnectionHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;
import forge.Property;
import java.util.LinkedList;

public class BuildCraftTransport {
    private static boolean initialized = false;
    public static BlockGenericPipe genericPipeBlock;
    public static int[] diamondTextures;
    public static boolean alwaysConnectPipes;
    public static boolean usePipeLoss;
    public static int maxItemsInPipes;
    public static id pipeWaterproof;
    public static id pipeGate;
    public static id pipeGateAutarchic;
    public static id redPipeWire;
    public static id bluePipeWire;
    public static id greenPipeWire;
    public static id yellowPipeWire;
    public static id pipeItemsWood;
    public static id pipeItemsStone;
    public static id pipeItemsCobblestone;
    public static id pipeItemsIron;
    public static id pipeItemsGold;
    public static id pipeItemsDiamond;
    public static id pipeItemsObsidian;
    public static id pipeItemsVoid;
    public static id pipeItemsSandstone;
    public static id pipeLiquidsWood;
    public static id pipeLiquidsCobblestone;
    public static id pipeLiquidsStone;
    public static id pipeLiquidsIron;
    public static id pipeLiquidsGold;
    public static id pipeLiquidsVoid;
    public static id pipeLiquidsSandstone;
    public static id pipePowerWood;
    public static id pipePowerStone;
    public static id pipePowerGold;
    public static id facadeItem;
    public static id pipeItemsStipes;
    public static id pipeStructureCobblestone;
    public static int groupItemsTrigger;
    public static Trigger triggerPipeEmpty;
    public static Trigger triggerPipeItems;
    public static Trigger triggerPipeLiquids;
    public static Trigger triggerPipeEnergy;
    public static Trigger triggerRedSignalActive;
    public static Trigger triggerRedSignalInactive;
    public static Trigger triggerBlueSignalActive;
    public static Trigger triggerBlueSignalInactive;
    public static Trigger triggerGreenSignalActive;
    public static Trigger triggerGreenSignalInactive;
    public static Trigger triggerYellowSignalActive;
    public static Trigger triggerYellowSignalInactive;
    public static Action actionRedSignal;
    public static Action actionBlueSignal;
    public static Action actionGreenSignal;
    public static Action actionYellowSignal;
    public static Action actionEnergyPulser;
    public static int pipeModel;
    private static LinkedList pipeRecipes;

    public static void load() {
        MinecraftForge.registerConnectionHandler((IConnectionHandler)new ConnectionHandler());
        MinecraftForge.setGuiHandler((BaseMod)mod_BuildCraftTransport.instance, (IGuiHandler)new GuiHandler());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        mod_BuildCraftCore.initialize();
        Property alwaysConnect = BuildCraftCore.mainConfiguration.getOrCreateBooleanProperty("pipes.alwaysConnect", "general", DefaultProps.PIPES_ALWAYS_CONNECT);
        alwaysConnect.comment = "set to false to deactivate pipe connection rules, true by default";
        Property PipeLoss = BuildCraftCore.mainConfiguration.getOrCreateBooleanProperty("power.usePipeLoss", "general", DefaultProps.USE_PIPELOSS);
        PipeLoss.comment = "Set to false to turn off energy loss over distance on all power pipes";
        Property exclusionItemList = BuildCraftCore.mainConfiguration.getOrCreateProperty("woodenPipe.item.exclusion", "block", "");
        String[] excludedItemBlocks = exclusionItemList.value.split(",");
        for (int j = 0; j < excludedItemBlocks.length; ++j) {
            excludedItemBlocks[j] = excludedItemBlocks[j].trim();
        }
        Property exclusionLiquidList = BuildCraftCore.mainConfiguration.getOrCreateProperty("woodenPipe.liquid.exclusion", "block", "");
        String[] excludedLiquidBlocks = exclusionLiquidList.value.split(",");
        for (int j = 0; j < excludedLiquidBlocks.length; ++j) {
            excludedLiquidBlocks[j] = excludedLiquidBlocks[j].trim();
        }
        PipeManager.registerExtractionHandler(new ExtractionHandler(excludedItemBlocks, excludedLiquidBlocks));
        Property maxItemInPipesProp = BuildCraftCore.mainConfiguration.getOrCreateIntProperty("pipes.maxItems", "general", 100);
        maxItemInPipesProp.comment = "pipes containing more than this amount of items will explode, not dropping any item";
        maxItemsInPipes = Integer.parseInt(maxItemInPipesProp.value);
        Property groupItemsTriggerProp = BuildCraftCore.mainConfiguration.getOrCreateIntProperty("pipes.groupItemsTrigger", "general", 32);
        groupItemsTriggerProp.comment = "when reaching this amount of objects in a pipes, items will be automatically grouped";
        groupItemsTrigger = Integer.parseInt(groupItemsTriggerProp.value);
        Property genericPipeId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("pipe.id", DefaultProps.GENERIC_PIPE_ID);
        BuildCraftCore.mainConfiguration.save();
        pipeWaterproof = new ItemBuildCraft(DefaultProps.PIPE_WATERPROOF_ID).d(33);
        pipeWaterproof.a("pipeWaterproof");
        CoreProxy.addName(pipeWaterproof, "Pipe Waterproof");
        genericPipeBlock = new BlockGenericPipe(Integer.parseInt(genericPipeId.value));
        CoreProxy.registerBlock((vz)genericPipeBlock);
        mod_BuildCraftTransport.registerTilePipe(TileDummyGenericPipe.class, "net.minecraft.src.buildcraft.GenericPipe");
        mod_BuildCraftTransport.registerTilePipe(TileDummyGenericPipe2.class, "net.minecraft.src.buildcraft.transport.TileGenericPipe");
        mod_BuildCraftTransport.registerTilePipe(TileGenericPipe.class, "net.minecraft.src.buildcraft.transport.GenericPipe");
        pipeItemsWood = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_WOOD_ID, PipeItemsWood.class, "Wooden Transport Pipe", vz.x, vz.M, vz.x);
        pipeItemsCobblestone = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_COBBLESTONE_ID, PipeItemsCobblestone.class, "Cobblestone Transport Pipe", vz.w, vz.M, vz.w);
        pipeItemsStone = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_STONE_ID, PipeItemsStone.class, "Stone Transport Pipe", vz.t, vz.M, vz.t);
        pipeItemsIron = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_IRON_ID, PipeItemsIron.class, "Iron Transport Pipe", id.n, vz.M, id.n);
        pipeItemsGold = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_GOLD_ID, PipeItemsGold.class, "Golden Transport Pipe", id.o, vz.M, id.o);
        pipeItemsDiamond = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_DIAMOND_ID, PipeItemsDiamond.class, "Diamond Transport Pipe", id.m, vz.M, id.m);
        pipeItemsObsidian = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_OBSIDIAN_ID, PipeItemsObsidian.class, "Obsidian Transport Pipe", vz.ap, vz.M, vz.ap);
        pipeLiquidsWood = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_WOOD_ID, PipeLiquidsWood.class, "Wooden Waterproof Pipe", pipeWaterproof, pipeItemsWood, null);
        pipeLiquidsCobblestone = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_COBBLESTONE_ID, PipeLiquidsCobblestone.class, "Cobblestone Waterproof Pipe", pipeWaterproof, pipeItemsCobblestone, null);
        pipeLiquidsStone = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_STONE_ID, PipeLiquidsStone.class, "Stone Waterproof Pipe", pipeWaterproof, pipeItemsStone, null);
        pipeLiquidsIron = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_IRON_ID, PipeLiquidsIron.class, "Iron Waterproof Pipe", pipeWaterproof, pipeItemsIron, null);
        pipeLiquidsGold = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_GOLD_ID, PipeLiquidsGold.class, "Golden Waterproof Pipe", pipeWaterproof, pipeItemsGold, null);
        pipePowerWood = BuildCraftTransport.createPipe(DefaultProps.PIPE_POWER_WOOD_ID, PipePowerWood.class, "Wooden Conductive Pipe", id.aB, pipeItemsWood, null);
        pipePowerStone = BuildCraftTransport.createPipe(DefaultProps.PIPE_POWER_STONE_ID, PipePowerStone.class, "Stone Conductive Pipe", id.aB, pipeItemsStone, null);
        pipePowerGold = BuildCraftTransport.createPipe(DefaultProps.PIPE_POWER_GOLD_ID, PipePowerGold.class, "Golden Conductive Pipe", id.aB, pipeItemsGold, null);
        pipeStructureCobblestone = BuildCraftTransport.createPipe(DefaultProps.PIPE_STRUCTURE_COBBLESTONE_ID, PipeStructureCobblestone.class, "Cobblestone Structure Pipe", vz.F, pipeItemsCobblestone, null);
        pipeItemsStipes = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_STRIPES_ID, PipeItemsStripes.class, "Stripes Transport Pipe", new kp(id.aV, 1, 0), vz.M, new kp(id.aV, 1, 11));
        pipeItemsVoid = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_VOID_ID, PipeItemsVoid.class, "Void Transport Pipe", new kp(id.aV, 1, 0), vz.M, id.aB);
        pipeLiquidsVoid = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_VOID_ID, PipeLiquidsVoid.class, "Void Waterproof Pipe", pipeWaterproof, pipeItemsVoid, null);
        pipeItemsSandstone = BuildCraftTransport.createPipe(DefaultProps.PIPE_ITEMS_SANDSTONE_ID, PipeItemsSandstone.class, "Sandstone Transport Pipe", vz.Q, vz.M, vz.Q);
        pipeLiquidsSandstone = BuildCraftTransport.createPipe(DefaultProps.PIPE_LIQUIDS_SANDSTONE_ID, PipeLiquidsSandstone.class, "Sandstone Waterproof Pipe", pipeWaterproof, pipeItemsSandstone, null);
        for (int j = 0; j < 6; ++j) {
            BuildCraftTransport.diamondTextures[j] = 22 + j;
        }
        redPipeWire = new ItemBuildCraft(DefaultProps.RED_PIPE_WIRE).d(64);
        redPipeWire.a("redPipeWire");
        CoreProxy.addName(redPipeWire, "Red Pipe Wire");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aV, 1, 1), new kp(id.aB, 1), new kp(id.n, 1)}, 500, new kp(redPipeWire, 8)));
        bluePipeWire = new ItemBuildCraft(DefaultProps.BLUE_PIPE_WIRE).d(65);
        bluePipeWire.a("bluePipeWire");
        CoreProxy.addName(bluePipeWire, "Blue Pipe Wire");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aV, 1, 4), new kp(id.aB, 1), new kp(id.n, 1)}, 500, new kp(bluePipeWire, 8)));
        greenPipeWire = new ItemBuildCraft(DefaultProps.GREEN_PIPE_WIRE).d(66);
        greenPipeWire.a("greenPipeWire");
        CoreProxy.addName(greenPipeWire, "Green Pipe Wire");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aV, 1, 2), new kp(id.aB, 1), new kp(id.n, 1)}, 500, new kp(greenPipeWire, 8)));
        yellowPipeWire = new ItemBuildCraft(DefaultProps.YELLOW_PIPE_WIRE).d(67);
        yellowPipeWire.a("yellowPipeWire");
        CoreProxy.addName(yellowPipeWire, "Yellow Pipe Wire");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aV, 1, 11), new kp(id.aB, 1), new kp(id.n, 1)}, 500, new kp(yellowPipeWire, 8)));
        pipeGate = new ItemGate(DefaultProps.GATE_ID, 0).d(35);
        pipeGate.a("pipeGate");
        pipeGateAutarchic = new ItemGate(DefaultProps.GATE_AUTARCHIC_ID, 1).d(35);
        pipeGateAutarchic.a("pipeGateAutarchic");
        facadeItem = new ItemFacade(DefaultProps.PIPE_FACADE_ID);
        facadeItem.a("pipeFacade");
        ItemFacade.initialize();
        alwaysConnectPipes = Boolean.parseBoolean(alwaysConnect.value);
        usePipeLoss = Boolean.parseBoolean(PipeLoss.value);
        BuildCraftCore.mainConfiguration.save();
        new BptBlockPipe(BuildCraftTransport.genericPipeBlock.bO);
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsWood.bP] = new BptItemPipeWodden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeLiquidsWood.bP] = new BptItemPipeWodden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsIron.bP] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeLiquidsIron.bP] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsDiamond.bP] = new BptItemPipeDiamond();
        ActionManager.registerTriggerProvider(new PipeTriggerProvider());
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftTransport.loadRecipes();
        }
    }

    public static void loadRecipes() {
        CoreProxy.addCraftingRecipe(new kp(pipeWaterproof, 1), new Object[]{"W ", "  ", Character.valueOf('W'), new kp(id.aV, 1, 2)});
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                CoreProxy.addShapelessRecipe(pipe.result, pipe.input);
                continue;
            }
            CoreProxy.addCraftingRecipe(pipe.result, pipe.input);
        }
    }

    private static id createPipe(int defaultID, Class clas, String descr, Object ingredient1, Object ingredient2, Object ingredient3) {
        String name = Character.toLowerCase(clas.getSimpleName().charAt(0)) + clas.getSimpleName().substring(1);
        Property prop = BuildCraftCore.mainConfiguration.getOrCreateIntProperty(name + ".id", "item", defaultID);
        int id2 = Integer.parseInt(prop.value);
        ItemPipe res = BlockGenericPipe.registerPipe(id2, clas);
        res.a(clas.getSimpleName());
        CoreProxy.addName(res, descr);
        PipeRecipe recipe = new PipeRecipe();
        if (ingredient1 != null && ingredient2 != null && ingredient3 != null) {
            recipe.result = new kp((id)res, 8);
            recipe.input = new Object[]{"   ", "ABC", "   ", Character.valueOf('A'), ingredient1, Character.valueOf('B'), ingredient2, Character.valueOf('C'), ingredient3};
            pipeRecipes.add(recipe);
        } else if (ingredient1 != null && ingredient2 != null) {
            recipe.isShapeless = true;
            recipe.result = new kp((id)res, 1);
            recipe.input = new Object[]{ingredient1, ingredient2};
            pipeRecipes.add(recipe);
        }
        return res;
    }

    public static void initializeModel(mod_BuildCraftTransport mod) {
        pipeModel = ModLoader.getUniqueBlockModelID((BaseMod)mod, (boolean)true);
    }

    static {
        diamondTextures = new int[6];
        triggerPipeEmpty = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_EMPTY, TriggerPipeContents.Kind.Empty);
        triggerPipeItems = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_ITEMS, TriggerPipeContents.Kind.ContainsItems);
        triggerPipeLiquids = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_LIQUIDS, TriggerPipeContents.Kind.ContainsLiquids);
        triggerPipeEnergy = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_ENERGY, TriggerPipeContents.Kind.ContainsEnergy);
        triggerRedSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_ACTIVE, true, IPipe.WireColor.Red);
        triggerRedSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_INACTIVE, false, IPipe.WireColor.Red);
        triggerBlueSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_ACTIVE, true, IPipe.WireColor.Blue);
        triggerBlueSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_INACTIVE, false, IPipe.WireColor.Blue);
        triggerGreenSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_ACTIVE, true, IPipe.WireColor.Green);
        triggerGreenSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_INACTIVE, false, IPipe.WireColor.Green);
        triggerYellowSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_ACTIVE, true, IPipe.WireColor.Yellow);
        triggerYellowSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_INACTIVE, false, IPipe.WireColor.Yellow);
        actionRedSignal = new ActionSignalOutput(DefaultProps.ACTION_RED_SIGNAL, IPipe.WireColor.Red);
        actionBlueSignal = new ActionSignalOutput(DefaultProps.ACTION_BLUE_SIGNAL, IPipe.WireColor.Blue);
        actionGreenSignal = new ActionSignalOutput(DefaultProps.ACTION_GREEN_SIGNAL, IPipe.WireColor.Green);
        actionYellowSignal = new ActionSignalOutput(DefaultProps.ACTION_YELLOW_SIGNAL, IPipe.WireColor.Yellow);
        actionEnergyPulser = new ActionEnergyPulser(DefaultProps.ACTION_ENERGY_PULSER);
        pipeRecipes = new LinkedList();
    }

    private static class ExtractionHandler
    implements IExtractionHandler {
        private final String[] items;
        private final String[] liquids;

        public ExtractionHandler(String[] items, String[] liquids) {
            this.items = items;
            this.liquids = liquids;
        }

        @Override
        public boolean canExtractItems(IPipe pipe, ge world, int i, int j, int k2) {
            return this.testStrings(this.items, world, i, j, k2);
        }

        @Override
        public boolean canExtractLiquids(IPipe pipe, ge world, int i, int j, int k2) {
            return this.testStrings(this.liquids, world, i, j, k2);
        }

        private boolean testStrings(String[] excludedBlocks, ge world, int i, int j, int k2) {
            int id2 = world.a(i, j, k2);
            vz block = vz.m[id2];
            if (block == null) {
                return false;
            }
            int meta = world.c(i, j, k2);
            for (String excluded : excludedBlocks) {
                if (excluded.equals(block.q())) {
                    return false;
                }
                String[] tokens = excluded.split(":");
                if (!tokens[0].equals(Integer.toString(id2)) || tokens.length != 1 && !tokens[1].equals(Integer.toString(meta))) continue;
                return false;
            }
            return true;
        }
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        kp result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

