/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.bptblocks.BptBlockInventory;
import buildcraft.api.bptblocks.BptBlockRotateMeta;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemRedstoneChipset;
import buildcraft.mod_BuildCraftCore;
import buildcraft.mod_BuildCraftSilicon;
import buildcraft.silicon.BlockAssemblyTable;
import buildcraft.silicon.BlockLaser;
import buildcraft.silicon.GuiHandler;
import buildcraft.silicon.network.ConnectionHandler;
import forge.IConnectionHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;
import forge.Property;

public class BuildCraftSilicon {
    public static int laserBlockModel;
    public static id redstoneChipset;
    public static BlockLaser laserBlock;
    public static BlockAssemblyTable assemblyTableBlock;
    private static boolean initialized;

    public static void load() {
        MinecraftForge.registerConnectionHandler((IConnectionHandler)new ConnectionHandler());
        MinecraftForge.setGuiHandler((BaseMod)mod_BuildCraftSilicon.instance, (IGuiHandler)new GuiHandler());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        mod_BuildCraftCore.initialize();
        Property laserId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("laser.id", DefaultProps.LASER_ID);
        Property assemblyTableId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("assemblyTable.id", DefaultProps.ASSEMBLY_TABLE_ID);
        BuildCraftCore.mainConfiguration.save();
        laserBlock = new BlockLaser(Integer.parseInt(laserId.value));
        CoreProxy.addName(laserBlock.a("laserBlock"), "Laser");
        CoreProxy.registerBlock((vz)laserBlock);
        assemblyTableBlock = new BlockAssemblyTable(Integer.parseInt(assemblyTableId.value));
        CoreProxy.addName(assemblyTableBlock.a("assemblyTableBlock"), "Assembly Table");
        CoreProxy.registerBlock((vz)assemblyTableBlock);
        redstoneChipset = new ItemRedstoneChipset(DefaultProps.REDSTONE_CHIPSET);
        redstoneChipset.a("redstoneChipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aB)}, 10000, new kp(redstoneChipset, 1, 0)));
        CoreProxy.addName(new kp(redstoneChipset, 1, 0), "Redstone Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aB), new kp(id.n)}, 20000, new kp(redstoneChipset, 1, 1)));
        CoreProxy.addName(new kp(redstoneChipset, 1, 1), "Redstone Iron Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aB), new kp(id.o)}, 40000, new kp(redstoneChipset, 1, 2)));
        CoreProxy.addName(new kp(redstoneChipset, 1, 2), "Redstone Golden Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aB), new kp(id.m)}, 80000, new kp(redstoneChipset, 1, 3)));
        CoreProxy.addName(new kp(redstoneChipset, 1, 3), "Redstone Diamond Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(id.aB), new kp(id.bm)}, 40000, new kp(redstoneChipset, 2, 4)));
        CoreProxy.addName(new kp(redstoneChipset, 1, 4), "Pulsating Chipset");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(redstoneChipset, 1, 0)}, 20000, new kp(BuildCraftTransport.pipeGate, 1, 0)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGate, 1, 0), "Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(BuildCraftTransport.pipeGate, 1, 0), new kp(redstoneChipset, 1, 4), new kp(redstoneChipset, 1, 1)}, 10000, new kp(BuildCraftTransport.pipeGateAutarchic, 1, 0)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 0), "Autarchic Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(redstoneChipset, 1, 1), new kp(BuildCraftTransport.redPipeWire)}, 40000, new kp(BuildCraftTransport.pipeGate, 1, 1)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGate, 1, 1), "Iron AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(BuildCraftTransport.pipeGate, 1, 1), new kp(redstoneChipset, 1, 4), new kp(redstoneChipset, 1, 1)}, 20000, new kp(BuildCraftTransport.pipeGateAutarchic, 1, 1)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 1), "Autarchic Iron AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(redstoneChipset, 1, 1), new kp(BuildCraftTransport.redPipeWire)}, 40000, new kp(BuildCraftTransport.pipeGate, 1, 2)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGate, 1, 2), "Iron OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(BuildCraftTransport.pipeGate, 1, 2), new kp(redstoneChipset, 1, 4), new kp(redstoneChipset, 1, 1)}, 20000, new kp(BuildCraftTransport.pipeGateAutarchic, 1, 2)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 2), "Autarchic Iron OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(redstoneChipset, 1, 2), new kp(BuildCraftTransport.redPipeWire), new kp(BuildCraftTransport.bluePipeWire)}, 80000, new kp(BuildCraftTransport.pipeGate, 1, 3)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGate, 1, 3), "Gold AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(BuildCraftTransport.pipeGate, 1, 3), new kp(redstoneChipset, 1, 4), new kp(redstoneChipset, 1, 1)}, 40000, new kp(BuildCraftTransport.pipeGateAutarchic, 1, 3)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 3), "Autarchic Gold AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(redstoneChipset, 1, 2), new kp(BuildCraftTransport.redPipeWire), new kp(BuildCraftTransport.bluePipeWire)}, 80000, new kp(BuildCraftTransport.pipeGate, 1, 4)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGate, 1, 4), "Gold OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(BuildCraftTransport.pipeGate, 1, 4), new kp(redstoneChipset, 1, 4), new kp(redstoneChipset, 1, 1)}, 40000, new kp(BuildCraftTransport.pipeGateAutarchic, 1, 4)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 4), "Autarchic Gold OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(redstoneChipset, 1, 3), new kp(BuildCraftTransport.redPipeWire), new kp(BuildCraftTransport.bluePipeWire), new kp(BuildCraftTransport.greenPipeWire), new kp(BuildCraftTransport.yellowPipeWire)}, 160000, new kp(BuildCraftTransport.pipeGate, 1, 5)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGate, 1, 5), "Diamond AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(BuildCraftTransport.pipeGate, 1, 5), new kp(redstoneChipset, 1, 4), new kp(redstoneChipset, 1, 1)}, 80000, new kp(BuildCraftTransport.pipeGateAutarchic, 1, 5)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 5), "Autarchic Diamond AND Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(redstoneChipset, 1, 3), new kp(BuildCraftTransport.redPipeWire), new kp(BuildCraftTransport.bluePipeWire), new kp(BuildCraftTransport.greenPipeWire), new kp(BuildCraftTransport.yellowPipeWire)}, 160000, new kp(BuildCraftTransport.pipeGate, 1, 6)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGate, 1, 6), "Diamond OR Gate");
        AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new kp[]{new kp(BuildCraftTransport.pipeGate, 1, 6), new kp(redstoneChipset, 1, 4), new kp(redstoneChipset, 1, 1)}, 80000, new kp(BuildCraftTransport.pipeGateAutarchic, 1, 6)));
        CoreProxy.addName(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 6), "Autarchic Diamond OR Gate");
        new BptBlockRotateMeta(BuildCraftSilicon.laserBlock.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(BuildCraftSilicon.assemblyTableBlock.bO);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftSilicon.loadRecipes();
        }
    }

    public static void loadRecipes() {
        jb craftingmanager = jb.a();
        CoreProxy.addCraftingRecipe(new kp((vz)laserBlock), new Object[]{"ORR", "DDR", "ORR", Character.valueOf('O'), vz.ap, Character.valueOf('R'), id.aB, Character.valueOf('D'), id.m});
        CoreProxy.addCraftingRecipe(new kp((vz)assemblyTableBlock), new Object[]{"ORO", "ODO", "OGO", Character.valueOf('O'), vz.ap, Character.valueOf('R'), id.aB, Character.valueOf('D'), id.m, Character.valueOf('G'), BuildCraftCore.diamondGearItem});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGate, 1, 2), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGate, 1, 1)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGate, 1, 1), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGate, 1, 2)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGate, 1, 4), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGate, 1, 3)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGate, 1, 3), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGate, 1, 4)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGate, 1, 6), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGate, 1, 5)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGate, 1, 5), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGate, 1, 6)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 2), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGateAutarchic, 1, 1)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 1), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGateAutarchic, 1, 2)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 4), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGateAutarchic, 1, 3)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 3), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGateAutarchic, 1, 4)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 6), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGateAutarchic, 1, 5)});
        CoreProxy.addShapelessRecipe(new kp(BuildCraftTransport.pipeGateAutarchic, 1, 5), new Object[]{new kp(redstoneChipset, 1, 0), new kp(BuildCraftTransport.pipeGateAutarchic, 1, 6)});
    }

    public static void initializeModel(BaseMod mod) {
        laserBlockModel = ModLoader.getUniqueBlockModelID((BaseMod)mod, (boolean)true);
    }

    static {
        initialized = false;
    }
}

