/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockFrame;
import buildcraft.factory.BlockHopper;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockQuarry;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.BptBlockAutoWorkbench;
import buildcraft.factory.BptBlockFrame;
import buildcraft.factory.BptBlockRefinery;
import buildcraft.factory.BptBlockTank;
import buildcraft.factory.GuiHandler;
import buildcraft.factory.TileAssemblyTable;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileHopper;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileQuarry;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.network.ConnectionHandler;
import buildcraft.mod_BuildCraftCore;
import buildcraft.mod_BuildCraftFactory;
import buildcraft.silicon.TileLaser;
import forge.IConnectionHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;
import forge.Property;

public class BuildCraftFactory {
    public static BlockQuarry quarryBlock;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockFrame frameBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockHopper hopperBlock;
    public static boolean hopperDisabled;
    public static int drillTexture;
    private static boolean initialized;
    public static boolean allowMining;

    public static void load() {
        MinecraftForge.registerConnectionHandler((IConnectionHandler)new ConnectionHandler());
        MinecraftForge.setGuiHandler((BaseMod)mod_BuildCraftFactory.instance, (IGuiHandler)new GuiHandler());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        mod_BuildCraftCore.initialize();
        BuildCraftCore.initializeGears();
        allowMining = Boolean.parseBoolean(BuildCraftCore.mainConfiguration.getOrCreateBooleanProperty((String)"mining.enabled", (String)"general", (boolean)true).value);
        Property minigWellId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("miningWell.id", DefaultProps.MINING_WELL_ID);
        Property plainPipeId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("drill.id", DefaultProps.DRILL_ID);
        Property autoWorkbenchId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("autoWorkbench.id", DefaultProps.AUTO_WORKBENCH_ID);
        Property frameId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("frame.id", DefaultProps.FRAME_ID);
        Property quarryId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("quarry.id", DefaultProps.QUARRY_ID);
        Property pumpId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("pump.id", DefaultProps.PUMP_ID);
        Property tankId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("tank.id", DefaultProps.TANK_ID);
        Property refineryId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("refinery.id", DefaultProps.REFINERY_ID);
        Property hopperId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("hopper.id", DefaultProps.HOPPER_ID);
        Property hopperDisable = BuildCraftCore.mainConfiguration.getOrCreateBooleanProperty("hopper.disabled", "Block Savers", false);
        BuildCraftCore.mainConfiguration.save();
        miningWellBlock = new BlockMiningWell(Integer.parseInt(minigWellId.value));
        CoreProxy.registerBlock(miningWellBlock.a("miningWellBlock"));
        CoreProxy.addName((Object)miningWellBlock, "Mining Well");
        plainPipeBlock = new BlockPlainPipe(Integer.parseInt(plainPipeId.value));
        CoreProxy.registerBlock(plainPipeBlock.a("plainPipeBlock"));
        CoreProxy.addName(plainPipeBlock, "Mining Pipe");
        autoWorkbenchBlock = new BlockAutoWorkbench(Integer.parseInt(autoWorkbenchId.value));
        CoreProxy.registerBlock(autoWorkbenchBlock.a("autoWorkbenchBlock"));
        CoreProxy.addName((Object)autoWorkbenchBlock, "Automatic Crafting Table");
        frameBlock = new BlockFrame(Integer.parseInt(frameId.value));
        CoreProxy.registerBlock(frameBlock.a("frameBlock"));
        CoreProxy.addName(frameBlock, "Frame");
        quarryBlock = new BlockQuarry(Integer.parseInt(quarryId.value));
        CoreProxy.registerBlock(quarryBlock.a("machineBlock"));
        CoreProxy.addName((Object)quarryBlock, "Quarry");
        tankBlock = new BlockTank(Integer.parseInt(tankId.value));
        CoreProxy.registerBlock(tankBlock.a("tankBlock"));
        CoreProxy.addName((Object)tankBlock, "Tank");
        pumpBlock = new BlockPump(Integer.parseInt(pumpId.value));
        CoreProxy.registerBlock(pumpBlock.a("pumpBlock"));
        CoreProxy.addName((Object)pumpBlock, "Pump");
        refineryBlock = new BlockRefinery(Integer.parseInt(refineryId.value));
        CoreProxy.registerBlock(refineryBlock.a("refineryBlock"));
        CoreProxy.addName((Object)refineryBlock, "Refinery");
        hopperDisabled = Boolean.parseBoolean(hopperDisable.value);
        if (!hopperDisabled) {
            hopperBlock = new BlockHopper(Integer.parseInt(hopperId.value));
            CoreProxy.registerBlock(hopperBlock.a("blockHopper"));
            CoreProxy.addName((Object)hopperBlock, "Hopper");
        }
        CoreProxy.registerTileEntity(TileQuarry.class, "Machine");
        CoreProxy.registerTileEntity(TileMiningWell.class, "MiningWell");
        CoreProxy.registerTileEntity(TileAutoWorkbench.class, "AutoWorkbench");
        CoreProxy.registerTileEntity(TilePump.class, "net.minecraft.src.buildcraft.factory.TilePump");
        CoreProxy.registerTileEntity(TileTank.class, "net.minecraft.src.buildcraft.factory.TileTank");
        CoreProxy.registerTileEntity(TileRefinery.class, "net.minecraft.src.buildcraft.factory.Refinery");
        CoreProxy.registerTileEntity(TileLaser.class, "net.minecraft.src.buildcraft.factory.TileLaser");
        CoreProxy.registerTileEntity(TileAssemblyTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyTable");
        if (!hopperDisabled) {
            CoreProxy.registerTileEntity(TileHopper.class, "net.minecraft.src.buildcraft.factory.TileHopper");
        }
        drillTexture = 33;
        BuildCraftCore.mainConfiguration.save();
        new BptBlockAutoWorkbench(BuildCraftFactory.autoWorkbenchBlock.bO);
        new BptBlockFrame(BuildCraftFactory.frameBlock.bO);
        new BptBlockRefinery(BuildCraftFactory.refineryBlock.bO);
        new BptBlockTank(BuildCraftFactory.tankBlock.bO);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    public static void loadRecipes() {
        if (allowMining) {
            CoreProxy.addCraftingRecipe(new kp((vz)miningWellBlock, 1), new Object[]{"ipi", "igi", "iPi", Character.valueOf('p'), id.aB, Character.valueOf('i'), id.n, Character.valueOf('g'), BuildCraftCore.ironGearItem, Character.valueOf('P'), id.f});
            CoreProxy.addCraftingRecipe(new kp((vz)quarryBlock), new Object[]{"ipi", "gig", "dDd", Character.valueOf('i'), BuildCraftCore.ironGearItem, Character.valueOf('p'), id.aB, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('d'), BuildCraftCore.diamondGearItem, Character.valueOf('D'), id.A});
        }
        CoreProxy.addCraftingRecipe(new kp((vz)autoWorkbenchBlock), new Object[]{" g ", "gwg", " g ", Character.valueOf('w'), vz.ay, Character.valueOf('g'), BuildCraftCore.woodenGearItem});
        CoreProxy.addCraftingRecipe(new kp((vz)pumpBlock), new Object[]{"T ", "W ", Character.valueOf('T'), tankBlock, Character.valueOf('W'), miningWellBlock});
        CoreProxy.addCraftingRecipe(new kp((vz)tankBlock), new Object[]{"ggg", "g g", "ggg", Character.valueOf('g'), vz.M});
        CoreProxy.addCraftingRecipe(new kp((vz)refineryBlock), new Object[]{"   ", "RTR", "TGT", Character.valueOf('T'), tankBlock, Character.valueOf('G'), BuildCraftCore.diamondGearItem, Character.valueOf('R'), vz.aQ});
        if (!hopperDisabled) {
            CoreProxy.addCraftingRecipe(new kp((vz)hopperBlock), new Object[]{"ICI", "IGI", " I ", Character.valueOf('I'), id.n, Character.valueOf('C'), vz.au, Character.valueOf('G'), BuildCraftCore.stoneGearItem});
        }
    }

    static {
        initialized = false;
        allowMining = true;
    }
}

