/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.gates.Trigger;
import buildcraft.api.liquids.LiquidData;
import buildcraft.api.liquids.LiquidManager;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemBuildCraft;
import buildcraft.energy.BlockEngine;
import buildcraft.energy.BlockOilFlowing;
import buildcraft.energy.BlockOilStill;
import buildcraft.energy.BptBlockEngine;
import buildcraft.energy.Engine;
import buildcraft.energy.GuiHandler;
import buildcraft.energy.ItemBucketOil;
import buildcraft.energy.ItemEngine;
import buildcraft.energy.OilBucketHandler;
import buildcraft.energy.OilPopulate;
import buildcraft.energy.TriggerEngineHeat;
import buildcraft.mod_BuildCraftEnergy;
import forge.IBucketHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;
import forge.Property;
import java.util.Random;
import java.util.TreeMap;

public class BuildCraftEnergy {
    public static final int ENERGY_REMOVE_BLOCK = 25;
    public static final int ENERGY_EXTRACT_ITEM = 2;
    public static BlockEngine engineBlock;
    public static vz oilMoving;
    public static vz oilStill;
    public static id bucketOil;
    public static id bucketFuel;
    public static id fuel;
    public static TreeMap saturationStored;
    private static boolean initialized;
    public static Trigger triggerBlueEngineHeat;
    public static Trigger triggerGreenEngineHeat;
    public static Trigger triggerYellowEngineHeat;
    public static Trigger triggerRedEngineHeat;

    public static void load() {
        MinecraftForge.setGuiHandler((BaseMod)mod_BuildCraftEnergy.instance, (IGuiHandler)new GuiHandler());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        BuildCraftCore.initialize();
        Property engineId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("engine.id", DefaultProps.ENGINE_ID);
        Property oilStillId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("oilStill.id", DefaultProps.OIL_STILL_ID);
        Property oilMovingId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("oilMoving.id", DefaultProps.OIL_MOVING_ID);
        Property bucketOilId = BuildCraftCore.mainConfiguration.getOrCreateIntProperty("bucketOil.id", "item", DefaultProps.BUCKET_OIL_ID);
        Property bucketFuelId = BuildCraftCore.mainConfiguration.getOrCreateIntProperty("bucketFuel.id", "item", DefaultProps.BUCKET_FUEL_ID);
        Property itemFuelId = BuildCraftCore.mainConfiguration.getOrCreateIntProperty("fuel.id", "item", DefaultProps.FUEL_ID);
        BuildCraftCore.mainConfiguration.save();
        engineBlock = new BlockEngine(Integer.parseInt(engineId.value));
        id.d[BuildCraftEnergy.engineBlock.bO] = null;
        id.d[BuildCraftEnergy.engineBlock.bO] = new ItemEngine(BuildCraftEnergy.engineBlock.bO - 256);
        CoreProxy.addName(new kp((vz)engineBlock, 1, 0), "Redstone Engine");
        CoreProxy.addName(new kp((vz)engineBlock, 1, 1), "Steam Engine");
        CoreProxy.addName(new kp((vz)engineBlock, 1, 2), "Combustion Engine");
        oilMoving = new BlockOilFlowing(Integer.parseInt(oilMovingId.value), na.g).a("oil");
        CoreProxy.addName(oilMoving.a("oilMoving"), "Oil");
        CoreProxy.registerBlock(oilMoving);
        oilStill = new BlockOilStill(Integer.parseInt(oilStillId.value), na.g).a("oil");
        CoreProxy.addName(oilStill.a("oilStill"), "Oil");
        CoreProxy.registerBlock(oilStill);
        if (BuildCraftEnergy.oilMoving.bO + 1 != BuildCraftEnergy.oilStill.bO) {
            throw new RuntimeException("Oil Still id must be Oil Moving id + 1");
        }
        MinecraftForge.registerCustomBucketHandler((IBucketHandler)new OilBucketHandler());
        bucketOil = new ItemBucketOil(Integer.parseInt(bucketOilId.value)).a("bucketOil").a(id.av);
        CoreProxy.addName(bucketOil, "Oil Bucket");
        fuel = new ItemBuildCraft(Integer.parseInt(itemFuelId.value)).a("fuel");
        CoreProxy.addName(fuel, "Fuel");
        bucketFuel = new ItemBuildCraft(Integer.parseInt(bucketFuelId.value)).d(3).a("bucketFuel").e(1).a(id.av);
        CoreProxy.addName(bucketFuel, "Fuel Bucket");
        RefineryRecipe.registerRefineryRecipe(new RefineryRecipe(new LiquidStack(BuildCraftEnergy.oilStill.bO, 1, 0), null, new LiquidStack(BuildCraftEnergy.fuel.bP, 1, 0), 10, 1));
        IronEngineFuel.fuels.add(new IronEngineFuel(vz.D.bO, 1.0f, 20000));
        IronEngineFuel.fuels.add(new IronEngineFuel(BuildCraftEnergy.oilStill.bO, 2.0f, 10000));
        IronEngineFuel.fuels.add(new IronEngineFuel(BuildCraftEnergy.fuel.bP, 5.0f, 50000));
        IronEngineCoolant.coolants.add(new IronEngineCoolant(new LiquidStack(vz.B, 1000), 1.0f));
        LiquidManager.liquids.add(new LiquidData(new LiquidStack(oilStill, 1000), new LiquidStack(oilMoving, 1000), new kp(bucketOil), new kp(id.av)));
        LiquidManager.liquids.add(new LiquidData(new LiquidStack(fuel, 1000), new LiquidStack(fuel, 1000), new kp(bucketFuel), new kp(id.av)));
        BuildCraftAPI.softBlocks[BuildCraftEnergy.oilMoving.bO] = true;
        BuildCraftAPI.softBlocks[BuildCraftEnergy.oilStill.bO] = true;
        new BptBlockEngine(BuildCraftEnergy.engineBlock.bO);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftEnergy.loadRecipes();
        }
    }

    public static void loadRecipes() {
        CoreProxy.addCraftingRecipe(new kp((vz)engineBlock, 1, 0), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), vz.x, Character.valueOf('g'), vz.M, Character.valueOf('G'), BuildCraftCore.woodenGearItem, Character.valueOf('p'), vz.Z});
        CoreProxy.addCraftingRecipe(new kp((vz)engineBlock, 1, 1), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), vz.w, Character.valueOf('g'), vz.M, Character.valueOf('G'), BuildCraftCore.stoneGearItem, Character.valueOf('p'), vz.Z});
        CoreProxy.addCraftingRecipe(new kp((vz)engineBlock, 1, 2), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), id.n, Character.valueOf('g'), vz.M, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('p'), vz.Z});
    }

    public static void generateSurface(ge world, Random random, int i, int j) {
        OilPopulate.doPopulate(world, i, j);
    }

    static {
        saturationStored = new TreeMap();
        initialized = false;
        triggerBlueEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_BLUE_ENGINE_HEAT, Engine.EnergyStage.Blue);
        triggerGreenEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_GREEN_ENGINE_HEAT, Engine.EnergyStage.Green);
        triggerYellowEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_YELLOW_ENGINE_HEAT, Engine.EnergyStage.Yellow);
        triggerRedEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_RED_ENGINE_HEAT, Engine.EnergyStage.Red);
    }
}

