/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.core.Orientations;
import buildcraft.api.transport.IPipe;
import buildcraft.transport.utils.ConnectionMatrix;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class WireMatrix {
    private final boolean[] _hasWire = new boolean[IPipe.WireColor.values().length];
    private final ConnectionMatrix[] _wires = new ConnectionMatrix[IPipe.WireColor.values().length];
    private int[] _wireTextureIndex = new int[IPipe.WireColor.values().length];
    private boolean dirty = false;

    public WireMatrix() {
        for (int i = 0; i < IPipe.WireColor.values().length; ++i) {
            this._wires[i] = new ConnectionMatrix();
        }
    }

    public boolean hasWire(IPipe.WireColor color) {
        return this._hasWire[color.ordinal()];
    }

    public void setWire(IPipe.WireColor color, boolean value) {
        if (this._hasWire[color.ordinal()] != value) {
            this._hasWire[color.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isWireConnected(IPipe.WireColor color, Orientations direction) {
        return this._wires[color.ordinal()].isConnected(direction);
    }

    public void setWireConnected(IPipe.WireColor color, Orientations direction, boolean value) {
        this._wires[color.ordinal()].setConnected(direction, value);
    }

    public int getTextureIndex(IPipe.WireColor color) {
        return this._wireTextureIndex[color.ordinal()];
    }

    public void setTextureIndex(IPipe.WireColor color, int value) {
        if (this._wireTextureIndex[color.ordinal()] != value) {
            this._wireTextureIndex[color.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < IPipe.WireColor.values().length; ++i) {
            if (!this._wires[i].isDirty()) continue;
            return true;
        }
        return this.dirty;
    }

    public void clean() {
        for (int i = 0; i < IPipe.WireColor.values().length; ++i) {
            this._wires[i].clean();
        }
        this.dirty = false;
    }

    public void writeData(DataOutputStream data) throws IOException {
        for (int i = 0; i < IPipe.WireColor.values().length; ++i) {
            data.writeBoolean(this._hasWire[i]);
            this._wires[i].writeData(data);
            data.writeInt(this._wireTextureIndex[i]);
        }
    }

    public void readData(DataInputStream data) throws IOException {
        for (int i = 0; i < IPipe.WireColor.values().length; ++i) {
            this._hasWire[i] = data.readBoolean();
            this._wires[i].readData(data);
            this._wireTextureIndex[i] = data.readInt();
        }
    }
}

