/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.core.Orientations;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TextureMatrix {
    private final int[] _textureIndexes = new int[Orientations.values().length];
    private boolean dirty = false;

    public int getTextureIndex(Orientations direction) {
        return this._textureIndexes[direction.ordinal()];
    }

    public void setTextureIndex(Orientations direction, int value) {
        if (this._textureIndexes[direction.ordinal()] != value) {
            this._textureIndexes[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(DataOutputStream data) throws IOException {
        for (int i = 0; i < Orientations.values().length; ++i) {
            data.writeInt(this._textureIndexes[i]);
        }
    }

    public void readData(DataInputStream data) throws IOException {
        for (int i = 0; i < Orientations.values().length; ++i) {
            this._textureIndexes[i] = data.readInt();
        }
    }
}

