/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicStone;
import buildcraft.transport.PipeTransportItems;
import java.util.LinkedList;

public class PipeItemsStone
extends Pipe
implements IPipeTransportItemsHook {
    public PipeItemsStone(int itemID) {
        super(new PipeTransportItems(), new PipeLogicStone(), itemID);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        return 29;
    }

    @Override
    public void readjustSpeed(IPipedItem item) {
        if (item.getSpeed() > Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - Utils.pipeNormalSpeed / 2.0f);
        }
        if (item.getSpeed() < Utils.pipeNormalSpeed) {
            item.setSpeed(Utils.pipeNormalSpeed);
        }
    }

    @Override
    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    @Override
    public void entityEntered(IPipedItem item, Orientations orientation) {
    }
}

