/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicObsidian;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TransportProxy;
import java.util.List;

public class PipeItemsObsidian
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider;
    private int[] entitiesDropped = new int[32];
    private int entitiesDroppedIndex = 0;

    public PipeItemsObsidian(int itemID) {
        super(new PipeTransportItems(), new PipeLogicObsidian(), itemID);
        for (int i = 0; i < this.entitiesDropped.length; ++i) {
            this.entitiesDropped[i] = -1;
        }
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(25, 1, 64, 1, 256);
        this.powerProvider.configurePowerPerdition(1, 1);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        return 28;
    }

    @Override
    public void onEntityCollidedWithBlock(nn entity) {
        super.onEntityCollidedWithBlock(entity);
        if (entity.G) {
            return;
        }
        if (this.canSuck(entity, 0)) {
            this.pullItemIntoPipe(entity, 0);
        }
    }

    private wu getSuckingBox(Orientations orientation, int distance) {
        if (orientation == Orientations.Unknown) {
            return null;
        }
        Position p1 = new Position(this.xCoord, this.yCoord, this.zCoord, orientation);
        Position p2 = new Position(this.xCoord, this.yCoord, this.zCoord, orientation);
        switch (orientation) {
            case XPos: {
                p1.x += (double)distance;
                p2.x += (double)(1 + distance);
                break;
            }
            case XNeg: {
                p1.x -= (double)(distance - 1);
                p2.x -= (double)distance;
                break;
            }
            case YPos: 
            case YNeg: {
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case ZPos: {
                p1.z += (double)distance;
                p2.z += (double)(distance + 1);
                break;
            }
            case ZNeg: {
                p1.z -= (double)(distance - 1);
                p2.z -= (double)distance;
            }
        }
        switch (orientation) {
            case XPos: 
            case XNeg: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case YPos: {
                p1.y += (double)(distance + 1);
                p2.y += (double)distance;
                break;
            }
            case YNeg: {
                p1.y -= (double)(distance - 1);
                p2.y -= (double)distance;
                break;
            }
            case ZPos: 
            case ZNeg: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
            }
        }
        Position min = p1.min(p2);
        Position max = p1.max(p2);
        return wu.b((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    @Override
    public void doWork() {
        for (int j = 1; j < 5; ++j) {
            if (!this.trySucc(j)) continue;
            return;
        }
        this.powerProvider.useEnergy(1.0f, 1.0f, true);
    }

    private boolean trySucc(int distance) {
        wu box = this.getSuckingBox(this.getOpenOrientation(), distance);
        if (box == null) {
            return false;
        }
        List list = this.worldObj.a(nn.class, box);
        for (int g = 0; g < list.size(); ++g) {
            aan stack;
            if (!(list.get(g) instanceof nn)) continue;
            nn entity = (nn)list.get(g);
            if (this.canSuck(entity, distance)) {
                this.pullItemIntoPipe(entity, distance);
                return true;
            }
            if (distance != 1 || !(list.get(g) instanceof ama)) continue;
            ama cart = (ama)list.get(g);
            if (cart.G || cart.a != 1 || (stack = this.checkExtractGeneric((io)cart, true, this.getOpenOrientation())) == null || this.powerProvider.useEnergy(1.0f, 1.0f, true) != 1.0f) continue;
            fq entityitem = new fq(this.worldObj, cart.o, cart.p + (double)0.3f, cart.q, stack);
            entityitem.c = 10;
            this.worldObj.a((nn)entityitem);
            this.pullItemIntoPipe((nn)entityitem, 1);
            return true;
        }
        return false;
    }

    public aan checkExtractGeneric(io inventory, boolean doRemove, Orientations from) {
        for (int k = 0; k < inventory.a(); ++k) {
            aan slot;
            if (inventory.k_(k) == null || inventory.k_((int)k).a <= 0 || (slot = inventory.k_(k)) == null || slot.a <= 0) continue;
            if (doRemove) {
                return inventory.a(k, 1);
            }
            return slot;
        }
        return null;
    }

    public void pullItemIntoPipe(nn entity, int distance) {
        if (CoreProxy.isClient(this.worldObj)) {
            return;
        }
        Orientations orientation = this.getOpenOrientation().reverse();
        if (orientation != Orientations.Unknown) {
            this.worldObj.a(entity, "random.pop", 0.2f, ((this.worldObj.r.nextFloat() - this.worldObj.r.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            aan stack = null;
            double speed = 0.01f;
            if (entity instanceof fq) {
                fq item = (fq)entity;
                TransportProxy.obsidianPipePickup(this.worldObj, item, this.container);
                float energyUsed = this.powerProvider.useEnergy(distance, item.a.a * distance, true);
                if (distance == 0 || energyUsed / (float)distance == (float)item.a.a) {
                    stack = item.a;
                    CoreProxy.removeEntity(entity);
                } else {
                    stack = item.a.a((int)(energyUsed / (float)distance));
                }
                speed = Math.sqrt(item.r * item.r + item.s * item.s + item.t * item.t);
                speed = speed / 2.0 - 0.05;
                if (speed < 0.01) {
                    speed = 0.01;
                }
            } else if (entity instanceof nm) {
                this.powerProvider.useEnergy(distance, distance, true);
                stack = new aan(yr.l, 1);
                CoreProxy.removeEntity(entity);
            }
            EntityPassiveItem passive = new EntityPassiveItem(this.worldObj, (double)this.xCoord + 0.5, (float)this.yCoord + Utils.getPipeFloorOf(stack), (double)this.zCoord + 0.5, stack);
            passive.setSpeed((float)speed);
            ((PipeTransportItems)this.transport).entityEntering(passive, orientation);
        }
    }

    @Override
    public void onDropped(fq item) {
        this.entitiesDroppedIndex = this.entitiesDroppedIndex + 1 >= this.entitiesDropped.length ? 0 : ++this.entitiesDroppedIndex;
        this.entitiesDropped[this.entitiesDroppedIndex] = item.f;
    }

    public boolean canSuck(nn entity, int distance) {
        if (!entity.M()) {
            return false;
        }
        if (entity instanceof fq) {
            fq item = (fq)entity;
            if (item.a.a <= 0) {
                return false;
            }
            for (int i = 0; i < this.entitiesDropped.length; ++i) {
                if (item.f != this.entitiesDropped[i]) continue;
                return false;
            }
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        if (entity instanceof nm) {
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        return false;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

