/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.api.core.Orientations;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.core.network.PacketCoordinates;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketLiquidUpdate
extends PacketCoordinates {
    public LiquidStack[] displayLiquid = new LiquidStack[Orientations.values().length];

    public PacketLiquidUpdate(int xCoord, int yCoord, int zCoord) {
        super(3, xCoord, yCoord, zCoord);
    }

    public PacketLiquidUpdate() {
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        for (Orientations direction : Orientations.values()) {
            int liquidId = data.readInt();
            int liquidQuantity = data.readInt();
            int liquidMeta = data.readInt();
            this.displayLiquid[direction.ordinal()] = new LiquidStack(liquidId, liquidQuantity, liquidMeta);
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        for (Orientations direction : Orientations.values()) {
            if (this.displayLiquid[direction.ordinal()] != null) {
                data.writeInt(this.displayLiquid[direction.ordinal()].itemID);
                data.writeInt(this.displayLiquid[direction.ordinal()].amount);
                data.writeInt(this.displayLiquid[direction.ordinal()].itemMeta);
                continue;
            }
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
        }
    }
}

