/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketNBT;
import buildcraft.core.network.PacketPipeTransportContent;
import buildcraft.core.network.PacketUpdate;
import buildcraft.transport.CraftingGateInterface;
import buildcraft.transport.PipeLogicDiamond;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketLiquidUpdate;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.network.PipeRenderStatePacket;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(lg network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            adl net = (adl)network.getNetHandler();
            int packetID = data.read();
            PacketUpdate packet = new PacketUpdate();
            switch (packetID) {
                case 30: {
                    PacketNBT packetN = new PacketNBT();
                    packetN.readData(data);
                    this.onDiamondContents(packetN);
                    break;
                }
                case 4: {
                    PacketPowerUpdate packetPower = new PacketPowerUpdate();
                    packetPower.readData(data);
                    this.onPacketPower(packetPower);
                    break;
                }
                case 3: {
                    PacketLiquidUpdate packetLiquid = new PacketLiquidUpdate();
                    packetLiquid.readData(data);
                    this.onPacketLiquid(packetLiquid);
                    break;
                }
                case 1: {
                    PipeRenderStatePacket descPacket = new PipeRenderStatePacket();
                    descPacket.readData(data);
                    this.onPipeDescription(descPacket);
                    break;
                }
                case 2: {
                    PacketPipeTransportContent packetC = new PacketPipeTransportContent();
                    packetC.readData(data);
                    this.onPipeContentUpdate(packetC);
                    break;
                }
                case 40: {
                    packet.readData(data);
                    this.onGateActions(packet);
                    break;
                }
                case 45: {
                    packet.readData(data);
                    this.onGateTriggers(packet);
                    break;
                }
                case 43: {
                    packet.readData(data);
                    this.onGateSelection(packet);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGateActions(PacketUpdate packet) {
        dd container = ModLoader.getMinecraftInstance().h.ar;
        if (!(container instanceof CraftingGateInterface)) {
            return;
        }
        ((CraftingGateInterface)container).updateActions(packet);
    }

    private void onGateTriggers(PacketUpdate packet) {
        dd container = ModLoader.getMinecraftInstance().h.ar;
        if (!(container instanceof CraftingGateInterface)) {
            return;
        }
        ((CraftingGateInterface)container).updateTriggers(packet);
    }

    private void onGateSelection(PacketUpdate packet) {
        dd container = ModLoader.getMinecraftInstance().h.ar;
        if (!(container instanceof CraftingGateInterface)) {
            return;
        }
        ((CraftingGateInterface)container).setSelection(packet);
    }

    private void onPipeDescription(PipeRenderStatePacket descPacket) {
        xd world = ModLoader.getMinecraftInstance().f;
        if (!world.j(descPacket.posX, descPacket.posY, descPacket.posZ)) {
            return;
        }
        kw entity = world.b(descPacket.posX, descPacket.posY, descPacket.posZ);
        if (entity == null) {
            return;
        }
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe tile = (TileGenericPipe)entity;
        tile.handleDescriptionPacket(descPacket);
    }

    private void onPipeContentUpdate(PacketPipeTransportContent packet) {
        xd world = ModLoader.getMinecraftInstance().f;
        if (!world.j(packet.posX, packet.posY, packet.posZ)) {
            return;
        }
        kw entity = world.b(packet.posX, packet.posY, packet.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)pipe.pipe.transport).handleItemPacket(packet);
    }

    private void onPacketPower(PacketPowerUpdate packetPower) {
        xd world = ModLoader.getMinecraftInstance().f;
        if (!world.j(packetPower.posX, packetPower.posY, packetPower.posZ)) {
            return;
        }
        kw entity = world.b(packetPower.posX, packetPower.posY, packetPower.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportPower)) {
            return;
        }
        ((PipeTransportPower)pipe.pipe.transport).handlePowerPacket(packetPower);
    }

    private void onPacketLiquid(PacketLiquidUpdate packetLiquid) {
        xd world = ModLoader.getMinecraftInstance().f;
        if (!world.j(packetLiquid.posX, packetLiquid.posY, packetLiquid.posZ)) {
            return;
        }
        kw entity = world.b(packetLiquid.posX, packetLiquid.posY, packetLiquid.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportLiquids)) {
            return;
        }
        ((PipeTransportLiquids)pipe.pipe.transport).handleLiquidPacket(packetLiquid);
    }

    private void onDiamondContents(PacketNBT packet) {
        xd world = ModLoader.getMinecraftInstance().f;
        if (!world.j(packet.posX, packet.posY, packet.posZ)) {
            return;
        }
        kw entity = world.b(packet.posX, packet.posY, packet.posZ);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof PipeLogicDiamond)) {
            return;
        }
        ((PipeLogicDiamond)pipe.pipe.logic).handleFilterSet(packet);
    }
}

