/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.core.DefaultProps;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;

public class TriggerRedstoneInput
extends Trigger
implements ITriggerPipe {
    boolean active;

    public TriggerRedstoneInput(int id, boolean active) {
        super(id);
        this.active = active;
    }

    @Override
    public int getIndexInTexture() {
        if (this.active) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getDescription() {
        if (this.active) {
            return "Redstone Signal On";
        }
        return "Redstone Signal Off";
    }

    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (this.active) {
            return pipe.worldObj.x(pipe.xCoord, pipe.yCoord, pipe.zCoord);
        }
        return !pipe.worldObj.x(pipe.xCoord, pipe.yCoord, pipe.zCoord);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }
}

