/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.api.transport.IPipe;
import buildcraft.core.DefaultProps;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;

public class TriggerPipeSignal
extends Trigger
implements ITriggerPipe {
    boolean active;
    IPipe.WireColor color;

    public TriggerPipeSignal(int id, boolean active, IPipe.WireColor color) {
        super(id);
        this.active = active;
        this.color = color;
    }

    @Override
    public int getIndexInTexture() {
        if (this.active) {
            switch (this.color) {
                case Red: {
                    return 3;
                }
                case Blue: {
                    return 5;
                }
                case Green: {
                    return 7;
                }
                case Yellow: {
                    return 9;
                }
            }
        } else {
            switch (this.color) {
                case Red: {
                    return 2;
                }
                case Blue: {
                    return 4;
                }
                case Green: {
                    return 6;
                }
                case Yellow: {
                    return 8;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.active) {
            switch (this.color) {
                case Red: {
                    return "Red Pipe Signal On";
                }
                case Blue: {
                    return "Blue Pipe Signal On";
                }
                case Green: {
                    return "Green Pipe Signal On";
                }
                case Yellow: {
                    return "Yellow Pipe Signal On";
                }
            }
        } else {
            switch (this.color) {
                case Red: {
                    return "Red Pipe Signal Off";
                }
                case Blue: {
                    return "Blue Pipe Signal Off";
                }
                case Green: {
                    return "Green Pipe Signal Off";
                }
                case Yellow: {
                    return "Yellow Pipe Signal Off";
                }
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (this.active) {
            return pipe.signalStrength[this.color.ordinal()] > 0;
        }
        return pipe.signalStrength[this.color.ordinal()] == 0;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }
}

