/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.Trigger;
import buildcraft.api.liquids.ILiquidTank;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.ITileBufferHolder;
import buildcraft.core.TileBuffer;
import buildcraft.core.Utils;
import buildcraft.core.network.TileNetworkData;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeRenderState;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.network.PipeRenderStatePacket;
import java.util.LinkedList;

public class TileGenericPipe
extends kw
implements IPowerReceptor,
ITankContainer,
IPipeEntry,
IPipeTile,
IOverrideDefaultTriggers,
ITileBufferHolder,
IPipeConnection,
IDropControlInventory,
IPipeRenderState {
    private PipeRenderState renderState = new PipeRenderState();
    public TileBuffer[] tileBuffer;
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public SafeTimeTracker networkSyncTracker = new SafeTimeTracker();
    public Pipe pipe;
    private boolean blockNeighborChange = false;
    private boolean refreshRenderState = false;
    private boolean pipeBound = false;
    private int[] facadeBlocks = new int[Orientations.dirs().length];
    private int[] facadeMeta = new int[Orientations.dirs().length];
    int key;
    @TileNetworkData
    public int pipeId = -1;
    public boolean initialized = false;

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        if (this.pipe != null) {
            nbttagcompound.a("pipeId", this.pipe.itemID);
            this.pipe.writeToNBT(nbttagcompound);
        } else {
            nbttagcompound.a("pipeId", this.key);
        }
        for (int i = 0; i < Orientations.dirs().length; ++i) {
            nbttagcompound.a("facadeBlocks[" + i + "]", this.facadeBlocks[i]);
            nbttagcompound.a("facadeMeta[" + i + "]", this.facadeMeta[i]);
        }
    }

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.key = nbttagcompound.f("pipeId");
        this.pipe = BlockGenericPipe.createPipe(this.key);
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbttagcompound);
        }
        for (int i = 0; i < Orientations.dirs().length; ++i) {
            this.facadeBlocks[i] = nbttagcompound.f("facadeBlocks[" + i + "]");
            this.facadeMeta[i] = nbttagcompound.f("facadeMeta[" + i + "]");
        }
    }

    public void h() {
        this.initialized = false;
        if (this.pipe != null) {
            this.pipe.invalidate();
        }
        super.h();
    }

    public void m() {
        super.m();
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
    }

    public void n_() {
        IPowerProvider provider;
        if (this.pipe == null) {
            return;
        }
        if (!this.initialized) {
            this.initialize(this.pipe);
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return;
        }
        if (this.blockNeighborChange) {
            this.computeConnections();
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
        if ((provider = this.getPowerProvider()) != null) {
            provider.update(this);
        }
        if (this.pipe != null) {
            this.pipe.updateEntity();
        }
    }

    private void refreshRenderState() {
        if (this.i.F) {
            return;
        }
        for (Orientations orientations : Orientations.dirs()) {
            this.renderState.pipeConnectionMatrix.setConnected(orientations, this.pipeConnectionsBuffer[orientations.ordinal()]);
        }
        this.renderState.setTextureFile(this.pipe.getTextureFile());
        for (Orientations orientations : Orientations.values()) {
            this.renderState.textureMatrix.setTextureIndex(orientations, this.pipe.getTextureIndex(orientations));
        }
        for (Enum enum_ : IPipe.WireColor.values()) {
            this.renderState.wireMatrix.setWire((IPipe.WireColor)enum_, this.pipe.wireSet[enum_.ordinal()]);
            for (Orientations direction : Orientations.dirs()) {
                this.renderState.wireMatrix.setWireConnected((IPipe.WireColor)enum_, direction, this.pipe.isWireConnectedTo(this.getTile(direction), (IPipe.WireColor)enum_));
            }
        }
        if (this.pipe.wireSet[IPipe.WireColor.Red.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Red, this.pipe.signalStrength[IPipe.WireColor.Red.ordinal()] > 0 ? 6 : 5);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Red, 0);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Blue.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Blue, this.pipe.signalStrength[IPipe.WireColor.Blue.ordinal()] > 0 ? 8 : 7);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Blue, 0);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Green.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Green, this.pipe.signalStrength[IPipe.WireColor.Green.ordinal()] > 0 ? 10 : 9);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Green, 0);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Yellow.ordinal()]) {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Yellow, this.pipe.signalStrength[IPipe.WireColor.Yellow.ordinal()] > 0 ? 12 : 11);
        } else {
            this.renderState.wireMatrix.setTextureIndex(IPipe.WireColor.Yellow, 0);
        }
        this.renderState.setHasGate(this.pipe.hasGate());
        this.renderState.setGateTexture(!this.pipe.hasGate() ? 0 : this.pipe.gate.getTexture(this.pipe.isGateActive()));
        for (Enum enum_ : Orientations.dirs()) {
            int blockId = this.facadeBlocks[enum_.ordinal()];
            this.renderState.facadeMatrix.setConnected((Orientations)enum_, blockId != 0 && pb.m[blockId] != null);
            if (pb.m[blockId] == null) continue;
            pb block = pb.m[blockId];
            this.renderState.facadeMatrix.setTextureFile((Orientations)enum_, block.getTextureFile());
            this.renderState.facadeMatrix.setTextureIndex((Orientations)enum_, block.a(enum_.ordinal(), this.facadeMeta[enum_.ordinal()]));
        }
        if (this.renderState.isDirty()) {
            this.i.k(this.j, this.k, this.l);
            this.renderState.clean();
        }
    }

    public void initialize(Pipe pipe) {
        this.pipe = pipe;
        this.tileBuffer = new TileBuffer[6];
        for (Orientations o : Orientations.dirs()) {
            Position pos = new Position(this.j, this.k, this.l, o);
            pos.moveForwards(1.0);
            this.tileBuffer[o.ordinal()] = new TileBuffer();
            this.tileBuffer[o.ordinal()].initialize(this.i, (int)pos.x, (int)pos.y, (int)pos.z);
        }
        for (Orientations o : Orientations.dirs()) {
            kw tile = this.getTile(o);
            if (!(tile instanceof ITileBufferHolder)) continue;
            ((ITileBufferHolder)tile).blockCreated(o, BuildCraftTransport.genericPipeBlock.bO, this);
        }
        this.bindPipe();
        this.computeConnections();
        this.scheduleRenderUpdate();
        if (pipe != null) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.pipeId = this.pipe.itemID;
            this.pipeBound = true;
        }
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            ((IPowerReceptor)((Object)this.pipe)).setPowerProvider(provider);
        }
    }

    @Override
    public IPowerProvider getPowerProvider() {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            return ((IPowerReceptor)((Object)this.pipe)).getPowerProvider();
        }
        return null;
    }

    @Override
    public void doWork() {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            ((IPowerReceptor)((Object)this.pipe)).doWork();
        }
    }

    public void scheduleNeighborChange() {
        this.blockNeighborChange = true;
    }

    @Override
    public void entityEntering(IPipedItem item, Orientations orientation) {
        if (BlockGenericPipe.isValid(this.pipe)) {
            this.pipe.transport.entityEntering(item, orientation);
        }
    }

    @Override
    public boolean acceptItems() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.transport.acceptItems();
        }
        return false;
    }

    public void handleDescriptionPacket(PipeRenderStatePacket packet) {
        if (this.i.F) {
            if (this.pipe == null && packet.getPipeId() != 0) {
                this.initialize(BlockGenericPipe.createPipe(packet.getPipeId()));
            }
            this.renderState = packet.getRenderState();
            this.i.l(this.j, this.k, this.l);
        }
    }

    public abs getDescriptionPacket() {
        this.bindPipe();
        PipeRenderStatePacket packet = new PipeRenderStatePacket(this.renderState, this.pipeId, this.j, this.k, this.l);
        return packet.getPacket();
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public LinkedList getTriggers() {
        LinkedList<Trigger> result = new LinkedList<Trigger>();
        if (BlockGenericPipe.isFullyDefined(this.pipe) && this.pipe.hasGate()) {
            result.add(BuildCraftCore.triggerRedstoneActive);
            result.add(BuildCraftCore.triggerRedstoneInactive);
        }
        return result;
    }

    @Override
    public void blockRemoved(Orientations from) {
    }

    @Override
    public void blockCreated(Orientations from, int blockID, kw tile) {
        if (this.tileBuffer != null) {
            this.tileBuffer[from.reverse().ordinal()].set(blockID, tile);
        }
    }

    @Override
    public int getBlockId(Orientations to) {
        if (this.tileBuffer != null) {
            return this.tileBuffer[to.ordinal()].getBlockID();
        }
        return 0;
    }

    @Override
    public kw getTile(Orientations to) {
        if (this.tileBuffer != null) {
            return this.tileBuffer[to.ordinal()].getTile();
        }
        return null;
    }

    public boolean isPipeConnected(kw with) {
        Pipe pipe1 = this.pipe;
        Pipe pipe2 = null;
        if (with instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)with).pipe;
        }
        if (!BlockGenericPipe.isValid(pipe1)) {
            return false;
        }
        if (BlockGenericPipe.isValid(pipe2) && !pipe1.transport.getClass().isAssignableFrom(pipe2.transport.getClass()) && !pipe1.transport.allowsConnect(pipe2.transport)) {
            return false;
        }
        if (pipe2 != null && !pipe2.isPipeConnected(this)) {
            return false;
        }
        return pipe1 != null ? pipe1.isPipeConnected(with) : false;
    }

    private void computeConnections() {
        if (this.tileBuffer != null) {
            int i;
            boolean[] oldConnections = this.pipeConnectionsBuffer;
            this.pipeConnectionsBuffer = new boolean[6];
            for (i = 0; i < this.tileBuffer.length; ++i) {
                TileBuffer t = this.tileBuffer[i];
                t.refresh();
                if (t.getTile() == null) continue;
                this.pipeConnectionsBuffer[i] = this.isPipeConnected(t.getTile());
                if (!(t.getTile() instanceof TileGenericPipe)) continue;
                TileGenericPipe pipe = (TileGenericPipe)t.getTile();
                pipe.pipeConnectionsBuffer[Orientations.values()[i].reverse().ordinal()] = this.pipeConnectionsBuffer[i];
            }
            for (i = 0; i < this.tileBuffer.length; ++i) {
                if (oldConnections[i] == this.pipeConnectionsBuffer[i]) continue;
                Position pos = new Position(this.j, this.k, this.l, Orientations.values()[i]);
                pos.moveForwards(1.0);
                this.scheduleRenderUpdate();
            }
        }
    }

    @Override
    public boolean isPipeConnected(Orientations with) {
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    @Override
    public boolean doDrop() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.doDrop();
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
    }

    @Override
    public int fill(Orientations from, LiquidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)((Object)this.pipe.transport)).fill(from, resource, doFill);
        }
        return 0;
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)((Object)this.pipe.transport)).fill(tankIndex, resource, doFill);
        }
        return 0;
    }

    @Override
    public LiquidStack drain(Orientations from, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)((Object)this.pipe.transport)).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)((Object)this.pipe.transport)).drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public ILiquidTank[] getTanks() {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof ITankContainer) {
            return ((ITankContainer)((Object)this.pipe.transport)).getTanks();
        }
        return null;
    }

    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    public boolean addFacade(Orientations direction, int blockid, int meta) {
        if (this.i.F) {
            return false;
        }
        if (this.facadeBlocks[direction.ordinal()] == blockid) {
            return false;
        }
        if (this.hasFacade(direction)) {
            this.dropFacade(direction);
        }
        this.facadeBlocks[direction.ordinal()] = blockid;
        this.facadeMeta[direction.ordinal()] = meta;
        this.scheduleRenderUpdate();
        return true;
    }

    public boolean hasFacade(Orientations direction) {
        if (this.i.F) {
            return false;
        }
        return this.facadeBlocks[direction.ordinal()] != 0;
    }

    public void dropFacade(Orientations direction) {
        if (this.i.F) {
            return;
        }
        if (!this.hasFacade(direction)) {
            return;
        }
        Utils.dropItems(this.i, new aan(BuildCraftTransport.facadeItem, 1, ItemFacade.encode(this.facadeBlocks[direction.ordinal()], this.facadeMeta[direction.ordinal()])), this.j, this.k, this.l);
        this.facadeBlocks[direction.ordinal()] = 0;
        this.facadeMeta[direction.ordinal()] = 0;
        this.scheduleRenderUpdate();
    }

    @Override
    public PipeRenderState getRenderState() {
        return this.renderState;
    }
}

