/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Orientations;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.RenderEntityBlock;
import buildcraft.transport.EntityData;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import forge.ForgeHooksClient;
import forge.IItemRenderer;
import forge.ITextureProvider;
import forge.MinecraftForgeClient;
import java.util.HashMap;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class RenderPipe
extends aar {
    private static final int maxPower = 1000;
    private static final int displayLiquidStages = 40;
    private static final int renderDistanceSq = 576;
    private static final int numItemsToRender = 10;
    private static final fq dummyEntityItem = new fq(null);
    private HashMap displayLiquidLists = new HashMap();
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private static final int displayPowerStages = 80;
    public int[] displayPowerList = new int[80];
    public double[] displayPowerLimits = new double[80];
    private vl renderBlocks;
    boolean initialized = false;
    private Random random = new Random();

    public RenderPipe() {
        this.renderBlocks = new vl();
    }

    private DisplayLiquidList getDisplayLiquidLists(int liquidId, int meta, xd world) {
        if (this.displayLiquidLists.containsKey(liquidId)) {
            HashMap x = (HashMap)this.displayLiquidLists.get(liquidId);
            if (x.containsKey(meta)) {
                return (DisplayLiquidList)x.get(meta);
            }
        } else {
            this.displayLiquidLists.put(liquidId, new HashMap());
        }
        DisplayLiquidList d = new DisplayLiquidList();
        ((HashMap)this.displayLiquidLists.get(liquidId)).put(meta, d);
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        block.texture = liquidId < pb.m.length && pb.m[liquidId] != null ? pb.m[liquidId].bN : yr.e[liquidId].b(meta);
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = ew.a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock(block, (ali)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.sideVertical[s] = ew.a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.renderBlock(block, (ali)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerHorizontal[s] = ew.a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock(block, (ali)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerVertical[s] = ew.a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.renderBlock(block, (ali)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        return d;
    }

    private void initializeDisplayPowerList(xd world) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        block.texture = 4;
        float size = 0.5f;
        for (int s = 0; s < 80; ++s) {
            this.displayPowerList[s] = ew.a((int)1);
            GL11.glNewList((int)this.displayPowerList[s], (int)4864);
            float minSize = 0.005f;
            float unit = (size - minSize) / 2.0f / 80.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.renderBlock(block, (ali)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        for (int i = 0; i < 80; ++i) {
            this.displayPowerLimits[80 - i - 1] = 1000.0 - Math.sqrt(12658 * i);
        }
    }

    public void a(kw tileentity, double x, double y, double z, float f) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        if (tileentity.a(this.b.j, this.b.k, this.b.l) >= 576.0) {
            return;
        }
        this.initializeDisplayPowerList(tileentity.i);
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe.transport instanceof PipeTransportItems) {
            this.renderSolids(pipe.pipe, x, y, z);
        } else if (pipe.pipe.transport instanceof PipeTransportLiquids) {
            this.renderLiquids(pipe.pipe, x, y, z);
        } else if (pipe.pipe.transport instanceof PipeTransportPower) {
            this.renderPower(pipe.pipe, x, y, z);
        }
    }

    private void renderPower(Pipe pipe, double x, double y, double z) {
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        MinecraftForgeClient.bindTexture((String)DefaultProps.TEXTURE_BLOCKS);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        for (int i = 0; i < 6; ++i) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
            if ((double)pow.displayPower[i] >= 1.0) {
                int stage;
                for (stage = 0; stage < 80 && !(this.displayPowerLimits[stage] > (double)pow.displayPower[i]); ++stage) {
                }
                if (stage < this.displayPowerList.length) {
                    GL11.glCallList((int)this.displayPowerList[stage]);
                } else {
                    GL11.glCallList((int)this.displayPowerList[this.displayPowerList.length - 1]);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderLiquids(Pipe pipe, double x, double y, double z) {
        DisplayLiquidList d;
        PipeTransportLiquids liq = (PipeTransportLiquids)pipe.transport;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayLiquidList d2;
            LiquidStack liquid = liq.renderCache[i];
            if (liquid == null || liquid.amount <= 0 || (d2 = this.getListFromBuffer(liquid, pipe.worldObj)) == null) continue;
            int stage = (int)((float)liquid.amount / (float)PipeTransportLiquids.LIQUID_IN_PIPE * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (Orientations.values()[i]) {
                case YPos: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case YNeg: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case XPos: 
                case XNeg: 
                case ZPos: 
                case ZNeg: {
                    sides = true;
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    list = d2.sideHorizontal[stage];
                }
            }
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        LiquidStack liquid = liq.renderCache[Orientations.Unknown.ordinal()];
        if (liquid != null && liquid.amount > 0 && (d = this.getListFromBuffer(liquid, pipe.worldObj)) != null) {
            int stage = (int)((float)liquid.amount / (float)PipeTransportLiquids.LIQUID_IN_PIPE * 39.0f);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public DisplayLiquidList getListFromBuffer(LiquidStack stack, xd world) {
        int liquidId = stack.itemID;
        if (liquidId == 0) {
            return null;
        }
        Object o = null;
        o = liquidId < pb.m.length && pb.m[liquidId] != null ? pb.m[liquidId] : yr.e[liquidId];
        MinecraftForgeClient.bindTexture((String)((ITextureProvider)o).getTextureFile());
        return this.getDisplayLiquidLists(liquidId, stack.itemMeta, world);
    }

    private void renderSolids(Pipe pipe, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        float light = pipe.worldObj.c(pipe.xCoord, pipe.yCoord, pipe.zCoord);
        int count = 0;
        for (EntityData data : ((PipeTransportItems)pipe.transport).travelingEntities.values()) {
            if (count >= 10) break;
            this.doRenderItem(data.item, x + data.item.getPosition().x - (double)pipe.xCoord, y + data.item.getPosition().y - (double)pipe.yCoord, z + data.item.getPosition().z - (double)pipe.zCoord, light);
            ++count;
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void doRenderItem(IPipedItem entityitem, double d, double d1, double d2, float f1) {
        if (entityitem == null || entityitem.getItemStack() == null) {
            return;
        }
        aan itemstack = entityitem.getItemStack();
        this.random.setSeed(187L);
        GL11.glPushMatrix();
        int quantity = 1;
        if (entityitem.getItemStack().a > 1) {
            quantity = 2;
        }
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glEnable((int)32826);
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((aan)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        if (customRenderer != null) {
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
            this.loadTexture("/terrain.png");
            ForgeHooksClient.overrideTexture((Object)itemstack.a());
            float f4 = 0.25f;
            f4 = 0.5f;
            GL11.glScalef((float)f4, (float)f4, (float)f4);
            for (int j = 0; j < quantity; ++j) {
                GL11.glPushMatrix();
                if (j > 0) {
                    float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    GL11.glTranslatef((float)f5, (float)f7, (float)f9);
                }
                RenderPipe.dummyEntityItem.a = itemstack;
                customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, itemstack, new Object[]{this.renderBlocks, dummyEntityItem});
                GL11.glPopMatrix();
            }
        } else if (itemstack.c < pb.m.length && pb.m[itemstack.c] != null && vl.a((int)pb.m[itemstack.c].d())) {
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
            this.loadTexture("/terrain.png");
            ForgeHooksClient.overrideTexture((Object)pb.m[itemstack.c]);
            float f4 = 0.25f;
            int j = pb.m[itemstack.c].d();
            if (j == 1 || j == 19 || j == 12 || j == 2) {
                f4 = 0.5f;
            }
            GL11.glScalef((float)f4, (float)f4, (float)f4);
            for (int k = 0; k < quantity; ++k) {
                GL11.glPushMatrix();
                if (k > 0) {
                    float f6 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f11 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    GL11.glTranslatef((float)f6, (float)f9, (float)f11);
                }
                float f7 = 1.0f;
                this.renderBlocks.a(pb.m[itemstack.c], itemstack.i(), f7);
                GL11.glPopMatrix();
            }
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.1f, (float)0.0f);
            if (itemstack.a().c()) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.loadTexture(ForgeHooksClient.getTexture((String)"/gui/items.png", (Object)yr.e[itemstack.c]));
                for (int i = 0; i <= 1; ++i) {
                    int iconIndex = itemstack.a().a(itemstack.i(), i);
                    float scale = 1.0f;
                    int var17 = yr.e[itemstack.c].b(itemstack.i(), i);
                    float var18 = (float)(var17 >> 16 & 0xFF) / 255.0f;
                    float var19 = (float)(var17 >> 8 & 0xFF) / 255.0f;
                    float var20 = (float)(var17 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)(var18 * scale), (float)(var19 * scale), (float)(var20 * scale), (float)1.0f);
                    this.drawItem(iconIndex, quantity);
                }
            } else {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                int i = itemstack.b();
                if (itemstack.c < pb.m.length && pb.m[itemstack.c] != null) {
                    this.loadTexture("/terrain.png");
                    ForgeHooksClient.overrideTexture((Object)pb.m[itemstack.c]);
                } else {
                    this.loadTexture("/gui/items.png");
                    ForgeHooksClient.overrideTexture((Object)yr.e[itemstack.c]);
                }
                this.drawItem(i, quantity);
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void drawItem(int iconIndex, int quantity) {
        adz tesselator = adz.a;
        float var4 = (float)(iconIndex % 16 * 16 + 0) / 256.0f;
        float var5 = (float)(iconIndex % 16 * 16 + 16) / 256.0f;
        float var6 = (float)(iconIndex / 16 * 16 + 0) / 256.0f;
        float var7 = (float)(iconIndex / 16 * 16 + 16) / 256.0f;
        float var8 = 1.0f;
        float var9 = 0.5f;
        float var10 = 0.25f;
        for (int var11 = 0; var11 < quantity; ++var11) {
            GL11.glPushMatrix();
            if (var11 > 0) {
                float var12 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var13 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var14 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                GL11.glTranslatef((float)var12, (float)var13, (float)var14);
            }
            GL11.glRotatef((float)(180.0f - ahu.a.i), (float)0.0f, (float)1.0f, (float)0.0f);
            tesselator.b();
            tesselator.b(0.0f, 1.0f, 0.0f);
            tesselator.a((double)(0.0f - var9), (double)(0.0f - var10), 0.0, (double)var4, (double)var7);
            tesselator.a((double)(var8 - var9), (double)(0.0f - var10), 0.0, (double)var5, (double)var7);
            tesselator.a((double)(var8 - var9), (double)(1.0f - var10), 0.0, (double)var5, (double)var6);
            tesselator.a((double)(0.0f - var9), (double)(1.0f - var10), 0.0, (double)var4, (double)var6);
            tesselator.a();
            GL11.glPopMatrix();
        }
    }

    protected void loadTexture(String s) {
        aaw renderengine = ahu.a.e;
        renderengine.b(renderengine.b(s));
    }

    private class DisplayLiquidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayLiquidList() {
        }
    }
}

