/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.Utils;
import buildcraft.core.network.TileNetworkData;
import buildcraft.mod_BuildCraftCore;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketPowerUpdate;

public class PipeTransportPower
extends PipeTransport {
    @TileNetworkData(staticSize=6)
    public short[] displayPower = new short[]{0, 0, 0, 0, 0, 0};
    public int[] powerQuery = new int[6];
    public int[] nextPowerQuery = new int[6];
    public long currentDate;
    public double[] internalPower = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public double[] internalNextPower = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public double powerResitance = 0.01;
    SafeTimeTracker tracker = new SafeTimeTracker();

    public PipeTransportPower() {
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = 0;
        }
    }

    @Override
    public boolean isPipeConnected(kw tile) {
        return tile instanceof TileGenericPipe || tile instanceof IMachine || tile instanceof IPowerReceptor;
    }

    @Override
    public void updateEntity() {
        int i;
        int i2;
        if (CoreProxy.isClient(this.worldObj)) {
            return;
        }
        this.step();
        kw[] tiles = new kw[6];
        for (i2 = 0; i2 < 6; ++i2) {
            if (!Utils.checkPipesConnections(this.container.getTile(Orientations.values()[i2]), this.container)) continue;
            tiles[i2] = this.container.getTile(Orientations.values()[i2]);
        }
        this.displayPower = new short[]{0, 0, 0, 0, 0, 0};
        for (i2 = 0; i2 < 6; ++i2) {
            if (!(this.internalPower[i2] > 0.0)) continue;
            double div = 0.0;
            for (int j = 0; j < 6; ++j) {
                if (j == i2 || this.powerQuery[j] <= 0 || !(tiles[j] instanceof TileGenericPipe) && !(tiles[j] instanceof IPowerReceptor)) continue;
                div += (double)this.powerQuery[j];
            }
            double totalWatt = this.internalPower[i2];
            for (int j = 0; j < 6; ++j) {
                if (j == i2 || this.powerQuery[j] <= 0) continue;
                double watts = totalWatt / div * (double)this.powerQuery[j];
                if (tiles[j] instanceof TileGenericPipe) {
                    TileGenericPipe nearbyTile = (TileGenericPipe)tiles[j];
                    PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
                    nearbyTransport.receiveEnergy(Orientations.values()[j].reverse(), watts);
                    int n = j;
                    this.displayPower[n] = (short)((double)this.displayPower[n] + watts / 2.0);
                    int n2 = i2;
                    this.displayPower[n2] = (short)((double)this.displayPower[n2] + watts / 2.0);
                    int n3 = i2;
                    this.internalPower[n3] = this.internalPower[n3] - watts;
                    continue;
                }
                if (!(tiles[j] instanceof IPowerReceptor)) continue;
                IPowerReceptor pow = (IPowerReceptor)tiles[j];
                pow.getPowerProvider().receiveEnergy((float)watts, Orientations.values()[j].reverse());
                int n = j;
                this.displayPower[n] = (short)((double)this.displayPower[n] + watts / 2.0);
                int n4 = i2;
                this.displayPower[n4] = (short)((double)this.displayPower[n4] + watts / 2.0);
                int n5 = i2;
                this.internalPower[n5] = this.internalPower[n5] - watts;
            }
        }
        for (i2 = 0; i2 < 6; ++i2) {
            IPowerReceptor receptor;
            int request;
            if (!(tiles[i2] instanceof IPowerReceptor) || tiles[i2] instanceof TileGenericPipe || (request = (receptor = (IPowerReceptor)tiles[i2]).powerRequest()) <= 0) continue;
            this.requestEnergy(Orientations.values()[i2], request);
        }
        int[] transferQuery = new int[]{0, 0, 0, 0, 0, 0};
        for (i = 0; i < 6; ++i) {
            transferQuery[i] = 0;
            for (int j = 0; j < 6; ++j) {
                if (j == i) continue;
                int n = i;
                transferQuery[n] = transferQuery[n] + this.powerQuery[j];
            }
        }
        for (i = 0; i < 6; ++i) {
            kw entity;
            if (transferQuery[i] == 0 || tiles[i] == null || !((entity = tiles[i]) instanceof TileGenericPipe)) continue;
            TileGenericPipe nearbyTile = (TileGenericPipe)entity;
            if (nearbyTile.pipe == null) continue;
            PipeTransportPower nearbyTransport = (PipeTransportPower)nearbyTile.pipe.transport;
            nearbyTransport.requestEnergy(Orientations.values()[i].reverse(), transferQuery[i]);
        }
        if (CoreProxy.isServerSide() && this.tracker.markTimeIfDelay(this.worldObj, 2 * BuildCraftCore.updateFactor)) {
            PacketPowerUpdate packet = new PacketPowerUpdate(this.xCoord, this.yCoord, this.zCoord);
            packet.displayPower = this.displayPower;
            CoreProxy.sendToPlayers(packet.getPacket(), this.worldObj, this.xCoord, this.yCoord, this.zCoord, DefaultProps.NETWORK_UPDATE_RANGE, mod_BuildCraftCore.instance);
        }
    }

    public void step() {
        if (this.currentDate != this.worldObj.w()) {
            this.currentDate = this.worldObj.w();
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = new int[]{0, 0, 0, 0, 0, 0};
            this.internalPower = this.internalNextPower;
            this.internalNextPower = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        }
    }

    public void receiveEnergy(Orientations from, double val) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            ((IPipeTransportPowerHook)((Object)this.container.pipe)).receiveEnergy(from, val);
        } else {
            if (BuildCraftTransport.usePipeLoss) {
                int n = from.ordinal();
                this.internalNextPower[n] = this.internalNextPower[n] + val * (1.0 - this.powerResitance);
            } else {
                int n = from.ordinal();
                this.internalNextPower[n] = this.internalNextPower[n] + val;
            }
            if (this.internalNextPower[from.ordinal()] >= 1000.0) {
                this.worldObj.a(null, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 2.0f);
            }
        }
    }

    public void requestEnergy(Orientations from, int i) {
        this.step();
        if (this.container.pipe instanceof IPipeTransportPowerHook) {
            ((IPipeTransportPowerHook)((Object)this.container.pipe)).requestEnergy(from, i);
        } else {
            this.step();
            int n = from.ordinal();
            this.nextPowerQuery[n] = this.nextPowerQuery[n] + i;
        }
    }

    @Override
    public void initialize() {
        this.currentDate = this.worldObj.w();
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            this.powerQuery[i] = nbttagcompound.f("powerQuery[" + i + "]");
            this.nextPowerQuery[i] = nbttagcompound.f("nextPowerQuery[" + i + "]");
            this.internalPower[i] = nbttagcompound.i("internalPower[" + i + "]");
            this.internalNextPower[i] = nbttagcompound.i("internalNextPower[" + i + "]");
        }
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.a("powerQuery[" + i + "]", this.powerQuery[i]);
            nbttagcompound.a("nextPowerQuery[" + i + "]", this.nextPowerQuery[i]);
            nbttagcompound.a("internalPower[" + i + "]", this.internalPower[i]);
            nbttagcompound.a("internalNextPower[" + i + "]", this.internalNextPower[i]);
        }
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    @Override
    public boolean allowsConnect(PipeTransport with) {
        return with instanceof PipeTransportPower;
    }

    public void handlePowerPacket(PacketPowerUpdate packetPower) {
        this.displayPower = packetPower.displayPower;
    }
}

