/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.Orientations;
import buildcraft.api.power.IPowerReceptor;

public class EnergyPulser {
    private IPowerReceptor powerReceptor;
    private boolean isActive = false;
    private float progress = 0.0f;
    private int progressPart = 0;
    private float pulseSpeed = 0.0f;
    private int maxHeat = 1000;
    private int heat = 0;

    public EnergyPulser(IPowerReceptor receptor) {
        this.powerReceptor = receptor;
    }

    public void update() {
        if (this.powerReceptor == null) {
            return;
        }
        this.pulseSpeed = this.getPulseSpeed();
        if (this.progressPart != 0) {
            this.progress += this.pulseSpeed;
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
                this.powerReceptor.getPowerProvider().receiveEnergy(1.0f, Orientations.XNeg);
                if (this.heat < this.maxHeat) {
                    ++this.heat;
                }
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isActive) {
            this.progressPart = 1;
        } else {
            --this.heat;
        }
    }

    public void enablePulse() {
        this.isActive = true;
    }

    public void disablePulse() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private float getPulseSpeed() {
        if ((double)this.heat / (double)this.maxHeat * 100.0 <= 25.0) {
            return 0.01f;
        }
        if ((double)this.heat / (double)this.maxHeat * 100.0 <= 50.0) {
            return 0.02f;
        }
        if ((double)this.heat / (double)this.maxHeat * 100.0 <= 75.0) {
            return 0.04f;
        }
        return 0.08f;
    }

    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("Heat", this.heat);
        nbttagcompound.a("IsActive", this.isActive);
        nbttagcompound.a("ProgressPart", (short)this.progressPart);
        nbttagcompound.a("Progress", this.progress);
    }

    public void readFromNBT(ady nbttagcompound) {
        this.heat = nbttagcompound.f("Heat");
        this.isActive = nbttagcompound.o("IsActive");
        this.progressPart = nbttagcompound.e("ProgressPart");
        this.progress = nbttagcompound.h("Progress");
    }
}

