/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.core.BuildCraftContainer;
import buildcraft.core.CoreProxy;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.transport.Pipe;
import java.util.Iterator;
import java.util.LinkedList;

public class CraftingGateInterface
extends BuildCraftContainer {
    io playerIInventory;
    Pipe pipe;
    private final LinkedList _potentialTriggers = new LinkedList();
    private final LinkedList _potentialActions = new LinkedList();
    private boolean isSynchronized = false;
    private boolean isNetInitialized = false;

    public CraftingGateInterface(io playerInventory, Pipe pipe) {
        super(0);
        this.playerIInventory = playerInventory;
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.a(new yu(playerInventory, k1 + l * 9 + 9, 8 + k1 * 18, 123 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.a(new yu(playerInventory, i1, 8 + i1 * 18, 181));
        }
        this.pipe = pipe;
        if (!CoreProxy.isRemote()) {
            this._potentialActions.addAll(pipe.getActions());
            this._potentialTriggers.addAll(ActionManager.getPipeTriggers(pipe));
            for (Orientations o : Orientations.dirs()) {
                Position pos = new Position(pipe.xCoord, pipe.yCoord, pipe.zCoord, o);
                pos.moveForwards(1.0);
                kw tile = pipe.worldObj.b((int)pos.x, (int)pos.y, (int)pos.z);
                int blockID = pipe.worldObj.a((int)pos.x, (int)pos.y, (int)pos.z);
                pb block = pb.m[blockID];
                LinkedList nearbyTriggers = ActionManager.getNeighborTriggers(block, tile);
                for (ITrigger t : nearbyTriggers) {
                    if (this._potentialTriggers.contains(t)) continue;
                    this._potentialTriggers.add(t);
                }
                LinkedList nearbyActions = ActionManager.getNeighborActions(block, tile);
                for (IAction a : nearbyActions) {
                    if (this._potentialActions.contains(a)) continue;
                    this._potentialActions.add(a);
                }
            }
        }
    }

    public boolean b(yw entityplayer) {
        return true;
    }

    public void markDirty() {
        this.isSynchronized = false;
    }

    public void updateActions(PacketUpdate packet) {
        this._potentialActions.clear();
        int length = packet.payload.intPayload[0];
        for (int i = 0; i < length; ++i) {
            this._potentialActions.add(ActionManager.actions[packet.payload.intPayload[i + 1]]);
        }
    }

    public void updateTriggers(PacketUpdate packet) {
        this._potentialTriggers.clear();
        int length = packet.payload.intPayload[0];
        for (int i = 0; i < length; ++i) {
            this._potentialTriggers.add(ActionManager.triggers[packet.payload.intPayload[i + 1]]);
        }
    }

    public void setSelection(PacketUpdate packet) {
        PacketPayload payload = packet.payload;
        int position = payload.intPayload[0];
        if (payload.intPayload[1] >= 0 && payload.intPayload[1] < ActionManager.triggers.length) {
            this.setTrigger(position, ActionManager.triggers[payload.intPayload[1]], false);
        } else {
            this.setTrigger(position, null, false);
        }
        if (payload.intPayload[2] >= 0 && payload.intPayload[2] < ActionManager.actions.length) {
            this.setAction(position, ActionManager.actions[payload.intPayload[2]], false);
        } else {
            this.setAction(position, null, false);
        }
        int itemID = payload.intPayload[3];
        if (itemID <= 0) {
            this.setTriggerParameter(position, null, false);
            return;
        }
        TriggerParameter param = new TriggerParameter();
        param.set(new aan(itemID, payload.intPayload[4], payload.intPayload[5]));
        this.setTriggerParameter(position, param, false);
    }

    public void sendSelectionChange(int position) {
        PacketPayload payload = new PacketPayload(6, 0, 0);
        payload.intPayload[0] = position;
        payload.intPayload[1] = this.pipe.activatedTriggers[position] != null ? this.pipe.activatedTriggers[position].getId() : -1;
        payload.intPayload[2] = this.pipe.activatedActions[position] != null ? this.pipe.activatedActions[position].getId() : -1;
        if (this.pipe.triggerParameters[position] != null && this.pipe.triggerParameters[position].getItemStack() != null) {
            payload.intPayload[3] = this.pipe.triggerParameters[position].getItemStack().c;
            payload.intPayload[4] = this.pipe.triggerParameters[position].getItemStack().a;
            payload.intPayload[5] = this.pipe.triggerParameters[position].getItemStack().i();
        }
        CoreProxy.sendToServer(new PacketUpdate(44, this.pipe.xCoord, this.pipe.yCoord, this.pipe.zCoord, payload).getPacket());
    }

    public void synchronize() {
        if (!this.isNetInitialized && CoreProxy.isRemote()) {
            this.isNetInitialized = true;
            CoreProxy.sendToServer(new PacketCoordinates(41, this.pipe.xCoord, this.pipe.yCoord, this.pipe.zCoord).getPacket());
        }
        if (!this.isSynchronized && CoreProxy.isRemote()) {
            this.isSynchronized = true;
            CoreProxy.sendToServer(new PacketCoordinates(42, this.pipe.xCoord, this.pipe.yCoord, this.pipe.zCoord).getPacket());
        }
    }

    public void handleInitRequest(yw player) {
        this.sendActions(player);
        this.sendTriggers(player);
        this.sendSelection(player);
    }

    public void handleSelectionChange(PacketUpdate packet) {
        PacketPayload payload = packet.payload;
        int position = payload.intPayload[0];
        if (payload.intPayload[1] >= 0 && payload.intPayload[1] < ActionManager.triggers.length) {
            this.setTrigger(position, ActionManager.triggers[payload.intPayload[1]], true);
        } else {
            this.setTrigger(position, null, true);
        }
        if (payload.intPayload[2] >= 0 && payload.intPayload[2] < ActionManager.actions.length) {
            this.setAction(position, ActionManager.actions[payload.intPayload[2]], true);
        } else {
            this.setAction(position, null, true);
        }
        int itemID = payload.intPayload[3];
        if (itemID <= 0) {
            this.setTriggerParameter(position, null, true);
            return;
        }
        TriggerParameter param = new TriggerParameter();
        param.set(new aan(itemID, payload.intPayload[4], payload.intPayload[5]));
        this.setTriggerParameter(position, param, true);
    }

    private void sendActions(yw player) {
        int length = this._potentialActions.size();
        PacketPayload payload = new PacketPayload(length + 1, 0, 0);
        payload.intPayload[0] = length;
        for (int i = 0; i < length; ++i) {
            payload.intPayload[i + 1] = ((IAction)this._potentialActions.get(i)).getId();
        }
        PacketUpdate packet = new PacketUpdate(40, this.pipe.xCoord, this.pipe.yCoord, this.pipe.zCoord, payload);
        CoreProxy.sendToPlayer(player, packet);
    }

    private void sendTriggers(yw player) {
        int length = this._potentialTriggers.size();
        PacketPayload payload = new PacketPayload(length + 1, 0, 0);
        payload.intPayload[0] = length;
        for (int i = 0; i < length; ++i) {
            payload.intPayload[i + 1] = ((ITrigger)this._potentialTriggers.get(i)).getId();
        }
        PacketUpdate packet = new PacketUpdate(45, this.pipe.xCoord, this.pipe.yCoord, this.pipe.zCoord, payload);
        CoreProxy.sendToPlayer(player, packet);
    }

    public void sendSelection(yw player) {
        if (this.pipe == null || this.pipe.gate == null) {
            return;
        }
        int positions = 0;
        switch (this.pipe.gate.kind) {
            case Single: {
                positions = 1;
                break;
            }
            case AND_2: 
            case OR_2: {
                positions = 2;
                break;
            }
            case AND_3: 
            case OR_3: {
                positions = 4;
                break;
            }
            case OR_4: 
            case AND_4: {
                positions = 8;
            }
        }
        for (int position = 0; position < positions; ++position) {
            PacketPayload payload = new PacketPayload(6, 0, 0);
            payload.intPayload[0] = position;
            payload.intPayload[1] = this.pipe.activatedTriggers[position] != null ? this.pipe.activatedTriggers[position].getId() : -1;
            payload.intPayload[2] = this.pipe.activatedActions[position] != null ? this.pipe.activatedActions[position].getId() : -1;
            if (this.pipe.triggerParameters[position] != null && this.pipe.triggerParameters[position].getItemStack() != null) {
                payload.intPayload[3] = this.pipe.triggerParameters[position].getItemStack().c;
                payload.intPayload[4] = this.pipe.triggerParameters[position].getItemStack().a;
                payload.intPayload[5] = this.pipe.triggerParameters[position].getItemStack().i();
            }
            CoreProxy.sendToPlayer(player, new PacketUpdate(43, this.pipe.xCoord, this.pipe.yCoord, this.pipe.zCoord, payload));
        }
    }

    public boolean hasTriggers() {
        return this._potentialTriggers.size() > 0;
    }

    public ITrigger getFirstTrigger() {
        return this._potentialTriggers.size() > 0 ? (ITrigger)this._potentialTriggers.getFirst() : null;
    }

    public ITrigger getLastTrigger() {
        return this._potentialTriggers.size() > 0 ? (ITrigger)this._potentialTriggers.getLast() : null;
    }

    public Iterator getTriggerIterator(boolean descending) {
        return descending ? this._potentialTriggers.descendingIterator() : this._potentialTriggers.iterator();
    }

    public boolean isNearbyTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
        return this.pipe.isNearbyTriggerActive(trigger, parameter);
    }

    public void setTrigger(int position, ITrigger trigger, boolean notify) {
        this.pipe.setTrigger(position, trigger);
        if (CoreProxy.isRemote() && notify) {
            this.sendSelectionChange(position);
        }
    }

    public void setTriggerParameter(int position, ITriggerParameter parameter, boolean notify) {
        this.pipe.setTriggerParameter(position, parameter);
        if (CoreProxy.isRemote() && notify) {
            this.sendSelectionChange(position);
        }
    }

    public boolean hasActions() {
        return this._potentialActions.size() > 0;
    }

    public IAction getFirstAction() {
        return this._potentialActions.size() > 0 ? (IAction)this._potentialActions.getFirst() : null;
    }

    public IAction getLastAction() {
        return this._potentialActions.size() > 0 ? (IAction)this._potentialActions.getLast() : null;
    }

    public Iterator getActionIterator(boolean descending) {
        return descending ? this._potentialActions.descendingIterator() : this._potentialActions.iterator();
    }

    public void setAction(int position, IAction action, boolean notify) {
        this.pipe.setAction(position, action);
        if (CoreProxy.isRemote() && notify) {
            this.sendSelectionChange(position);
        }
    }

    public String getGateGuiFile() {
        return this.pipe.gate.getGuiFile();
    }

    public int getGateOrdinal() {
        return this.pipe.gate.kind.ordinal();
    }

    public String getGateName() {
        return this.pipe.gate.getName();
    }
}

