/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.blueprints.BlockSignature;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.blueprints.BptSlotInfo;
import buildcraft.api.blueprints.IBptContext;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.mod_BuildCraftTransport;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.Pipe;
import java.util.LinkedList;

public class BptBlockPipe
extends BptBlock {
    public BptBlockPipe(int blockId) {
        super(blockId);
    }

    @Override
    public void addRequirements(BptSlotInfo slot, IBptContext context, LinkedList requirements) {
        int pipeId = slot.cpt.f("pipeId");
        requirements.add(new aan(pipeId, 1, 0));
        if (slot.cpt.c("wire0")) {
            requirements.add(new aan(BuildCraftTransport.redPipeWire));
        }
        if (slot.cpt.c("wire1")) {
            requirements.add(new aan(BuildCraftTransport.bluePipeWire));
        }
        if (slot.cpt.c("wire2")) {
            requirements.add(new aan(BuildCraftTransport.greenPipeWire));
        }
        if (slot.cpt.c("wire3")) {
            requirements.add(new aan(BuildCraftTransport.yellowPipeWire));
        }
        if (slot.cpt.c("gate")) {
            int gateId = slot.cpt.f("gate");
            requirements.add(new aan(BuildCraftTransport.pipeGate, 1, gateId - 1));
        }
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].addRequirements(slot, requirements);
        }
    }

    @Override
    public boolean isValid(BptSlotInfo slot, IBptContext context) {
        Pipe pipe = BlockGenericPipe.getPipe((ali)context.world(), slot.x, slot.y, slot.z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.itemID == slot.cpt.f("pipeId");
        }
        return false;
    }

    @Override
    public void rotateLeft(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.f("pipeId");
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].rotateLeft(slot, context);
        }
    }

    @Override
    public void buildBlock(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.f("pipeId");
        Pipe pipe = BlockGenericPipe.createPipe(pipeId);
        for (int i = 0; i < pipe.wireSet.length; ++i) {
            if (!slot.cpt.c("wire" + i)) continue;
            pipe.wireSet[i] = true;
        }
        if (slot.cpt.c("gate")) {
            int gateId = slot.cpt.f("gate");
            pipe.gate = new GateVanilla(pipe);
            pipe.gate.kind = Gate.GateKind.values()[gateId];
            for (int i = 0; i < 8; ++i) {
                aan s;
                if (slot.cpt.c("trigger" + i)) {
                    pipe.activatedTriggers[i] = ActionManager.triggers[slot.cpt.f("trigger" + i)];
                }
                if (slot.cpt.c("triggerParameter" + i) && (s = aan.a((ady)((ady)slot.cpt.b("triggerParameter" + i)))) != null) {
                    pipe.triggerParameters[i] = new TriggerParameter();
                    pipe.triggerParameters[i].set(s);
                }
                if (!slot.cpt.c("action" + i)) continue;
                pipe.activatedActions[i] = ActionManager.actions[slot.cpt.f("action" + i)];
            }
        }
        BlockGenericPipe.placePipe(pipe, context.world(), slot.x, slot.y, slot.z, slot.blockId, slot.meta);
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].buildBlock(slot, context);
        }
    }

    @Override
    public void initializeFromWorld(BptSlotInfo bptSlot, IBptContext context, int x, int y, int z) {
        Pipe pipe = BlockGenericPipe.getPipe((ali)context.world(), x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            int i;
            bptSlot.cpt.a("pipeId", pipe.itemID);
            for (i = 0; i < pipe.wireSet.length; ++i) {
                if (!pipe.wireSet[i]) continue;
                bptSlot.cpt.a("wire" + i, 1);
            }
            if (pipe.hasGate()) {
                bptSlot.cpt.a("gate", pipe.gate.kind.ordinal());
                for (i = 0; i < 8; ++i) {
                    if (pipe.activatedTriggers[i] != null) {
                        bptSlot.cpt.a("trigger" + i, pipe.activatedTriggers[i].getId());
                    }
                    if (pipe.triggerParameters[i] != null) {
                        ady subCpt = new ady();
                        pipe.triggerParameters[i].getItemStack().b(subCpt);
                        bptSlot.cpt.a("triggerParameter" + i, (gh)subCpt);
                    }
                    if (pipe.activatedActions[i] == null) continue;
                    bptSlot.cpt.a("action" + i, pipe.activatedActions[i].getId());
                }
            }
            if (BuildCraftCore.itemBptProps[pipe.itemID] != null) {
                BuildCraftCore.itemBptProps[pipe.itemID].initializeFromWorld(bptSlot, context, x, y, z);
            }
        }
    }

    @Override
    public void postProcessing(BptSlotInfo slot, IBptContext context) {
        int pipeId = slot.cpt.f("pipeId");
        if (BuildCraftCore.itemBptProps[pipeId] != null) {
            BuildCraftCore.itemBptProps[pipeId].postProcessing(slot, context);
        }
    }

    @Override
    public BlockSignature getSignature(pb block) {
        BlockSignature sig = super.getSignature(block);
        sig.mod = "BuildCraftTransport";
        sig.modVersion = mod_BuildCraftTransport.instance.getVersion();
        return sig;
    }
}

