/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.BlockIndex;
import buildcraft.core.CoreProxy;
import buildcraft.core.EntityEnergyLaser;
import buildcraft.core.TileBuildCraft;
import buildcraft.factory.TileAssemblyTable;
import java.util.LinkedList;

public class TileLaser
extends TileBuildCraft
implements IPowerReceptor {
    private EntityEnergyLaser laser = null;
    private final SafeTimeTracker laserTickTracker = new SafeTimeTracker();
    private final SafeTimeTracker searchTracker = new SafeTimeTracker();
    private final SafeTimeTracker networkTracker = new SafeTimeTracker();
    private TileAssemblyTable assemblyTable;
    public IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private int nextNetworkUpdate = 3;
    private int nextLaserUpdate = 10;
    private int nextLaserSearch = 10;

    public TileLaser() {
        this.powerProvider.configure(20, 25, 25, 25, 1000);
    }

    @Override
    public void n_() {
        if (this.powerProvider.getEnergyStored() == 0.0f) {
            this.removeLaser();
            return;
        }
        if (!this.isValidTable() && this.canFindTable()) {
            this.findTable();
        }
        if (!this.isValidTable()) {
            this.removeLaser();
            return;
        }
        if (this.laser == null) {
            this.createLaser();
        }
        if (this.laser != null && this.canUpdateLaser()) {
            this.updateLaser();
        }
        float p = this.powerProvider.useEnergy(0.0f, 4.0f, true);
        this.assemblyTable.receiveLaserEnergy(p);
        if (this.laser != null) {
            this.laser.pushPower(p);
        }
        this.sendNetworkUpdate();
    }

    protected boolean canFindTable() {
        return this.searchTracker.markTimeIfDelay(this.i, this.nextLaserSearch);
    }

    protected boolean canUpdateLaser() {
        return this.laserTickTracker.markTimeIfDelay(this.i, this.nextLaserUpdate);
    }

    protected boolean isValidTable() {
        return this.assemblyTable != null && !this.assemblyTable.l() && this.assemblyTable.currentRecipe != null;
    }

    protected void findTable() {
        int meta = this.i.e(this.j, this.k, this.l);
        int minX = this.j - 5;
        int minY = this.k - 5;
        int minZ = this.l - 5;
        int maxX = this.j + 5;
        int maxY = this.k + 5;
        int maxZ = this.l + 5;
        switch (Orientations.values()[meta]) {
            case XNeg: {
                maxX = this.j;
                break;
            }
            case XPos: {
                minX = this.j;
                break;
            }
            case YNeg: {
                maxY = this.k;
                break;
            }
            case YPos: {
                minY = this.k;
                break;
            }
            case ZNeg: {
                maxZ = this.l;
                break;
            }
            case ZPos: {
                minZ = this.l;
            }
        }
        LinkedList<BlockIndex> targets = new LinkedList<BlockIndex>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    kw tile = this.i.b(x, y, z);
                    if (!(tile instanceof TileAssemblyTable)) continue;
                    TileAssemblyTable table = (TileAssemblyTable)tile;
                    if (table.currentRecipe == null) continue;
                    targets.add(new BlockIndex(x, y, z));
                }
            }
        }
        if (targets.size() == 0) {
            return;
        }
        BlockIndex b = (BlockIndex)targets.get(this.i.r.nextInt(targets.size()));
        this.assemblyTable = (TileAssemblyTable)this.i.b(b.i, b.j, b.k);
    }

    protected void createLaser() {
        if (CoreProxy.isServerSide()) {
            return;
        }
        this.laser = new EntityEnergyLaser(this.i, new Position(this.j, this.k, this.l), new Position(this.j, this.k, this.l));
        this.i.a((nn)this.laser);
    }

    protected void updateLaser() {
        int meta = this.i.e(this.j, this.k, this.l);
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (Orientations.values()[meta]) {
            case XNeg: {
                px = -0.3;
                break;
            }
            case XPos: {
                px = 0.3;
                break;
            }
            case YNeg: {
                py = -0.3;
                break;
            }
            case YPos: {
                py = 0.3;
                break;
            }
            case ZNeg: {
                pz = -0.3;
                break;
            }
            case ZPos: {
                pz = 0.3;
            }
        }
        Position head = new Position((double)this.j + 0.5 + px, (double)this.k + 0.5 + py, (double)this.l + 0.5 + pz);
        Position tail = new Position((double)this.assemblyTable.j + 0.475 + ((double)this.i.r.nextFloat() - 0.5) / 5.0, (float)this.assemblyTable.k + 0.5625f, (double)this.assemblyTable.l + 0.475 + ((double)this.i.r.nextFloat() - 0.5) / 5.0);
        this.laser.setPositions(head, tail);
        this.laser.show();
    }

    protected void removeLaser() {
        if (this.laser != null) {
            this.laser.A();
            this.laser = null;
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest() {
        if (this.powerProvider.getEnergyStored() < 200.0f || this.laser != null) {
            return 25;
        }
        return 0;
    }

    @Override
    public void sendNetworkUpdate() {
        if (this.networkTracker.markTimeIfDelay(this.i, this.nextNetworkUpdate)) {
            super.sendNetworkUpdate();
        }
    }

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.powerProvider.configure(20, 25, 25, 25, 1000);
    }

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
    }

    @Override
    public void h() {
        super.h();
        this.removeLaser();
    }
}

