/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.GuiAdvancedInterface;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.utils.StringUtil;
import buildcraft.factory.TileAssemblyTable;
import buildcraft.silicon.ContainerAssemblyTable;
import java.util.Iterator;
import java.util.LinkedList;
import org.lwjgl.opengl.GL11;

public class GuiAssemblyTable
extends GuiAdvancedInterface {
    TileAssemblyTable assemblyTable;

    public GuiAssemblyTable(io playerInventory, TileAssemblyTable assemblyTable) {
        super(new ContainerAssemblyTable(playerInventory, assemblyTable), assemblyTable);
        this.assemblyTable = assemblyTable;
        this.b = 175;
        this.c = 207;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[8];
        int p = 0;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 4; ++i) {
                this.slots[p] = new RecipeSlot(134 + 18 * j, 36 + 18 * i);
                ++p;
            }
        }
        this.updateRecipes();
        if (CoreProxy.isRemote()) {
            CoreProxy.sendToServer(new PacketCoordinates(20, assemblyTable.j, assemblyTable.k, assemblyTable.l).getPacket());
        }
    }

    public void updateRecipes() {
        LinkedList potentialRecipes = this.assemblyTable.getPotentialOutputs();
        Iterator cur = potentialRecipes.iterator();
        for (int p = 0; p < 8; ++p) {
            ((RecipeSlot)this.slots[p]).recipe = cur.hasNext() ? (AssemblyRecipe)cur.next() : null;
        }
    }

    @Override
    protected void d() {
        String title = StringUtil.localize("tile.assemblyTableBlock");
        this.u.b(title, this.getCenteredOffset(title), 15, 0x404040);
        this.u.b(StringUtil.localize("gui.inventory"), 8, this.c - 97, 0x404040);
        this.drawForegroundSelection();
    }

    protected void a(float f, int x, int y) {
        int i = this.p.p.b(DefaultProps.TEXTURE_PATH_GUI + "/assembly_table.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.p.p.b(i);
        int cornerX = (this.q - this.b) / 2;
        int cornerY = (this.r - this.c) / 2;
        this.b(cornerX, cornerY, 0, 0, this.b, this.c);
        this.updateRecipes();
        for (int s = 0; s < this.slots.length; ++s) {
            RecipeSlot slot = (RecipeSlot)this.slots[s];
            if (this.assemblyTable.isAssembling(slot.recipe)) {
                this.b(cornerX + slot.x, cornerY + slot.y, 196, 1, 16, 16);
                continue;
            }
            if (!this.assemblyTable.isPlanned(slot.recipe)) continue;
            this.b(cornerX + slot.x, cornerY + slot.y, 177, 1, 16, 16);
        }
        int height = (int)this.assemblyTable.getCompletionRatio(70.0f);
        this.b(cornerX + 95, cornerY + 36 + 70 - height, 176, 18, 4, height);
        this.drawBackgroundSlots();
    }

    @Override
    protected void a(int i, int j, int k) {
        super.a(i, j, k);
        int cornerX = (this.q - this.b) / 2;
        int cornerY = (this.r - this.c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        if (position != -1) {
            RecipeSlot slot = (RecipeSlot)this.slots[position];
            if (slot.recipe == null) {
                return;
            }
            TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
            if (this.assemblyTable.isPlanned(slot.recipe)) {
                this.assemblyTable.cancelPlanOutput(slot.recipe);
                message.select = false;
            } else {
                this.assemblyTable.planOutput(slot.recipe);
                message.select = true;
            }
            message.itemID = slot.recipe.output.c;
            message.itemDmg = slot.recipe.output.i();
            ContainerAssemblyTable container = (ContainerAssemblyTable)this.d;
            if (CoreProxy.isRemote()) {
                PacketPayload payload = TileAssemblyTable.selectionMessageWrapper.toPayload(container.x, container.y, container.z, message);
                PacketUpdate packet = new PacketUpdate(21, payload);
                packet.posX = this.assemblyTable.j;
                packet.posY = this.assemblyTable.k;
                packet.posZ = this.assemblyTable.l;
                CoreProxy.sendToServer(packet.getPacket());
            }
        }
    }

    public void handleSelectionMessage(TileAssemblyTable.SelectionMessage message) {
        this.assemblyTable.handleSelectionMessage(message);
    }

    class RecipeSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        public AssemblyRecipe recipe;

        public RecipeSlot(int x, int y) {
            super(x, y);
        }

        @Override
        public aan getItemStack() {
            if (this.recipe != null) {
                return this.recipe.output;
            }
            return null;
        }
    }
}

