/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftBlockUtil;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Orientations;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.Box;
import buildcraft.core.BptBlueprint;
import buildcraft.core.BptBuilderBase;
import buildcraft.core.BptBuilderBlueprint;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultAreaProvider;
import buildcraft.core.EntityRobot;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.IMachine;
import buildcraft.core.StackUtil;
import buildcraft.core.Utils;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.factory.EntityMechanicalArm;
import buildcraft.factory.IArmListener;
import buildcraft.factory.TileMachine;
import java.util.ArrayList;
import java.util.List;

public class TileQuarry
extends TileMachine
implements IArmListener,
IMachine,
IPowerReceptor,
IPipeConnection,
IBuilderInventory {
    boolean isDigging = false;
    @TileNetworkData
    public Box box = new Box();
    @TileNetworkData
    public boolean inProcess = false;
    public EntityMechanicalArm arm;
    @TileNetworkData
    public int targetX;
    @TileNetworkData
    public int targetY;
    @TileNetworkData
    public int targetZ;
    @TileNetworkData
    public double headPosX;
    @TileNetworkData
    public double headPosY;
    @TileNetworkData
    public double headPosZ;
    @TileNetworkData
    public double speed = 0.03;
    public EntityRobot builder;
    @TileNetworkData
    public boolean builderDone = false;
    boolean loadArm = false;
    BptBuilderBase bluePrintBuilder;
    public IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    public static int MAX_ENERGY = 7000;
    ady armStore = null;
    private boolean loadDefaultBoundaries = false;

    public TileQuarry() {
        this.powerProvider.configure(20, 25, 25, 25, MAX_ENERGY);
    }

    public void createUtilsIfNeeded() {
        if (!this.box.isInitialized() && CoreProxy.isClient(this.i)) {
            return;
        }
        if (this.bluePrintBuilder == null) {
            if (!this.box.isInitialized()) {
                this.setBoundaries(this.loadDefaultBoundaries);
            }
            this.initializeBluePrintBuilder();
        }
        if (this.builderDone) {
            this.box.deleteLasers();
            if (this.armStore != null) {
                this.arm = new EntityMechanicalArm(this.i);
                this.arm.e(this.armStore);
                this.arm.listener = this;
                this.loadArm = true;
                this.armStore = null;
            }
            if (this.arm == null) {
                this.createArm();
            }
            if (this.loadArm) {
                this.arm.joinToWorld(this.i);
                this.loadArm = false;
                if (this.findTarget(false)) {
                    this.isDigging = true;
                }
            }
        } else {
            this.box.createLasers(this.i, LaserKind.Stripes);
            this.isDigging = true;
        }
    }

    private void createArm() {
        this.arm = new EntityMechanicalArm(this.i, (float)this.box.xMin + 0.75f, (float)(this.k + this.bluePrintBuilder.bluePrint.sizeY - 1) + 0.25f, (float)this.box.zMin + 0.75f, (float)(this.bluePrintBuilder.bluePrint.sizeX - 2) + 0.5f, (float)(this.bluePrintBuilder.bluePrint.sizeZ - 2) + 0.5f, this);
        this.arm.listener = this;
        this.loadArm = true;
    }

    @Override
    public void n_() {
        super.n_();
        if (this.inProcess && this.arm != null) {
            this.arm.speed = 0.0;
            float energyToUse = 2.0f + this.powerProvider.getEnergyStored() / 1000.0f;
            float energy = this.powerProvider.useEnergy(energyToUse, energyToUse, true);
            if (energy > 0.0f) {
                this.arm.doMove(0.015 + (double)(energy / 200.0f));
            }
        }
        if (this.arm != null) {
            this.headPosX = this.arm.headPosX;
            this.headPosY = this.arm.headPosY;
            this.headPosZ = this.arm.headPosZ;
            this.speed = this.arm.speed;
        }
        if (CoreProxy.isServerSide()) {
            this.sendNetworkUpdate();
        }
        if (this.inProcess || !this.isDigging) {
            return;
        }
        this.createUtilsIfNeeded();
        if (this.bluePrintBuilder != null) {
            this.builderDone = this.bluePrintBuilder.done;
            if (!this.builderDone) {
                this.buildFrame();
                return;
            }
            if (this.builder != null && this.builder.done()) {
                this.box.deleteLasers();
                this.builder.A();
                this.builder = null;
            }
        }
        if (this.builder == null) {
            this.dig();
        }
    }

    @Override
    public void doWork() {
    }

    protected void buildFrame() {
        this.powerProvider.configure(20, 25, 25, 25, MAX_ENERGY);
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) != 25.0f) {
            return;
        }
        this.powerProvider.getTimeTracker().markTime(this.i);
        if (this.builder == null) {
            this.builder = new EntityRobot(this.i, this.box);
            this.i.a((nn)this.builder);
        }
        if (this.builder.readyToBuild()) {
            this.builder.scheduleContruction(this.bluePrintBuilder.getNextBlock(this.i, this), this.bluePrintBuilder.getContext());
        }
    }

    protected void dig() {
        this.powerProvider.configure(20, 30, 200, 50, MAX_ENERGY);
        if (this.powerProvider.useEnergy(30.0f, 30.0f, true) != 30.0f) {
            return;
        }
        if (!this.findTarget(true)) {
            if (this.arm != null && this.box != null) {
                this.arm.setTarget((double)this.box.xMin + this.arm.sizeX / 2.0, this.k + 2, (double)this.box.zMin + this.arm.sizeX / 2.0);
            }
            this.isDigging = false;
        }
        this.inProcess = true;
    }

    public boolean findTarget(boolean doSet) {
        if (CoreProxy.isClient(this.i)) {
            return false;
        }
        boolean[][] blockedColumns = new boolean[this.bluePrintBuilder.bluePrint.sizeX - 2][this.bluePrintBuilder.bluePrint.sizeZ - 2];
        for (int searchX = 0; searchX < this.bluePrintBuilder.bluePrint.sizeX - 2; ++searchX) {
            for (int searchZ = 0; searchZ < this.bluePrintBuilder.bluePrint.sizeZ - 2; ++searchZ) {
                blockedColumns[searchX][searchZ] = false;
            }
        }
        for (int searchY = this.k + 3; searchY >= 0; --searchY) {
            int incX;
            int endX;
            int startX;
            if (searchY % 2 == 0) {
                startX = 0;
                endX = this.bluePrintBuilder.bluePrint.sizeX - 2;
                incX = 1;
            } else {
                startX = this.bluePrintBuilder.bluePrint.sizeX - 3;
                endX = -1;
                incX = -1;
            }
            for (int searchX = startX; searchX != endX; searchX += incX) {
                int incZ;
                int endZ;
                int startZ;
                if (searchX % 2 == searchY % 2) {
                    startZ = 0;
                    endZ = this.bluePrintBuilder.bluePrint.sizeZ - 2;
                    incZ = 1;
                } else {
                    startZ = this.bluePrintBuilder.bluePrint.sizeZ - 3;
                    endZ = -1;
                    incZ = -1;
                }
                for (int searchZ = startZ; searchZ != endZ; searchZ += incZ) {
                    if (blockedColumns[searchX][searchZ]) continue;
                    int bx = this.box.xMin + searchX + 1;
                    int by = searchY;
                    int bz = this.box.zMin + searchZ + 1;
                    int blockId = this.i.a(bx, by, bz);
                    if (this.blockDig(blockId)) {
                        blockedColumns[searchX][searchZ] = true;
                        continue;
                    }
                    if (!this.canDig(blockId)) continue;
                    if (doSet && this.arm != null) {
                        this.arm.setTarget(bx, by + 1, bz);
                        this.targetX = (int)this.arm.targetX;
                        this.targetY = (int)this.arm.targetY;
                        this.targetZ = (int)this.arm.targetZ;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        if (nbttagcompound.c("box")) {
            this.box.initialize(nbttagcompound.m("box"));
            this.loadDefaultBoundaries = false;
        } else if (nbttagcompound.c("xSize")) {
            int xMin = nbttagcompound.f("xMin");
            int zMin = nbttagcompound.f("zMin");
            int xSize = nbttagcompound.f("xSize");
            int ySize = nbttagcompound.f("ySize");
            int zSize = nbttagcompound.f("zSize");
            this.box.initialize(xMin, this.k, zMin, xMin + xSize - 1, this.k + ySize - 1, zMin + zSize - 1);
            this.loadDefaultBoundaries = false;
        } else {
            this.loadDefaultBoundaries = true;
        }
        this.targetX = nbttagcompound.f("targetX");
        this.targetY = nbttagcompound.f("targetY");
        this.targetZ = nbttagcompound.f("targetZ");
        if (nbttagcompound.o("hasArm")) {
            this.armStore = nbttagcompound.m("arm");
        }
    }

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.a("targetX", this.targetX);
        nbttagcompound.a("targetY", this.targetY);
        nbttagcompound.a("targetZ", this.targetZ);
        nbttagcompound.a("hasArm", this.arm != null);
        if (this.arm != null) {
            ady armStore = new ady();
            nbttagcompound.a("arm", (gh)armStore);
            this.arm.d(armStore);
        }
        ady boxTag = new ady();
        this.box.writeToNBT(boxTag);
        nbttagcompound.a("box", (gh)boxTag);
    }

    @Override
    public void positionReached(EntityMechanicalArm arm) {
        this.inProcess = false;
        if (CoreProxy.isClient(this.i)) {
            return;
        }
        int i = this.targetX;
        int j = this.targetY - 1;
        int k = this.targetZ;
        int blockId = this.i.a(i, j, k);
        if (this.canDig(blockId)) {
            this.powerProvider.getTimeTracker().markTime(this.i);
            ArrayList stacks = BuildCraftBlockUtil.getItemStackFromBlock(this.i, i, j, k);
            if (stacks != null) {
                for (aan s : stacks) {
                    if (s == null) continue;
                    this.mineStack(s);
                }
            }
            this.i.g(i, j, k, 0);
        }
        wu axis = wu.b((double)(arm.headPosX - 1.5), (double)arm.headPosY, (double)(arm.headPosZ - 1.5), (double)(arm.headPosX + 2.5), (double)(arm.headPosY + 2.5), (double)(arm.headPosZ + 2.5));
        List result = this.i.a(fq.class, axis);
        for (int ii = 0; ii < result.size(); ++ii) {
            if (!(result.get(ii) instanceof fq)) continue;
            fq entity = (fq)result.get(ii);
            if (entity.G || entity.a.a <= 0) continue;
            CoreProxy.removeEntity((nn)entity);
            this.mineStack(entity.a);
        }
    }

    private void mineStack(aan s) {
        boolean added = false;
        StackUtil stackUtils = new StackUtil(s);
        added = stackUtils.addToRandomInventory(this, Orientations.Unknown);
        if (!added || stackUtils.items.a > 0) {
            added = Utils.addToRandomPipeEntry(this, Orientations.Unknown, stackUtils.items);
        }
        if (!added) {
            float f = this.i.r.nextFloat() * 0.8f + 0.1f;
            float f1 = this.i.r.nextFloat() * 0.8f + 0.1f;
            float f2 = this.i.r.nextFloat() * 0.8f + 0.1f;
            fq entityitem = new fq(this.i, (double)((float)this.j + f), (double)((float)this.k + f1 + 0.5f), (double)((float)this.l + f2), stackUtils.items);
            float f3 = 0.05f;
            entityitem.r = (float)this.i.r.nextGaussian() * f3;
            entityitem.s = (float)this.i.r.nextGaussian() * f3 + 1.0f;
            entityitem.t = (float)this.i.r.nextGaussian() * f3;
            this.i.a((nn)entityitem);
        }
    }

    private boolean blockDig(int blockID) {
        if (pb.m[blockID] != null && pb.m[blockID].n() == -1.0f) {
            return true;
        }
        return blockID == pb.D.bO || blockID == pb.C.bO;
    }

    private boolean canDig(int blockID) {
        return !this.blockDig(blockID) && !BuildCraftAPI.softBlock(blockID);
    }

    @Override
    public void h() {
        super.h();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.arm != null) {
            this.arm.A();
        }
        if (this.builder != null) {
            this.builder.A();
        }
        this.box.deleteLasers();
        this.arm = null;
    }

    @Override
    public boolean isActive() {
        return this.isDigging;
    }

    private void setBoundaries(boolean useDefault) {
        IAreaProvider a = null;
        if (!useDefault) {
            a = Utils.getNearbyAreaProvider(this.i, this.j, this.k, this.l);
        }
        if (a == null) {
            a = new DefaultAreaProvider(this.j, this.k, this.l, this.j + 10, this.k + 4, this.l + 10);
            useDefault = true;
        }
        int xSize = a.xMax() - a.xMin() + 1;
        int ySize = a.yMax() - a.yMin() + 1;
        int zSize = a.zMax() - a.zMin() + 1;
        if (xSize < 3 || zSize < 3) {
            a = new DefaultAreaProvider(this.j, this.k, this.l, this.j + 10, this.k + 4, this.l + 10);
            useDefault = true;
        }
        xSize = a.xMax() - a.xMin() + 1;
        ySize = a.yMax() - a.yMin() + 1;
        zSize = a.zMax() - a.zMin() + 1;
        this.box.initialize(a);
        if (ySize < 5) {
            ySize = 5;
            this.box.yMax = this.box.yMin + ySize - 1;
        }
        if (useDefault) {
            int xMin = 0;
            int zMin = 0;
            Orientations o = Orientations.values()[this.i.e(this.j, this.k, this.l)].reverse();
            switch (o) {
                case XPos: {
                    xMin = this.j + 1;
                    zMin = this.l - 4 - 1;
                    break;
                }
                case XNeg: {
                    xMin = this.j - 9 - 2;
                    zMin = this.l - 4 - 1;
                    break;
                }
                case ZPos: {
                    xMin = this.j - 4 - 1;
                    zMin = this.l + 1;
                    break;
                }
                default: {
                    xMin = this.j - 4 - 1;
                    zMin = this.l - 9 - 2;
                }
            }
            this.box.initialize(xMin, this.k, zMin, xMin + xSize - 1, this.k + ySize - 1, zMin + zSize - 1);
        }
        a.removeFromWorld();
    }

    private void initializeBluePrintBuilder() {
        BptBlueprint bluePrint = new BptBlueprint(this.box.sizeX(), this.box.sizeY(), this.box.sizeZ());
        for (int i = 0; i < bluePrint.sizeX; ++i) {
            for (int j = 0; j < bluePrint.sizeY; ++j) {
                for (int k = 0; k < bluePrint.sizeZ; ++k) {
                    bluePrint.setBlockId(i, j, k, 0);
                }
            }
        }
        for (int it = 0; it < 2; ++it) {
            for (int i = 0; i < bluePrint.sizeX; ++i) {
                bluePrint.setBlockId(i, it * (this.box.sizeY() - 1), 0, BuildCraftFactory.frameBlock.bO);
                bluePrint.setBlockId(i, it * (this.box.sizeY() - 1), bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.bO);
            }
            for (int k = 0; k < bluePrint.sizeZ; ++k) {
                bluePrint.setBlockId(0, it * (this.box.sizeY() - 1), k, BuildCraftFactory.frameBlock.bO);
                bluePrint.setBlockId(bluePrint.sizeX - 1, it * (this.box.sizeY() - 1), k, BuildCraftFactory.frameBlock.bO);
            }
        }
        for (int h = 1; h < this.box.sizeY(); ++h) {
            bluePrint.setBlockId(0, h, 0, BuildCraftFactory.frameBlock.bO);
            bluePrint.setBlockId(0, h, bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.bO);
            bluePrint.setBlockId(bluePrint.sizeX - 1, h, 0, BuildCraftFactory.frameBlock.bO);
            bluePrint.setBlockId(bluePrint.sizeX - 1, h, bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.bO);
        }
        this.bluePrintBuilder = new BptBuilderBlueprint(bluePrint, this.i, this.box.xMin, this.k, this.box.zMin);
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
        super.postPacketHandling(packet);
        this.createUtilsIfNeeded();
        if (this.arm != null) {
            this.arm.setHeadPosition(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.setTarget(this.targetX, this.targetY, this.targetZ);
            this.arm.speed = this.speed;
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!CoreProxy.isClient(this.i)) {
            this.createUtilsIfNeeded();
        }
        this.sendNetworkUpdate();
    }

    public void reinitalize() {
        this.builderDone = false;
        this.initializeBluePrintBuilder();
        this.isDigging = true;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        provider = this.powerProvider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean isPipeConnected(Orientations with) {
        return true;
    }

    public int a() {
        return 0;
    }

    public aan k_(int i) {
        return null;
    }

    public aan a(int i, int j) {
        return null;
    }

    public void a(int i, aan itemstack) {
    }

    public aan b(int slot) {
        return null;
    }

    public String c() {
        return "";
    }

    public int d() {
        return 0;
    }

    public boolean a_(yw entityplayer) {
        return false;
    }

    public void e() {
    }

    public void f() {
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return true;
    }

    @Override
    public boolean allowActions() {
        return false;
    }
}

