/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Orientations;
import buildcraft.core.DefaultProps;
import buildcraft.core.IInventoryRenderer;
import buildcraft.energy.Engine;
import buildcraft.energy.IEngineProvider;
import forge.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderEngine
extends aar
implements IInventoryRenderer {
    private ho model = new ho(){};
    private qp box = new qp(this.model, 0, 0);
    private qp trunk;
    private qp movingBox;
    private qp chamber;
    private String baseTexture;

    public RenderEngine() {
        this.box.a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.box.c = 8.0f;
        this.box.d = 8.0f;
        this.box.e = 8.0f;
        this.trunk = new qp(this.model, 0, 0);
        this.trunk.a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.c = 8.0f;
        this.trunk.d = 8.0f;
        this.trunk.e = 8.0f;
        this.movingBox = new qp(this.model, 0, 0);
        this.movingBox.a(-8.0f, -4.0f, -8.0f, 16, 4, 16);
        this.movingBox.c = 8.0f;
        this.movingBox.d = 8.0f;
        this.movingBox.e = 8.0f;
        this.chamber = new qp(this.model, 0, 0);
        this.chamber.a(-5.0f, -4.0f, -5.0f, 10, 2, 10);
        this.chamber.c = 8.0f;
        this.chamber.d = 8.0f;
        this.chamber.e = 8.0f;
    }

    public RenderEngine(String baseTexture) {
        this();
        this.baseTexture = baseTexture;
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(Engine.EnergyStage.Blue, 0.25f, Orientations.YPos, this.baseTexture, x, y, z);
    }

    public void a(kw tileentity, double x, double y, double z, float f) {
        Engine engine = ((IEngineProvider)tileentity).getEngine();
        if (engine != null) {
            this.render(engine.getEnergyStage(), engine.progress, engine.orientation, engine.getTextureFile(), x, y, z);
        }
    }

    private void render(Engine.EnergyStage energy, float progress, Orientations orientation, String baseTexture, double x, double y, double z) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 7.99f - (progress - 0.5f) * 2.0f * 7.99f : progress * 2.0f * 7.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float translatefact = step / 16.0f;
        switch (orientation) {
            case XPos: {
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case XNeg: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case YPos: {
                translate[1] = 1.0f;
                break;
            }
            case YNeg: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case ZPos: {
                angle[0] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            case ZNeg: {
                angle[0] = -1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.box.f = angle[0];
        this.box.g = angle[1];
        this.box.h = angle[2];
        this.trunk.f = angle[0];
        this.trunk.g = angle[1];
        this.trunk.h = angle[2];
        this.movingBox.f = angle[0];
        this.movingBox.g = angle[1];
        this.movingBox.h = angle[2];
        this.chamber.f = angle[0];
        this.chamber.g = angle[1];
        this.chamber.h = angle[2];
        float factor = 0.0625f;
        MinecraftForgeClient.bindTexture((String)baseTexture);
        this.box.a(factor);
        GL11.glTranslatef((float)(translate[0] * translatefact), (float)(translate[1] * translatefact), (float)(translate[2] * translatefact));
        this.movingBox.a(factor);
        GL11.glTranslatef((float)(-translate[0] * translatefact), (float)(-translate[1] * translatefact), (float)(-translate[2] * translatefact));
        MinecraftForgeClient.bindTexture((String)(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber.png"));
        float chamberf = 0.125f;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.chamber.a(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        i = 0;
        while ((float)i <= step + 2.0f) {
            GL11.glTranslatef((float)(-translate[0] * chamberf), (float)(-translate[1] * chamberf), (float)(-translate[2] * chamberf));
            i += 2;
        }
        String texture = "";
        switch (energy) {
            case Blue: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_blue.png";
                break;
            }
            case Green: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_green.png";
                break;
            }
            case Yellow: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_yellow.png";
                break;
            }
            default: {
                texture = DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_red.png";
            }
        }
        MinecraftForgeClient.bindTexture((String)texture);
        this.trunk.a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

