/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.core.BuildCraftContainer;
import buildcraft.core.DefaultProps;
import buildcraft.core.GuiBuildCraft;
import buildcraft.core.utils.StringUtil;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;

public abstract class GuiEngine
extends GuiBuildCraft {
    public GuiEngine(BuildCraftContainer container, io inventory) {
        super(container, inventory);
    }

    @Override
    protected void initLedgers(io inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add(new EngineLedger(((TileEngine)this.tile).engine));
    }

    protected class EngineLedger
    extends GuiBuildCraft.Ledger {
        Engine engine;
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public EngineLedger(Engine engine) {
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(DefaultProps.TEXTURE_ICONS, 0, x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.u.a(StringUtil.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiEngine.this.u.a(StringUtil.localize("gui.currentOutput") + ":", x + 22, y + 20, this.subheaderColour);
            GuiEngine.this.u.b(this.engine.getCurrentOutput() + " MJ/t", x + 22, y + 32, this.textColour);
            GuiEngine.this.u.a(StringUtil.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiEngine.this.u.b(this.engine.getEnergyStored() + " MJ", x + 22, y + 56, this.textColour);
            GuiEngine.this.u.a(StringUtil.localize("gui.heat") + ":", x + 22, y + 68, this.subheaderColour);
            GuiEngine.this.u.b((double)this.engine.getHeat() / 10.0 + " \u00b0C", x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return this.engine.getCurrentOutput() + " MJ/t";
        }
    }
}

