/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.core.Orientations;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.liquids.LiquidManager;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.liquids.LiquidTank;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.energy.ContainerEngine;
import buildcraft.energy.Engine;
import buildcraft.energy.TileEngine;

public class EngineIron
extends Engine {
    public static int MAX_LIQUID = 10000;
    public static int MAX_HEAT = 100000;
    public static int COOLANT_THRESHOLD = 49000;
    private aan itemInInventory;
    int burnTime = 0;
    int liquidQty = 0;
    int liquidId = 0;
    int coolantQty = 0;
    int coolantId = 0;
    int heat = 0;
    public int penaltyCooling = 0;
    boolean lastPowered = false;

    public EngineIron(TileEngine engine) {
        super(engine);
        this.maxEnergy = 100000;
        this.maxEnergyExtracted = 500;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_PATH_BLOCKS + "/base_iron.png";
    }

    @Override
    public int explosionRange() {
        return 8;
    }

    @Override
    public int maxEnergyReceived() {
        return 2000;
    }

    @Override
    public float getPistonSpeed() {
        switch (this.getEnergyStage()) {
            case Blue: {
                return 0.04f;
            }
            case Green: {
                return 0.05f;
            }
            case Yellow: {
                return 0.06f;
            }
            case Red: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        return this.liquidQty > 0 && this.penaltyCooling == 0 && this.tile.isRedstonePowered;
    }

    @Override
    public void burn() {
        this.currentOutput = 0.0f;
        IronEngineFuel currentFuel = IronEngineFuel.getFuelForLiquid(new LiquidStack(this.liquidId, this.liquidQty, 0));
        if (currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0 && this.tile.isRedstonePowered) {
            this.lastPowered = true;
            if (this.burnTime > 0 || this.liquidQty > 0) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                } else {
                    --this.liquidQty;
                    this.burnTime = currentFuel.totalBurningTime / 1000;
                }
                this.currentOutput = currentFuel.powerPerCycle;
                this.addEnergy(currentFuel.powerPerCycle);
                this.heat = (int)((float)this.heat + currentFuel.powerPerCycle);
            }
        } else if (this.penaltyCooling <= 0 && this.lastPowered) {
            this.lastPowered = false;
            this.penaltyCooling = 600;
        }
    }

    @Override
    public void update() {
        LiquidStack liquid;
        super.update();
        if (this.itemInInventory != null && (liquid = LiquidManager.getLiquidForFilledItem(this.itemInInventory)) != null && this.fill(Orientations.Unknown, liquid, false) == liquid.amount) {
            this.fill(Orientations.Unknown, liquid, true);
            this.tile.a(0, Utils.consumeItem(this.itemInInventory));
        }
        if (this.heat > COOLANT_THRESHOLD) {
            int extraHeat = this.heat - COOLANT_THRESHOLD;
            IronEngineCoolant currentCoolant = IronEngineCoolant.getCoolantForLiquid(new LiquidStack(this.coolantId, this.coolantQty, 0));
            if (currentCoolant != null) {
                if ((float)this.coolantQty * currentCoolant.coolingPerUnit > (float)extraHeat) {
                    this.coolantQty -= Math.round((float)extraHeat / currentCoolant.coolingPerUnit);
                    this.heat = COOLANT_THRESHOLD;
                } else {
                    this.heat = (int)((float)this.heat - (float)this.coolantQty * currentCoolant.coolingPerUnit);
                    this.coolantQty = 0;
                }
            }
        }
        if (!(this.heat <= 0 || this.penaltyCooling <= 0 && this.tile.isRedstonePowered)) {
            this.heat -= 10;
        }
        if (this.heat <= 0 && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
    }

    @Override
    public void computeEnergyStage() {
        this.energyStage = this.heat <= MAX_HEAT / 4 ? Engine.EnergyStage.Blue : (this.heat <= MAX_HEAT / 2 ? Engine.EnergyStage.Green : ((float)this.heat <= (float)MAX_HEAT * 3.0f / 4.0f ? Engine.EnergyStage.Yellow : (this.heat <= MAX_HEAT ? Engine.EnergyStage.Red : Engine.EnergyStage.Explosion)));
    }

    @Override
    public int getScaledBurnTime(int i) {
        return (int)((float)this.liquidQty / (float)MAX_LIQUID * (float)i);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        this.liquidId = nbttagcompound.f("liquidId");
        this.liquidQty = nbttagcompound.f("liquidQty");
        this.burnTime = nbttagcompound.f("burnTime");
        this.coolantId = nbttagcompound.f("coolantId");
        this.coolantQty = nbttagcompound.f("coolantQty");
        this.heat = nbttagcompound.f("heat");
        this.penaltyCooling = nbttagcompound.f("penaltyCooling");
        if (nbttagcompound.c("itemInInventory")) {
            ady cpt = nbttagcompound.m("itemInInventory");
            this.itemInInventory = aan.a((ady)cpt);
        }
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("liquidId", this.liquidId);
        nbttagcompound.a("liquidQty", this.liquidQty);
        nbttagcompound.a("burnTime", this.burnTime);
        nbttagcompound.a("coolantId", this.coolantId);
        nbttagcompound.a("coolantQty", this.coolantQty);
        nbttagcompound.a("heat", this.heat);
        nbttagcompound.a("penaltyCooling", this.penaltyCooling);
        if (this.itemInInventory != null) {
            ady cpt = new ady();
            this.itemInInventory.b(cpt);
            nbttagcompound.a("itemInInventory", (gh)cpt);
        }
    }

    public int getScaledCoolant(int i) {
        return (int)((float)this.coolantQty / (float)MAX_LIQUID * (float)i);
    }

    @Override
    public void delete() {
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.energy = j / 10;
                break;
            }
            case 1: {
                this.currentOutput = j / 10;
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                this.liquidQty = j;
                break;
            }
            case 4: {
                this.liquidId = j;
                break;
            }
            case 5: {
                this.coolantQty = j;
                break;
            }
            case 6: {
                this.coolantId = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, wm iCrafting) {
        iCrafting.a((dd)containerEngine, 0, Math.round(this.energy * 10.0f));
        iCrafting.a((dd)containerEngine, 1, Math.round(this.currentOutput * 10.0f));
        iCrafting.a((dd)containerEngine, 2, this.heat);
        iCrafting.a((dd)containerEngine, 3, this.liquidQty);
        iCrafting.a((dd)containerEngine, 4, this.liquidId);
        iCrafting.a((dd)containerEngine, 5, this.coolantQty);
        iCrafting.a((dd)containerEngine, 6, this.coolantId);
    }

    @Override
    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    public int fill(Orientations from, LiquidStack resource, boolean doFill) {
        if (IronEngineCoolant.getCoolantForLiquid(resource) != null) {
            return this.fillCoolant(from, resource, doFill);
        }
        int res = 0;
        if (this.liquidQty > 0 && this.liquidId != resource.itemID) {
            return 0;
        }
        if (IronEngineFuel.getFuelForLiquid(resource) == null) {
            return 0;
        }
        if (this.liquidQty + resource.amount <= MAX_LIQUID) {
            if (doFill) {
                this.liquidQty += resource.amount;
            }
            res = resource.amount;
        } else {
            res = MAX_LIQUID - this.liquidQty;
            if (doFill) {
                this.liquidQty = MAX_LIQUID;
            }
        }
        this.liquidId = resource.itemID;
        return res;
    }

    private int fillCoolant(Orientations from, LiquidStack resource, boolean doFill) {
        int res = 0;
        if (this.coolantQty > 0 && this.coolantId != resource.itemID) {
            return 0;
        }
        if (this.coolantQty + resource.amount <= MAX_LIQUID) {
            if (doFill) {
                this.coolantQty += resource.amount;
            }
            res = resource.amount;
        } else {
            res = MAX_LIQUID - this.coolantQty;
            if (doFill) {
                this.coolantQty = MAX_LIQUID;
            }
        }
        this.coolantId = resource.itemID;
        return res;
    }

    @Override
    public LiquidTank[] getLiquidSlots() {
        return new LiquidTank[]{new LiquidTank(this.liquidId, this.liquidQty, MAX_LIQUID), new LiquidTank(this.coolantId, this.coolantQty, MAX_LIQUID)};
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public aan getStackInSlot(int i) {
        return this.itemInInventory;
    }

    @Override
    public void setInventorySlotContents(int i, aan itemstack) {
        this.itemInInventory = itemstack;
    }

    @Override
    public aan decrStackSize(int i, int j) {
        if (this.itemInInventory != null) {
            aan newStack = this.itemInInventory.a(j);
            if (this.itemInInventory.a == 0) {
                this.itemInInventory = null;
            }
            return newStack;
        }
        return null;
    }

    @Override
    public aan getStackInSlotOnClosing(int var1) {
        if (this.itemInInventory == null) {
            return null;
        }
        aan toReturn = this.itemInInventory;
        this.itemInInventory = null;
        return toReturn;
    }
}

