/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.Utils;
import buildcraft.core.network.IndexInPayload;

public class PacketPayload {
    public int[] intPayload = new int[0];
    public float[] floatPayload = new float[0];
    public String[] stringPayload = new String[0];

    public PacketPayload() {
    }

    public PacketPayload(int intSize, int floatSize, int stringSize) {
        this.intPayload = new int[intSize];
        this.floatPayload = new float[floatSize];
        this.stringPayload = new String[stringSize];
    }

    public void append(PacketPayload other) {
        if (other == null) {
            return;
        }
        if (other.intPayload.length > 0) {
            this.intPayload = Utils.concat(this.intPayload, other.intPayload);
        }
        if (other.floatPayload.length > 0) {
            this.floatPayload = Utils.concat(this.floatPayload, other.floatPayload);
        }
        if (other.stringPayload.length > 0) {
            this.stringPayload = (String[])Utils.concat(this.stringPayload, other.stringPayload);
        }
    }

    public void append(int[] other) {
        if (other == null || other.length < 0) {
            return;
        }
        this.intPayload = Utils.concat(this.intPayload, other);
    }

    public void splitTail(IndexInPayload index) {
        PacketPayload payload = new PacketPayload(this.intPayload.length - index.intIndex, this.floatPayload.length - index.floatIndex, this.stringPayload.length - index.stringIndex);
        if (this.intPayload.length > 0) {
            System.arraycopy(this.intPayload, index.intIndex, payload.intPayload, 0, payload.intPayload.length);
        }
        if (this.floatPayload.length > 0) {
            System.arraycopy(this.floatPayload, index.floatIndex, payload.floatPayload, 0, payload.floatPayload.length);
        }
        if (this.stringPayload.length > 0) {
            System.arraycopy(this.stringPayload, index.stringIndex, payload.stringPayload, 0, payload.stringPayload.length);
        }
    }
}

