/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.api.liquids.ILiquidTank;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidManager;
import buildcraft.core.DefaultProps;

public class TriggerLiquidContainer
extends Trigger {
    public State state;

    public TriggerLiquidContainer(int id, State state) {
        super(id);
        this.state = state;
    }

    @Override
    public int getIndexInTexture() {
        switch (this.state) {
            case Empty: {
                return 32;
            }
            case Contains: {
                return 33;
            }
            case Space: {
                return 34;
            }
        }
        return 35;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Tank Empty";
            }
            case Contains: {
                return "Liquid in Tank";
            }
            case Space: {
                return "Space for Liquid";
            }
        }
        return "Tank Full";
    }

    @Override
    public boolean isTriggerActive(kw tile, ITriggerParameter parameter) {
        if (tile instanceof ITankContainer) {
            ILiquidTank[] liquids;
            ITankContainer container = (ITankContainer)tile;
            int seachedLiquidId = 0;
            if (parameter != null && parameter.getItem() != null) {
                seachedLiquidId = LiquidManager.getLiquidIDForFilledItem(parameter.getItem());
            }
            if ((liquids = container.getTanks()) == null || liquids.length == 0) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    if (liquids != null && liquids.length > 0) {
                        for (ILiquidTank c : liquids) {
                            if (c.getLiquid() == null || c.getLiquid().amount == 0) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case Contains: {
                    for (ILiquidTank c : liquids) {
                        if (c.getLiquid() == null || c.getLiquid().amount == 0 || seachedLiquidId != 0 && seachedLiquidId != c.getLiquid().itemID) continue;
                        return true;
                    }
                    return false;
                }
                case Space: {
                    for (ILiquidTank c : liquids) {
                        if (c.getLiquid() == null || c.getLiquid().amount == 0) {
                            return true;
                        }
                        if (c.getLiquid().amount >= c.getCapacity() || seachedLiquidId != 0 && seachedLiquidId != c.getLiquid().itemID) continue;
                        return true;
                    }
                    return false;
                }
                case Full: {
                    for (ILiquidTank c : liquids) {
                        if (c.getLiquid() != null && c.getLiquid().amount >= c.getCapacity()) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

