/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;

public class TriggerInventory
extends Trigger {
    public State state;

    public TriggerInventory(int id, State state) {
        super(id);
        this.state = state;
    }

    @Override
    public int getIndexInTexture() {
        switch (this.state) {
            case Empty: {
                return 36;
            }
            case Contains: {
                return 37;
            }
            case Space: {
                return 38;
            }
        }
        return 39;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "Inventory Empty";
            }
            case Contains: {
                return "Items in Inventory";
            }
            case Space: {
                return "Space in Inventory";
            }
        }
        return "Inventory Full";
    }

    @Override
    public boolean isTriggerActive(kw tile, ITriggerParameter parameter) {
        aan searchedStack = null;
        if (parameter != null) {
            searchedStack = parameter.getItem();
        }
        if (tile instanceof io && ((io)tile).a() > 0) {
            io inv = Utils.getInventory((io)tile);
            boolean foundItems = false;
            boolean foundSpace = false;
            for (int i = 0; i < inv.a(); ++i) {
                aan stack = inv.k_(i);
                if (parameter == null || parameter.getItemStack() == null) {
                    foundItems = foundItems || stack != null && stack.a > 0;
                } else if (stack != null && stack.a > 0) {
                    boolean bl = foundItems = foundItems || stack.c == parameter.getItemStack().c && stack.i() == parameter.getItemStack().i();
                }
                if (stack == null || stack.a == 0) {
                    foundSpace = true;
                    continue;
                }
                if (searchedStack == null || stack.a >= stack.c() || stack.c != searchedStack.c || stack.i() != searchedStack.i()) continue;
                foundSpace = true;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_TRIGGERS;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

