/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;

public class RedstonePowerProvider
extends PowerProvider {
    private boolean lastPower = false;

    public RedstonePowerProvider() {
        this.powerLoss = 0;
        this.powerLossRegularity = 0;
    }

    @Override
    public boolean preConditions(IPowerReceptor receptor) {
        kw tile = (kw)receptor;
        boolean currentPower = tile.i.x(tile.j, tile.k, tile.l);
        if (BuildCraftCore.continuousCurrentModel) {
            if (currentPower) {
                return true;
            }
        } else if (currentPower != this.lastPower) {
            this.lastPower = currentPower;
            if (currentPower) {
                return true;
            }
        }
        return false;
    }

    @Override
    public float useEnergy(float min, float max, boolean doUse) {
        return min;
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.lastPower = nbttagcompound.o("lastPower");
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        nbttagcompound.a("lastPower", this.lastPower);
    }

    @Override
    public void configure(int latency, int minEnergyReceived, int maxEnergyReceived, int minActivationEnergy, int maxStoredEnergy) {
        super.configure(latency, minEnergyReceived, maxEnergyReceived, minActivationEnergy, maxStoredEnergy);
        this.minActivationEnergy = 0;
        this.energyStored = 1.0f;
    }

    @Override
    public void configurePowerPerdition(int powerLoss, int powerLossRegularity) {
    }
}

