/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.Position;
import buildcraft.core.BlockIndex;
import buildcraft.core.Box;
import buildcraft.core.BptBuilderBase;
import buildcraft.core.BptContext;
import buildcraft.core.BptSlot;
import buildcraft.core.CoreProxy;
import buildcraft.core.EntityEnergyLaser;
import forge.ISpawnHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class EntityRobot
extends nn
implements ISpawnHandler {
    private Box box;
    private int destX;
    private int destY;
    private int destZ;
    EntityEnergyLaser laser;
    public LinkedList targets = new LinkedList();
    public static int MAX_TARGETS = 20;
    public int wait = 0;

    public EntityRobot(xd world) {
        super(world);
    }

    public EntityRobot(xd world, Box box) {
        super(world);
        this.box = box;
        this.init();
    }

    protected void init() {
        this.destX = (int)this.box.centerX();
        this.destY = (int)this.box.centerY();
        this.destZ = (int)this.box.centerZ();
        this.r = 0.0;
        this.s = 0.0;
        this.t = 0.0;
        this.d(this.destX, this.destY, this.destZ);
        this.laser = new EntityEnergyLaser(this.k, new Position(this.o, this.p, this.q), new Position(this.o, this.p, this.q));
        this.k.a((nn)this.laser);
    }

    public void writeSpawnData(DataOutputStream data) throws IOException {
        data.writeInt(this.box.xMin);
        data.writeInt(this.box.yMin);
        data.writeInt(this.box.zMin);
        data.writeInt(this.box.xMax);
        data.writeInt(this.box.yMax);
        data.writeInt(this.box.zMax);
    }

    public void readSpawnData(DataInputStream data) throws IOException {
        this.box = new Box();
        this.box.xMin = data.readInt();
        this.box.yMin = data.readInt();
        this.box.zMin = data.readInt();
        this.box.xMax = data.readInt();
        this.box.yMax = data.readInt();
        this.box.zMax = data.readInt();
        this.init();
    }

    protected void b() {
    }

    protected void a(ady nbttagcompound) {
    }

    protected void b(ady nbttagcompound) {
    }

    public void J_() {
        this.move();
        this.build();
        this.updateLaser();
    }

    protected void move() {
        BlockIndex newDesination;
        this.d(this.o + this.r, this.p + this.s, this.q + this.t);
        if (this.reachedDesination() && (newDesination = this.getNewDesination()) != null) {
            this.setDestination(newDesination.i, newDesination.j, newDesination.k);
        }
    }

    protected BlockIndex getNewDesination() {
        Box movementBoundary = new Box();
        movementBoundary.initialize(this.box);
        movementBoundary.expand(1);
        Box moveArea = new Box();
        moveArea.initialize(this.destX, this.destY, this.destZ, 1);
        ArrayList<BlockIndex> potentialDestinations = new ArrayList<BlockIndex>();
        for (BlockIndex blockIndex : moveArea.getBlocksInArea()) {
            if (!BuildCraftAPI.softBlock(blockIndex.getBlockId(this.k)) || !movementBoundary.contains(blockIndex)) continue;
            potentialDestinations.add(blockIndex);
        }
        if (!potentialDestinations.isEmpty()) {
            int i = this.k.r.nextInt(potentialDestinations.size());
            return (BlockIndex)potentialDestinations.get(i);
        }
        return null;
    }

    protected void setDestination(int x, int y, int z) {
        this.destX = x;
        this.destY = y;
        this.destZ = z;
        this.r = ((double)this.destX - this.o) / 75.0 * (double)(this.laser.getPowerAverage() / 2.0f + 1.0f);
        this.s = ((double)this.destY - this.p) / 75.0 * (double)(this.laser.getPowerAverage() / 2.0f + 1.0f);
        this.t = ((double)this.destZ - this.q) / 75.0 * (double)(this.laser.getPowerAverage() / 2.0f + 1.0f);
    }

    protected boolean reachedDesination() {
        return this.g(this.destX, this.destY, this.destZ) <= 0.2;
    }

    protected void build() {
        this.updateWait();
        if (this.targets.size() > 0) {
            Action a = (Action)this.targets.getFirst();
            if (a.slot != null) {
                BptSlot target = a.slot;
                if (this.wait <= 0) {
                    if (!CoreProxy.isClient(this.k)) {
                        if (target.mode == BptSlot.Mode.ClearIfInvalid) {
                            if (!target.isValid(a.context)) {
                                this.k.d(target.x, target.y, target.z, 0, 0);
                            }
                        } else if (target.stackToUse != null) {
                            this.k.g(target.x, target.y, target.z, 0);
                            target.stackToUse.a().a(target.stackToUse, CoreProxy.getBuildCraftPlayer(this.k), this.k, target.x, target.y - 1, target.z, 1);
                        } else {
                            try {
                                target.buildBlock(a.context);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                ModLoader.getLogger().throwing("EntityRobot", "update", t);
                            }
                        }
                    }
                    this.targets.pop();
                }
            } else if (a.builder != null) {
                a.builder.postProcessing(this.k);
                this.targets.pop();
            }
        }
    }

    public void updateWait() {
        if (this.targets.size() > 0) {
            this.wait = this.wait == 0 ? MAX_TARGETS - this.targets.size() + 2 : --this.wait;
        }
    }

    private void updateLaser() {
        if (this.targets.size() > 0) {
            Action a = (Action)this.targets.getFirst();
            BptSlot target = a.slot;
            if (target != null) {
                this.laser.setPositions(new Position(this.o, this.p, this.q), new Position((double)target.x + 0.5, (double)target.y + 0.5, (double)target.z + 0.5));
                this.laser.show();
            }
        } else {
            this.laser.hide();
        }
        this.laser.pushPower((float)this.targets.size() / (float)MAX_TARGETS * 4.0f);
    }

    public void scheduleContruction(BptSlot slot, BptContext context) {
        if (slot != null) {
            this.targets.add(new Action(slot, context));
        }
    }

    public void markEndOfBlueprint(BptBuilderBase builder) {
        this.targets.add(new Action(builder));
    }

    public boolean readyToBuild() {
        return this.targets.size() < MAX_TARGETS;
    }

    public boolean done() {
        return this.targets.isEmpty();
    }

    public void setBox(Box box) {
        this.box = box;
        this.setDestination((int)box.centerX(), (int)box.centerY(), (int)box.centerZ());
    }

    public void A() {
        if (this.laser != null) {
            this.laser.A();
        }
        super.A();
    }

    private class Action {
        BptSlot slot;
        BptBuilderBase builder;
        BptContext context;

        public Action(BptSlot slot, BptContext context) {
            this.slot = slot;
            this.context = context;
        }

        public Action(BptBuilderBase builder) {
            this.builder = builder;
        }
    }
}

