/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.Position;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;

public class EntityEnergyLaser
extends EntityLaser {
    public int displayStage = 0;
    private final float[] power = new float[100];
    private int powerIndex = 0;
    public float powerAverage = 0.0f;

    public EntityEnergyLaser(xd world) {
        super(world);
    }

    public EntityEnergyLaser(xd world, Position head, Position tail) {
        super(world, head, tail);
        for (int j = 0; j < this.power.length; ++j) {
            this.power[j] = 0.0f;
        }
    }

    public void pushPower(float p) {
        this.powerAverage -= this.power[this.powerIndex];
        this.powerAverage += p;
        this.power[this.powerIndex] = p;
        ++this.powerIndex;
        if (this.powerIndex == this.power.length) {
            this.powerIndex = 0;
        }
    }

    public float getPowerAverage() {
        return this.powerAverage / (float)this.power.length;
    }

    @Override
    public String v_() {
        if ((double)this.getPowerAverage() <= 1.0) {
            return DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png";
        }
        if ((double)this.getPowerAverage() <= 2.0) {
            return DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_2.png";
        }
        if ((double)this.getPowerAverage() <= 3.0) {
            return DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_3.png";
        }
        return DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_4.png";
    }
}

