/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.Position;
import buildcraft.builders.TileMarker;
import buildcraft.core.BlockIndex;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import java.util.LinkedList;
import java.util.TreeSet;

public class TilePathMarker
extends TileMarker {
    public EntityLaser[] lasers = new EntityLaser[2];
    public int x0;
    public int y0;
    public int z0;
    public int x1;
    public int y1;
    public int z1;
    public boolean loadLink0 = false;
    public boolean loadLink1 = false;
    public boolean tryingToConnect = false;
    public TilePathMarker[] links = new TilePathMarker[2];
    public static int searchSize = 64;
    private static LinkedList availableMarkers = new LinkedList();

    public TilePathMarker() {
        availableMarkers.add(this);
    }

    public boolean isFullyConnected() {
        return this.lasers[0] != null && this.lasers[1] != null;
    }

    public boolean isLinkedTo(TilePathMarker pathMarker) {
        return this.links[0] == pathMarker || this.links[1] == pathMarker;
    }

    public void connect(TilePathMarker marker, EntityLaser laser) {
        if (this.lasers[0] == null) {
            this.lasers[0] = laser;
            this.links[0] = marker;
        } else if (this.lasers[1] == null) {
            this.lasers[1] = laser;
            this.links[1] = marker;
        }
        if (this.isFullyConnected()) {
            availableMarkers.remove(this);
        }
    }

    public void createLaserAndConnect(TilePathMarker pathMarker) {
        if (CoreProxy.isClient(this.i)) {
            return;
        }
        EntityLaser laser = new EntityLaser(this.i, new Position((double)this.j + 0.5, (double)this.k + 0.5, (double)this.l + 0.5), new Position((double)pathMarker.j + 0.5, (double)pathMarker.k + 0.5, (double)pathMarker.l + 0.5));
        laser.show();
        laser.setTexture(DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png");
        this.i.a((nn)laser);
        this.connect(pathMarker, laser);
        pathMarker.connect(this, laser);
    }

    private TilePathMarker findNearestAvailablePathMarker() {
        TilePathMarker nearestAvailable = null;
        double nearestDistance = 0.0;
        for (TilePathMarker t : availableMarkers) {
            double distance;
            if (t == this || t == this.links[0] || t == this.links[1] || (distance = Math.sqrt(Math.pow(this.j - t.j, 2.0) + Math.pow(this.k - t.k, 2.0) + Math.pow(this.l - t.l, 2.0))) > (double)searchSize || nearestAvailable != null && !(distance < nearestDistance)) continue;
            nearestAvailable = t;
            nearestDistance = distance;
        }
        return nearestAvailable;
    }

    @Override
    public void tryConnection() {
        if (this.isFullyConnected()) {
            return;
        }
        this.tryingToConnect = !this.tryingToConnect;
        this.i.k(this.j, this.k, this.l);
    }

    @Override
    public void n_() {
        TilePathMarker nearestPathMarker;
        super.n_();
        if (this.tryingToConnect && (nearestPathMarker = this.findNearestAvailablePathMarker()) != null) {
            this.createLaserAndConnect(nearestPathMarker);
            this.tryingToConnect = false;
            this.i.k(this.j, this.k, this.l);
        }
    }

    public LinkedList getPath() {
        TreeSet<BlockIndex> visitedPaths = new TreeSet<BlockIndex>();
        LinkedList<BlockIndex> res = new LinkedList<BlockIndex>();
        TilePathMarker nextTile = this;
        while (nextTile != null) {
            BlockIndex b = new BlockIndex(nextTile.j, nextTile.k, nextTile.l);
            visitedPaths.add(b);
            res.add(b);
            if (nextTile.links[0] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[0].j, nextTile.links[0].k, nextTile.links[0].l))) {
                nextTile = nextTile.links[0];
                continue;
            }
            if (nextTile.links[1] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[1].j, nextTile.links[1].k, nextTile.links[1].l))) {
                nextTile = nextTile.links[1];
                continue;
            }
            nextTile = null;
        }
        return res;
    }

    @Override
    public void h() {
        super.h();
        if (this.lasers[0] != null) {
            this.links[0].unlink(this);
            this.lasers[0].A();
        }
        if (this.lasers[1] != null) {
            this.links[1].unlink(this);
            this.lasers[1].A();
        }
        this.lasers = new EntityLaser[2];
        this.links = new TilePathMarker[2];
        availableMarkers.remove(this);
        this.tryingToConnect = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.loadLink0) {
            kw e0 = this.i.b(this.x0, this.y0, this.z0);
            if (this.links[0] != e0 && this.links[1] != e0 && e0 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e0);
            }
            this.loadLink0 = false;
        }
        if (this.loadLink1) {
            kw e1 = this.i.b(this.x1, this.y1, this.z1);
            if (this.links[0] != e1 && this.links[1] != e1 && e1 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e1);
            }
            this.loadLink1 = false;
        }
    }

    private void unlink(TilePathMarker tile) {
        if (this.links[0] == tile) {
            this.lasers[0] = null;
            this.links[0] = null;
        }
        if (this.links[1] == tile) {
            this.lasers[1] = null;
            this.links[1] = null;
        }
        if (!this.isFullyConnected() && !availableMarkers.contains(this)) {
            availableMarkers.add(this);
        }
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.c("x0")) {
            this.x0 = nbttagcompound.f("x0");
            this.y0 = nbttagcompound.f("y0");
            this.z0 = nbttagcompound.f("z0");
            this.loadLink0 = true;
        }
        if (nbttagcompound.c("x1")) {
            this.x1 = nbttagcompound.f("x1");
            this.y1 = nbttagcompound.f("y1");
            this.z1 = nbttagcompound.f("z1");
            this.loadLink1 = true;
        }
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        if (this.links[0] != null) {
            nbttagcompound.a("x0", this.links[0].j);
            nbttagcompound.a("y0", this.links[0].k);
            nbttagcompound.a("z0", this.links[0].l);
        }
        if (this.links[1] != null) {
            nbttagcompound.a("x1", this.links[1].j);
            nbttagcompound.a("y1", this.links[1].k);
            nbttagcompound.a("z1", this.links[1].l);
        }
    }

    public void onChunkUnload() {
        availableMarkers.remove(this);
    }

    public static void clearAvailableMarkersList() {
        availableMarkers.clear();
    }
}

