/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.core.CoreProxy;
import buildcraft.core.EntityBlock;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.Utils;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;

public class TileMarker
extends TileBuildCraft
implements IAreaProvider {
    private static int maxSize = 64;
    @TileNetworkData
    public Origin origin = new Origin();
    private EntityBlock[] lasers;
    private EntityBlock[] signals;
    private Position initVectO;
    private Position[] initVect;

    public void switchSignals() {
        if (this.signals != null) {
            for (EntityBlock b : this.signals) {
                if (b == null) continue;
                CoreProxy.removeEntity(b);
            }
            this.signals = null;
        }
        if (this.i.x(this.j, this.k, this.l)) {
            this.signals = new EntityBlock[6];
            if (!this.origin.isSet() || !this.origin.vect[0].isSet()) {
                this.signals[0] = Utils.createLaser(this.i, new Position(this.j, this.k, this.l), new Position(this.j + maxSize - 1, this.k, this.l), LaserKind.Blue);
                this.signals[1] = Utils.createLaser(this.i, new Position(this.j - maxSize + 1, this.k, this.l), new Position(this.j, this.k, this.l), LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[1].isSet()) {
                this.signals[2] = Utils.createLaser(this.i, new Position(this.j, this.k, this.l), new Position(this.j, this.k + maxSize - 1, this.l), LaserKind.Blue);
                this.signals[3] = Utils.createLaser(this.i, new Position(this.j, this.k - maxSize + 1, this.l), new Position(this.j, this.k, this.l), LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[2].isSet()) {
                this.signals[4] = Utils.createLaser(this.i, new Position(this.j, this.k, this.l), new Position(this.j, this.k, this.l + maxSize - 1), LaserKind.Blue);
                this.signals[5] = Utils.createLaser(this.i, new Position(this.j, this.k, this.l - maxSize + 1), new Position(this.j, this.k, this.l), LaserKind.Blue);
            }
        }
        if (CoreProxy.isServerSide()) {
            this.sendNetworkUpdate();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.switchSignals();
        if (this.initVectO != null) {
            this.origin = new Origin();
            this.origin.vectO = new TileWrapper((int)this.initVectO.x, (int)this.initVectO.y, (int)this.initVectO.z);
            for (int i = 0; i < 3; ++i) {
                if (this.initVect[i] == null) continue;
                this.linkTo((TileMarker)this.i.b((int)this.initVect[i].x, (int)this.initVect[i].y, (int)this.initVect[i].z), i);
            }
        }
    }

    public void tryConnection() {
        if (CoreProxy.isClient(this.i)) {
            return;
        }
        for (int j = 0; j < 3; ++j) {
            if (this.origin.isSet() && this.origin.vect[j].isSet()) continue;
            this.setVect(j);
        }
        this.sendNetworkUpdate();
    }

    void setVect(int n) {
        int markerId = BuildCraftBuilders.markerBlock.bO;
        int[] coords = new int[]{this.j, this.k, this.l};
        if (!this.origin.isSet() || !this.origin.vect[n].isSet()) {
            for (int j = 1; j < maxSize; ++j) {
                TileMarker marker;
                int n2 = n;
                coords[n2] = coords[n2] + j;
                int blockId = this.i.a(coords[0], coords[1], coords[2]);
                if (blockId == markerId && this.linkTo(marker = (TileMarker)this.i.b(coords[0], coords[1], coords[2]), n)) break;
                int n3 = n;
                coords[n3] = coords[n3] - j;
                int n4 = n;
                coords[n4] = coords[n4] - j;
                blockId = this.i.a(coords[0], coords[1], coords[2]);
                if (blockId == markerId && this.linkTo(marker = (TileMarker)this.i.b(coords[0], coords[1], coords[2]), n)) break;
                int n5 = n;
                coords[n5] = coords[n5] + j;
            }
        }
    }

    private boolean linkTo(TileMarker marker, int n) {
        if (marker == null) {
            return false;
        }
        if (this.origin.isSet() && marker.origin.isSet()) {
            return false;
        }
        if (!this.origin.isSet() && !marker.origin.isSet()) {
            marker.origin = this.origin = new Origin();
            this.origin.vectO = new TileWrapper(this.j, this.k, this.l);
            this.origin.vect[n] = new TileWrapper(marker.j, marker.k, marker.l);
        } else if (!this.origin.isSet()) {
            this.origin = marker.origin;
            this.origin.vect[n] = new TileWrapper(this.j, this.k, this.l);
        } else {
            marker.origin = this.origin;
            this.origin.vect[n] = new TileWrapper(marker.j, marker.k, marker.l);
        }
        this.origin.vectO.getMarker(this.i).createLasers();
        this.switchSignals();
        marker.switchSignals();
        return true;
    }

    private void createLasers() {
        if (this.lasers != null) {
            for (EntityBlock entity : this.lasers) {
                if (entity == null) continue;
                CoreProxy.removeEntity(entity);
            }
        }
        this.lasers = new EntityBlock[12];
        Origin o = this.origin;
        if (!this.origin.vect[0].isSet()) {
            o.xMin = this.origin.vectO.x;
            o.xMax = this.origin.vectO.x;
        } else if (this.origin.vect[0].x < this.j) {
            o.xMin = this.origin.vect[0].x;
            o.xMax = this.j;
        } else {
            o.xMin = this.j;
            o.xMax = this.origin.vect[0].x;
        }
        if (!this.origin.vect[1].isSet()) {
            o.yMin = this.origin.vectO.y;
            o.yMax = this.origin.vectO.y;
        } else if (this.origin.vect[1].y < this.k) {
            o.yMin = this.origin.vect[1].y;
            o.yMax = this.k;
        } else {
            o.yMin = this.k;
            o.yMax = this.origin.vect[1].y;
        }
        if (!this.origin.vect[2].isSet()) {
            o.zMin = this.origin.vectO.z;
            o.zMax = this.origin.vectO.z;
        } else if (this.origin.vect[2].z < this.l) {
            o.zMin = this.origin.vect[2].z;
            o.zMax = this.l;
        } else {
            o.zMin = this.l;
            o.zMax = this.origin.vect[2].z;
        }
        this.lasers = Utils.createLaserBox(this.i, o.xMin, o.yMin, o.zMin, o.xMax, o.yMax, o.zMax, LaserKind.Red);
    }

    @Override
    public int xMin() {
        if (this.origin.isSet()) {
            return this.origin.xMin;
        }
        return this.j;
    }

    @Override
    public int yMin() {
        if (this.origin.isSet()) {
            return this.origin.yMin;
        }
        return this.k;
    }

    @Override
    public int zMin() {
        if (this.origin.isSet()) {
            return this.origin.zMin;
        }
        return this.l;
    }

    @Override
    public int xMax() {
        if (this.origin.isSet()) {
            return this.origin.xMax;
        }
        return this.j;
    }

    @Override
    public int yMax() {
        if (this.origin.isSet()) {
            return this.origin.yMax;
        }
        return this.k;
    }

    @Override
    public int zMax() {
        if (this.origin.isSet()) {
            return this.origin.zMax;
        }
        return this.l;
    }

    @Override
    public void h() {
        super.h();
        this.destroy();
    }

    @Override
    public void destroy() {
        TileMarker markerOrigin = null;
        if (this.origin.isSet()) {
            TileMarker mark;
            markerOrigin = this.origin.vectO.getMarker(this.i);
            Origin o = this.origin;
            if (markerOrigin != null && markerOrigin.lasers != null) {
                for (EntityBlock entityBlock : markerOrigin.lasers) {
                    if (entityBlock == null) continue;
                    entityBlock.A();
                }
            }
            for (TileWrapper tileWrapper : o.vect) {
                mark = tileWrapper.getMarker(this.i);
                if (mark == null) continue;
                mark.lasers = null;
                if (mark == this) continue;
                mark.origin = new Origin();
            }
            markerOrigin.lasers = null;
            if (markerOrigin != this) {
                markerOrigin.origin = new Origin();
            }
            for (TileWrapper tileWrapper : o.vect) {
                mark = tileWrapper.getMarker(this.i);
                if (mark == null) continue;
                mark.switchSignals();
            }
            markerOrigin.switchSignals();
        }
        if (this.signals != null) {
            for (EntityBlock block : this.signals) {
                if (block == null) continue;
                block.A();
            }
        }
        this.signals = null;
        if (CoreProxy.isServerSide() && markerOrigin != null && markerOrigin != this) {
            markerOrigin.sendNetworkUpdate();
        }
    }

    @Override
    public void removeFromWorld() {
        if (!this.origin.isSet()) {
            return;
        }
        Origin o = this.origin;
        for (TileWrapper m : (TileWrapper[])o.vect.clone()) {
            if (!m.isSet()) continue;
            this.i.g(m.x, m.y, m.z, 0);
            BuildCraftBuilders.markerBlock.a(this.i, m.x, m.y, m.z, BuildCraftBuilders.markerBlock.bO, 0);
        }
        this.i.g(o.vectO.x, o.vectO.y, o.vectO.z, 0);
        BuildCraftBuilders.markerBlock.a(this.i, o.vectO.x, o.vectO.y, o.vectO.z, BuildCraftBuilders.markerBlock.bO, 0);
    }

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.c("vectO")) {
            this.initVectO = new Position(nbttagcompound.m("vectO"));
            this.initVect = new Position[3];
            for (int i = 0; i < 3; ++i) {
                if (!nbttagcompound.c("vect" + i)) continue;
                this.initVect[i] = new Position(nbttagcompound.m("vect" + i));
            }
        }
    }

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        if (this.origin.isSet() && this.origin.vectO.getMarker(this.i) == this) {
            ady vectO = new ady();
            new Position(this.origin.vectO.getMarker(this.i)).writeToNBT(vectO);
            nbttagcompound.a("vectO", (gh)vectO);
            for (int i = 0; i < 3; ++i) {
                if (!this.origin.vect[i].isSet()) continue;
                ady vect = new ady();
                new Position(this.origin.vect[i].x, this.origin.vect[i].y, this.origin.vect[i].z).writeToNBT(vect);
                nbttagcompound.a("vect" + i, (gh)vect);
            }
        }
    }

    @Override
    public abs getDescriptionPacket() {
        if (this.origin.vectO.getMarker(this.i) == this) {
            return super.getDescriptionPacket();
        }
        return null;
    }

    @Override
    public abs getUpdatePacket() {
        TileMarker marker = this.origin.vectO.getMarker(this.i);
        if (marker == this || marker == null) {
            return super.getUpdatePacket();
        }
        if (marker != null) {
            marker.sendNetworkUpdate();
        }
        return null;
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
        super.postPacketHandling(packet);
        if (this.origin.vectO.isSet()) {
            this.origin.vectO.getMarker(this.i).switchSignals();
            for (TileWrapper w : this.origin.vect) {
                TileMarker m = w.getMarker(this.i);
                if (m == null) continue;
                m.switchSignals();
            }
        }
        this.createLasers();
    }

    public static class Origin {
        @TileNetworkData
        public TileWrapper vectO = new TileWrapper();
        @TileNetworkData(staticSize=3)
        public TileWrapper[] vect = new TileWrapper[]{new TileWrapper(), new TileWrapper(), new TileWrapper()};
        @TileNetworkData
        public int xMin;
        @TileNetworkData
        public int yMin;
        @TileNetworkData
        public int zMin;
        @TileNetworkData
        public int xMax;
        @TileNetworkData
        public int yMax;
        @TileNetworkData
        public int zMax;

        public boolean isSet() {
            return this.vectO.isSet();
        }
    }

    public static class TileWrapper {
        @TileNetworkData
        public int x;
        @TileNetworkData
        public int y;
        @TileNetworkData
        public int z;
        private TileMarker marker;

        public TileWrapper() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }

        public TileWrapper(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean isSet() {
            return this.x != Integer.MAX_VALUE;
        }

        public TileMarker getMarker(xd world) {
            if (!this.isSet()) {
                return null;
            }
            if (this.marker == null) {
                this.marker = (TileMarker)world.b(this.x, this.y, this.z);
            }
            return this.marker;
        }

        public void reset() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }
    }
}

