/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Orientations;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.builders.TileMarker;
import buildcraft.core.ActionMachineControl;
import buildcraft.core.Box;
import buildcraft.core.CoreProxy;
import buildcraft.core.IMachine;
import buildcraft.core.StackUtil;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.Utils;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;

public class TileFiller
extends TileBuildCraft
implements ISpecialInventory,
IPowerReceptor,
IMachine,
IActionReceptor {
    @TileNetworkData
    public Box box = new Box();
    @TileNetworkData
    public int currentPatternId = 0;
    @TileNetworkData
    public boolean done = true;
    IFillerPattern currentPattern;
    boolean forceDone = false;
    private aan[] contents;
    IPowerProvider powerProvider;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;

    public TileFiller() {
        this.contents = new aan[this.a()];
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(10, 25, 100, 25, 100);
        this.powerProvider.configurePowerPerdition(25, 40);
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!CoreProxy.isClient(this.i) && (a = Utils.getNearbyAreaProvider(this.i, this.j, this.k, this.l)) != null) {
            this.box.initialize(a);
            if (a instanceof TileMarker) {
                ((TileMarker)a).removeFromWorld();
            }
            if (!CoreProxy.isClient(this.i) && this.box.isInitialized()) {
                this.box.createLasers(this.i, LaserKind.Stripes);
            }
            this.sendNetworkUpdate();
        }
        this.computeRecipe();
    }

    @Override
    public void n_() {
        super.n_();
        if (this.done) {
            if (this.lastMode == ActionMachineControl.Mode.Loop) {
                this.done = false;
            } else {
                return;
            }
        }
        if (this.powerProvider.getEnergyStored() > 25.0f) {
            this.doWork();
        }
    }

    @Override
    public void doWork() {
        if (CoreProxy.isClient(this.i)) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            return;
        }
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        if (this.box.isInitialized() && this.currentPattern != null && !this.done) {
            aan stack = null;
            int stackId = 0;
            for (int s = 9; s < this.a(); ++s) {
                if (this.k_(s) == null || this.k_((int)s).a <= 0) continue;
                stack = this.contents[s];
                stackId = s;
                break;
            }
            this.done = this.currentPattern.iteratePattern(this, this.box, stack);
            if (stack != null && stack.a == 0) {
                this.contents[stackId] = null;
            }
            if (this.done) {
                this.i.l(this.j, this.k, this.l);
                this.sendNetworkUpdate();
            }
        }
        if (this.powerProvider.getEnergyStored() > 25.0f) {
            this.doWork();
        }
    }

    public int a() {
        return 36;
    }

    public aan k_(int i) {
        return this.contents[i];
    }

    public void computeRecipe() {
        if (CoreProxy.isClient(this.i)) {
            return;
        }
        IFillerPattern newPattern = FillerManager.registry.findMatchingRecipe(this);
        if (newPattern == this.currentPattern) {
            return;
        }
        this.currentPattern = newPattern;
        if (this.currentPattern == null || this.forceDone) {
            this.done = this.lastMode != ActionMachineControl.Mode.Loop;
            this.forceDone = false;
        } else {
            this.done = false;
        }
        if (this.i != null) {
            this.i.l(this.j, this.k, this.l);
        }
        this.currentPatternId = this.currentPattern == null ? 0 : this.currentPattern.getId();
        if (CoreProxy.isServerSide()) {
            this.sendNetworkUpdate();
        }
    }

    public aan a(int i, int j) {
        if (this.contents[i] != null) {
            if (this.contents[i].a <= j) {
                aan itemstack = this.contents[i];
                this.contents[i] = null;
                this.computeRecipe();
                return itemstack;
            }
            aan itemstack1 = this.contents[i].a(j);
            if (this.contents[i].a == 0) {
                this.contents[i] = null;
            }
            this.computeRecipe();
            return itemstack1;
        }
        return null;
    }

    public void a(int i, aan itemstack) {
        this.contents[i] = itemstack;
        if (itemstack != null && itemstack.a > this.d()) {
            itemstack.a = this.d();
        }
        this.computeRecipe();
    }

    public aan b(int slot) {
        if (this.contents[slot] == null) {
            return null;
        }
        aan toReturn = this.contents[slot];
        this.contents[slot] = null;
        return toReturn;
    }

    public String c() {
        return "Filler";
    }

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "Items", this.contents);
        if (nbttagcompound.c("box")) {
            this.box.initialize(nbttagcompound.m("box"));
        }
        this.done = nbttagcompound.o("done");
        this.lastMode = ActionMachineControl.Mode.values()[nbttagcompound.d("lastMode")];
        this.forceDone = this.done;
    }

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "Items", this.contents);
        if (this.box != null) {
            ady boxStore = new ady();
            this.box.writeToNBT(boxStore);
            nbttagcompound.a("box", (gh)boxStore);
        }
        nbttagcompound.a("done", this.done);
        nbttagcompound.a("lastMode", (byte)this.lastMode.ordinal());
    }

    public int d() {
        return 64;
    }

    public boolean a_(yw entityplayer) {
        if (this.i.b(this.j, this.k, this.l) != this) {
            return false;
        }
        return entityplayer.f((double)this.j + 0.5, (double)this.k + 0.5, (double)this.l + 0.5) <= 64.0;
    }

    @Override
    public void h() {
        super.h();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box != null) {
            this.box.deleteLasers();
        }
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.i.l(this.j, this.k, this.l);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.i, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.i.l(this.j, this.k, this.l);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.i, LaserKind.Stripes);
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean isActive() {
        return !this.done && this.lastMode != ActionMachineControl.Mode.Off;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void e() {
    }

    public void f() {
    }

    @Override
    public int powerRequest() {
        if (this.isActive()) {
            return this.powerProvider.getMaxEnergyReceived();
        }
        return 0;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        } else if (action == BuildCraftCore.actionLoop) {
            this.lastMode = ActionMachineControl.Mode.Loop;
        }
    }

    @Override
    public boolean allowActions() {
        return true;
    }

    @Override
    public int addItem(aan stack, boolean doAdd, Orientations from) {
        int i;
        StackUtil stackUtil = new StackUtil(stack);
        boolean added = false;
        for (i = 9; i < this.contents.length; ++i) {
            if (!stackUtil.tryAdding(this, i, doAdd, false)) continue;
            added = true;
            break;
        }
        if (added) {
            if (!doAdd) {
                return stackUtil.itemsAdded;
            }
            if (stack.a - stackUtil.itemsAdded <= 0) {
                return stackUtil.itemsAdded;
            }
            this.addItem(stack, added, from);
            return stackUtil.itemsAdded;
        }
        if (!added) {
            for (i = 9; i < this.contents.length; ++i) {
                if (!stackUtil.tryAdding(this, i, doAdd, true)) continue;
                added = true;
                break;
            }
        }
        if (added) {
            if (!doAdd) {
                return stackUtil.itemsAdded;
            }
            if (stack.a - stackUtil.itemsAdded <= 0) {
                return stackUtil.itemsAdded;
            }
            this.addItem(stack, added, from);
            return stackUtil.itemsAdded;
        }
        return 0;
    }

    @Override
    public aan[] extractItem(boolean doRemove, Orientations from, int maxItemCount) {
        for (int i = 9; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            if (doRemove) {
                return new aan[]{this.a(i, 1)};
            }
            return new aan[]{this.contents[i]};
        }
        return null;
    }
}

