/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.builders.ItemBptBase;
import buildcraft.builders.ItemBptBluePrint;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.BlockIndex;
import buildcraft.core.Box;
import buildcraft.core.BptBase;
import buildcraft.core.BptBlueprint;
import buildcraft.core.BptBuilderBase;
import buildcraft.core.BptBuilderBlueprint;
import buildcraft.core.BptBuilderTemplate;
import buildcraft.core.BptContext;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import buildcraft.core.EntityRobot;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.IMachine;
import buildcraft.core.SurroundingInventory;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.Utils;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class TileBuilder
extends TileBuildCraft
implements IBuilderInventory,
IPowerReceptor,
IMachine {
    private final aan[] items = new aan[28];
    private BptBuilderBase bluePrintBuilder;
    @TileNetworkData
    public Box box = new Box();
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private LinkedList path;
    private LinkedList pathLasers;
    private EntityRobot builderRobot;
    public PathIterator currentPathIterator;
    private boolean done = true;

    public TileBuilder() {
        this.powerProvider.configure(10, 25, 25, 25, 25);
    }

    @Override
    public void initialize() {
        super.initialize();
        for (int x = this.j - 1; x <= this.j + 1; ++x) {
            block1: for (int y = this.k - 1; y <= this.k + 1; ++y) {
                for (int z = this.l - 1; z <= this.l + 1; ++z) {
                    kw tile = this.i.b(x, y, z);
                    if (!(tile instanceof TilePathMarker)) continue;
                    this.path = ((TilePathMarker)tile).getPath();
                    for (BlockIndex b : this.path) {
                        this.i.g(b.i, b.j, b.k, 0);
                        BuildCraftBuilders.pathMarkerBlock.a(this.i, b.i, b.j, b.k, BuildCraftBuilders.pathMarkerBlock.bO, 0);
                    }
                    continue block1;
                }
            }
        }
        if (this.path != null && this.pathLasers == null) {
            ((BlockIndex)this.path.getFirst()).i = this.j;
            ((BlockIndex)this.path.getFirst()).j = this.k;
            ((BlockIndex)this.path.getFirst()).k = this.l;
            this.createLasersForPath();
        }
        this.iterateBpt();
    }

    public void createLasersForPath() {
        this.pathLasers = new LinkedList();
        BlockIndex previous = null;
        for (BlockIndex b : this.path) {
            if (previous != null) {
                EntityLaser laser = new EntityLaser(this.i, new Position((double)previous.i + 0.5, (double)previous.j + 0.5, (double)previous.k + 0.5), new Position((double)b.i + 0.5, (double)b.j + 0.5, (double)b.k + 0.5));
                laser.setTexture(DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png");
                this.i.a((nn)laser);
                this.pathLasers.add(laser);
            }
            previous = b;
        }
    }

    public BptBuilderBase instanciateBluePrint(int x, int y, int z, Orientations o) {
        BptBase bpt = BuildCraftBuilders.getBptRootIndex().getBluePrint(this.items[0].i());
        if (bpt == null) {
            return null;
        }
        bpt = bpt.clone();
        BptContext context = new BptContext(this.i, null, bpt.getBoxForPos(x, y, z));
        if (o != Orientations.XPos) {
            if (o == Orientations.ZPos) {
                bpt.rotateLeft(context);
            } else if (o == Orientations.XNeg) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            } else if (o == Orientations.ZNeg) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            }
        }
        if (this.items[0].a() instanceof ItemBptTemplate) {
            return new BptBuilderTemplate(bpt, this.i, x, y, z);
        }
        if (this.items[0].a() instanceof ItemBptBluePrint) {
            return new BptBuilderBlueprint((BptBlueprint)bpt, this.i, x, y, z);
        }
        return null;
    }

    @Override
    public void doWork() {
        if (CoreProxy.isClient(this.i)) {
            return;
        }
        if (this.done) {
            return;
        }
        if (this.builderRobot != null && !this.builderRobot.readyToBuild()) {
            return;
        }
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        this.iterateBpt();
        if (this.bluePrintBuilder != null && !this.bluePrintBuilder.done) {
            if (!this.box.isInitialized()) {
                this.box.initialize(this.bluePrintBuilder);
            }
            if (this.builderRobot == null) {
                this.builderRobot = new EntityRobot(this.i, this.box);
                this.i.a((nn)this.builderRobot);
            }
            this.box.createLasers(this.i, LaserKind.Stripes);
            this.builderRobot.scheduleContruction(this.bluePrintBuilder.getNextBlock(this.i, new SurroundingInventory(this.i, this.j, this.k, this.l)), this.bluePrintBuilder.getContext());
        }
    }

    public void iterateBpt() {
        if (this.items[0] == null || !(this.items[0].a() instanceof ItemBptBase)) {
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder = null;
            }
            if (this.builderRobot != null) {
                this.builderRobot.A();
                this.builderRobot = null;
            }
            if (this.box.isInitialized()) {
                this.box.deleteLasers();
                this.box.reset();
            }
            if (this.currentPathIterator != null) {
                this.currentPathIterator = null;
            }
            return;
        }
        if (this.bluePrintBuilder == null || this.bluePrintBuilder.done) {
            if (this.path != null) {
                if (this.currentPathIterator == null) {
                    Iterator it = this.path.iterator();
                    BlockIndex start = (BlockIndex)it.next();
                    this.currentPathIterator = new PathIterator(start, it);
                }
                if (this.bluePrintBuilder != null && this.builderRobot != null) {
                    this.builderRobot.markEndOfBlueprint(this.bluePrintBuilder);
                }
                this.bluePrintBuilder = this.currentPathIterator.next();
                if (this.bluePrintBuilder != null) {
                    this.box.deleteLasers();
                    this.box.reset();
                    this.box.initialize(this.bluePrintBuilder);
                    this.box.createLasers(this.i, LaserKind.Stripes);
                }
                if (this.builderRobot != null) {
                    this.builderRobot.setBox(this.box);
                }
                if (this.bluePrintBuilder == null) {
                    this.currentPathIterator = this.currentPathIterator.iterate();
                }
                if (this.currentPathIterator == null) {
                    this.done = true;
                }
            } else if (this.bluePrintBuilder != null && this.bluePrintBuilder.done) {
                if (this.builderRobot != null) {
                    this.builderRobot.markEndOfBlueprint(this.bluePrintBuilder);
                }
                this.done = true;
                this.bluePrintBuilder = null;
            } else {
                this.bluePrintBuilder = this.instanciateBluePrint(this.j, this.k, this.l, Orientations.values()[this.i.e(this.j, this.k, this.l)].reverse());
                if (this.bluePrintBuilder != null) {
                    this.box.initialize(this.bluePrintBuilder);
                    this.box.createLasers(this.i, LaserKind.Stripes);
                }
            }
        }
    }

    public int a() {
        return this.items.length;
    }

    public aan k_(int i) {
        return this.items[i];
    }

    public aan a(int i, int j) {
        aan result;
        if (this.items[i] == null) {
            result = null;
        } else if (this.items[i].a > j) {
            result = this.items[i].a(j);
        } else {
            aan tmp = this.items[i];
            this.items[i] = null;
            result = tmp;
        }
        if (i == 0) {
            this.iterateBpt();
        }
        return result;
    }

    public void a(int i, aan itemstack) {
        this.items[i] = itemstack;
        if (i == 0) {
            this.iterateBpt();
            this.done = false;
        }
    }

    public aan b(int slot) {
        if (this.items[slot] == null) {
            return null;
        }
        aan toReturn = this.items[slot];
        this.items[slot] = null;
        return toReturn;
    }

    public String c() {
        return "Builder";
    }

    public int d() {
        return 64;
    }

    public boolean a_(yw entityplayer) {
        return this.i.b(this.j, this.k, this.l) == this;
    }

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "Items", this.items);
        if (nbttagcompound.c("box")) {
            this.box.initialize(nbttagcompound.m("box"));
        }
        if (nbttagcompound.c("path")) {
            this.path = new LinkedList();
            no list = nbttagcompound.n("path");
            for (int i = 0; i < list.d(); ++i) {
                this.path.add(new BlockIndex((ady)list.a(i)));
            }
        }
        this.done = nbttagcompound.o("done");
    }

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "Items", this.items);
        if (this.box.isInitialized()) {
            ady boxStore = new ady();
            this.box.writeToNBT(boxStore);
            nbttagcompound.a("box", (gh)boxStore);
        }
        if (this.path != null) {
            no list = new no();
            for (BlockIndex i : this.path) {
                ady c = new ady();
                i.writeTo(c);
                list.a((gh)c);
            }
            nbttagcompound.a("path", (gh)list);
        }
        nbttagcompound.a("done", this.done);
    }

    @Override
    public void h() {
        super.h();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box.isInitialized()) {
            this.box.deleteLasers();
        }
        if (this.builderRobot != null) {
            this.builderRobot.A();
            this.builderRobot = null;
        }
        this.cleanPathLasers();
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.i, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.i, LaserKind.Stripes);
        }
    }

    public void e() {
    }

    public void f() {
    }

    @Override
    public int powerRequest() {
        if (!(this.bluePrintBuilder == null && this.currentPathIterator == null || this.done)) {
            return this.powerProvider.getMaxEnergyReceived();
        }
        return 0;
    }

    @Override
    public void n_() {
        super.n_();
        if ((this.bluePrintBuilder == null || this.bluePrintBuilder.done) && this.box.isInitialized() && (this.builderRobot == null || this.builderRobot.done())) {
            this.box.deleteLasers();
            this.box.reset();
            if (CoreProxy.isServerSide()) {
                this.sendNetworkUpdate();
            }
            return;
        }
        if (!this.box.isInitialized() && this.bluePrintBuilder == null && this.builderRobot != null) {
            this.builderRobot.A();
            this.builderRobot = null;
        }
    }

    @Override
    public boolean isActive() {
        return !this.done;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void cleanPathLasers() {
        if (this.pathLasers != null) {
            for (EntityLaser laser : this.pathLasers) {
                laser.A();
            }
            this.pathLasers = null;
        }
    }

    public boolean isBuildingBlueprint() {
        return this.k_(0) != null && this.k_(0).a() instanceof ItemBptBluePrint;
    }

    public Collection getNeededItems() {
        if (this.bluePrintBuilder instanceof BptBuilderBlueprint) {
            return ((BptBuilderBlueprint)this.bluePrintBuilder).neededItems;
        }
        return null;
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return i != 0;
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    private class PathIterator {
        public Iterator currentIterator;
        public double cx;
        public double cy;
        public double cz;
        public float ix;
        public float iy;
        public float iz;
        public BlockIndex to;
        public double lastDistance;
        wu oldBoundingBox = null;
        Orientations o = null;

        public PathIterator(BlockIndex from, Iterator it) {
            this.to = (BlockIndex)it.next();
            this.currentIterator = it;
            double dx = this.to.i - from.i;
            double dy = this.to.j - from.j;
            double dz = this.to.k - from.k;
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.cx = dx / size / 10.0;
            this.cy = dy / size / 10.0;
            this.cz = dz / size / 10.0;
            this.ix = from.i;
            this.iy = from.j;
            this.iz = from.k;
            this.lastDistance = (this.ix - (float)this.to.i) * (this.ix - (float)this.to.i) + (this.iy - (float)this.to.j) * (this.iy - (float)this.to.j) + (this.iz - (float)this.to.k) * (this.iz - (float)this.to.k);
            this.o = Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? Orientations.XPos : Orientations.XNeg) : (dz > 0.0 ? Orientations.ZPos : Orientations.ZNeg);
        }

        public BptBuilderBase next() {
            int newZ;
            int newY;
            int newX;
            BptBuilderBase bpt;
            while ((bpt = TileBuilder.this.instanciateBluePrint(newX = Math.round(this.ix), newY = Math.round(this.iy), newZ = Math.round(this.iz), this.o)) != null) {
                wu boundingBox = bpt.getBoundingBox();
                if (this.oldBoundingBox == null || !this.collision(this.oldBoundingBox, boundingBox)) {
                    this.oldBoundingBox = boundingBox;
                    if (bpt != null) {
                        return bpt;
                    }
                }
                this.ix = (float)((double)this.ix + this.cx);
                this.iy = (float)((double)this.iy + this.cy);
                this.iz = (float)((double)this.iz + this.cz);
                double distance = (this.ix - (float)this.to.i) * (this.ix - (float)this.to.i) + (this.iy - (float)this.to.j) * (this.iy - (float)this.to.j) + (this.iz - (float)this.to.k) * (this.iz - (float)this.to.k);
                if (distance > this.lastDistance) {
                    return null;
                }
                this.lastDistance = distance;
            }
            return null;
        }

        public PathIterator iterate() {
            if (this.currentIterator.hasNext()) {
                PathIterator next = new PathIterator(this.to, this.currentIterator);
                next.oldBoundingBox = this.oldBoundingBox;
                return next;
            }
            return null;
        }

        public boolean collision(wu left, wu right) {
            if (left.d < right.a || left.a > right.d) {
                return false;
            }
            if (left.e < right.b || left.b > right.e) {
                return false;
            }
            return !(left.f < right.c) && !(left.c > right.f);
        }
    }
}

