/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.bptblocks;

import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.blueprints.BptSlotInfo;
import buildcraft.api.blueprints.IBptContext;
import java.util.LinkedList;

public class BptBlockRotateMeta
extends BptBlock {
    int[] rot;
    boolean rotateForward;
    int infoMask = 0;

    public BptBlockRotateMeta(int blockId, int[] rotations, boolean rotateForward) {
        super(blockId);
        this.rot = rotations;
        for (int i = 0; i < this.rot.length; ++i) {
            if (this.rot[i] < 4) {
                this.infoMask = this.infoMask < 3 ? 3 : this.infoMask;
                continue;
            }
            if (this.rot[i] < 8) {
                this.infoMask = this.infoMask < 7 ? 7 : this.infoMask;
                continue;
            }
            if (this.rot[i] >= 16) continue;
            this.infoMask = this.infoMask < 15 ? 15 : this.infoMask;
        }
        this.rotateForward = rotateForward;
    }

    @Override
    public void addRequirements(BptSlotInfo slot, IBptContext context, LinkedList requirements) {
        requirements.add(new aan(slot.blockId, 1, 0));
    }

    @Override
    public boolean isValid(BptSlotInfo slot, IBptContext context) {
        return slot.blockId == context.world().a(slot.x, slot.y, slot.z);
    }

    @Override
    public void rotateLeft(BptSlotInfo slot, IBptContext context) {
        int pos = slot.meta & this.infoMask;
        int others = slot.meta - pos;
        if (this.rotateForward) {
            if (pos == this.rot[0]) {
                pos = this.rot[1];
            } else if (pos == this.rot[1]) {
                pos = this.rot[2];
            } else if (pos == this.rot[2]) {
                pos = this.rot[3];
            } else if (pos == this.rot[3]) {
                pos = this.rot[0];
            }
        } else if (pos == this.rot[0]) {
            pos = this.rot[3];
        } else if (pos == this.rot[1]) {
            pos = this.rot[2];
        } else if (pos == this.rot[2]) {
            pos = this.rot[0];
        } else if (pos == this.rot[3]) {
            pos = this.rot[1];
        }
        slot.meta = pos + others;
    }
}

