/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.gates.Action;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.Trigger;
import buildcraft.api.liquids.LiquidData;
import buildcraft.api.liquids.LiquidManager;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.ActionMachineControl;
import buildcraft.core.ActionRedstoneOutput;
import buildcraft.core.BptItem;
import buildcraft.core.BuildCraftConfiguration;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultActionProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.DefaultTriggerProvider;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.ItemWrench;
import buildcraft.core.RedstonePowerFramework;
import buildcraft.core.TriggerInventory;
import buildcraft.core.TriggerLiquidContainer;
import buildcraft.core.TriggerMachine;
import buildcraft.core.network.ConnectionHandler;
import buildcraft.mod_BuildCraftCore;
import buildcraft.transport.TriggerRedstoneInput;
import forge.IConnectionHandler;
import forge.MinecraftForge;
import forge.Property;
import java.io.File;
import java.util.TreeMap;

public class BuildCraftCore {
    public static RenderMode render = RenderMode.Full;
    public static boolean debugMode = false;
    public static boolean modifyWorld = false;
    public static boolean trackNetworkUsage = false;
    public static boolean dropBrokenBlocks = true;
    public static int updateFactor = 10;
    public static BuildCraftConfiguration mainConfiguration;
    public static TreeMap bufferedDescriptions;
    public static final int trackedPassiveEntityId = 156;
    public static boolean continuousCurrentModel;
    private static boolean initialized;
    private static boolean gearsInitialized;
    public static yr woodenGearItem;
    public static yr stoneGearItem;
    public static yr ironGearItem;
    public static yr goldGearItem;
    public static yr diamondGearItem;
    public static yr wrenchItem;
    public static int redLaserTexture;
    public static int blueLaserTexture;
    public static int stripesLaserTexture;
    public static int transparentTexture;
    public static int blockByEntityModel;
    public static int legacyPipeModel;
    public static int markerModel;
    public static int oilModel;
    public static Trigger triggerMachineActive;
    public static Trigger triggerMachineInactive;
    public static Trigger triggerEmptyInventory;
    public static Trigger triggerContainsInventory;
    public static Trigger triggerSpaceInventory;
    public static Trigger triggerFullInventory;
    public static Trigger triggerEmptyLiquid;
    public static Trigger triggerContainsLiquid;
    public static Trigger triggerSpaceLiquid;
    public static Trigger triggerFullLiquid;
    public static Trigger triggerRedstoneActive;
    public static Trigger triggerRedstoneInactive;
    public static Action actionRedstone;
    public static Action actionOn;
    public static Action actionOff;
    public static Action actionLoop;
    public static boolean loadDefaultRecipes;
    public static boolean forcePneumaticPower;
    public static boolean consumeWaterSources;
    public static BptItem[] itemBptProps;

    public static void load() {
        MinecraftForge.registerConnectionHandler((IConnectionHandler)new ConnectionHandler());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        ModLoader.getLogger().fine("Starting BuildCraft " + mod_BuildCraftCore.version());
        ModLoader.getLogger().fine("Copyright (c) SpaceToad, 2011");
        ModLoader.getLogger().fine("http://www.mod-buildcraft.com");
        System.out.println("Starting BuildCraft " + mod_BuildCraftCore.version());
        System.out.println("Copyright (c) SpaceToad, 2011-2012");
        System.out.println("http://www.mod-buildcraft.com");
        initialized = true;
        mainConfiguration = new BuildCraftConfiguration(new File(CoreProxy.getBuildCraftBase(), "config/buildcraft.cfg"), true);
        mainConfiguration.load();
        redLaserTexture = 2;
        blueLaserTexture = 1;
        stripesLaserTexture = 3;
        transparentTexture = 0;
        Property continuousCurrent = mainConfiguration.getOrCreateBooleanProperty("current.continuous", "general", DefaultProps.CURRENT_CONTINUOUS);
        continuousCurrent.comment = "set to true for allowing machines to be driven by continuous current";
        continuousCurrentModel = Boolean.parseBoolean(continuousCurrent.value);
        Property trackNetwork = mainConfiguration.getOrCreateBooleanProperty("trackNetworkUsage", "general", false);
        trackNetworkUsage = Boolean.parseBoolean(trackNetwork.value);
        Property dropBlock = mainConfiguration.getOrCreateBooleanProperty("dropBrokenBlocks", "general", true);
        dropBlock.comment = "set to false to prevent fillers from dropping blocks.";
        dropBrokenBlocks = Boolean.parseBoolean(dropBlock.value);
        Property powerFrameworkClass = mainConfiguration.getOrCreateProperty("power.framework", "general", "buildcraft.energy.PneumaticPowerFramework");
        Property factor = mainConfiguration.getOrCreateIntProperty("network.updateFactor", "general", 10);
        factor.comment = "increasing this number will decrease network update frequency, useful for overloaded servers";
        updateFactor = Integer.parseInt(factor.value);
        String prefix = "";
        if (BuildCraftCore.class.getName().startsWith("net.minecraft.src.")) {
            prefix = "net.minecraft.src.";
        }
        if (forcePneumaticPower) {
            try {
                PowerFramework.currentFramework = (PowerFramework)Class.forName(prefix + "buildcraft.energy.PneumaticPowerFramework").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            try {
                String className = powerFrameworkClass.value;
                if (className.startsWith("net.minecraft.src.")) {
                    className = className.replace("net.minecraft.src.", "");
                }
                PowerFramework.currentFramework = (PowerFramework)Class.forName(prefix + className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                PowerFramework.currentFramework = new RedstonePowerFramework();
            }
        }
        Property wrenchId = mainConfiguration.getOrCreateIntProperty("wrench.id", "item", DefaultProps.WRENCH_ID);
        mainConfiguration.save();
        BuildCraftCore.initializeGears();
        wrenchItem = new ItemWrench(Integer.parseInt(wrenchId.value)).e(2).a("wrenchItem");
        CoreProxy.addName(wrenchItem, "Wrench");
        LiquidManager.liquids.add(new LiquidData(new LiquidStack(pb.B, 1000), new LiquidStack(pb.A, 1000), new aan(yr.ax), new aan(yr.aw)));
        LiquidManager.liquids.add(new LiquidData(new LiquidStack(pb.D, 1000), new LiquidStack(pb.C, 1000), new aan(yr.ay), new aan(yr.aw)));
        BuildCraftAPI.softBlocks[pb.X.bO] = true;
        BuildCraftAPI.softBlocks[pb.aS.bO] = true;
        BuildCraftAPI.softBlocks[pb.A.bO] = true;
        BuildCraftAPI.softBlocks[pb.B.bO] = true;
        mainConfiguration.save();
        if (loadDefaultRecipes) {
            BuildCraftCore.loadRecipes();
        }
    }

    public static void loadRecipes() {
        CoreProxy.addCraftingRecipe(new aan(wrenchItem), new Object[]{"I I", " G ", " I ", Character.valueOf('I'), yr.o, Character.valueOf('G'), stoneGearItem});
        CoreProxy.addCraftingRecipe(new aan(woodenGearItem), new Object[]{" S ", "S S", " S ", Character.valueOf('S'), yr.D});
        CoreProxy.addCraftingRecipe(new aan(stoneGearItem), new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), pb.w, Character.valueOf('G'), woodenGearItem});
        CoreProxy.addCraftingRecipe(new aan(ironGearItem), new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), yr.o, Character.valueOf('G'), stoneGearItem});
        CoreProxy.addCraftingRecipe(new aan(goldGearItem), new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), yr.p, Character.valueOf('G'), ironGearItem});
        CoreProxy.addCraftingRecipe(new aan(diamondGearItem), new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), yr.n, Character.valueOf('G'), goldGearItem});
    }

    public static void initializeGears() {
        if (gearsInitialized) {
            return;
        }
        Property woodenGearId = mainConfiguration.getOrCreateIntProperty("woodenGearItem.id", "item", DefaultProps.WOODEN_GEAR_ID);
        Property stoneGearId = mainConfiguration.getOrCreateIntProperty("stoneGearItem.id", "item", DefaultProps.STONE_GEAR_ID);
        Property ironGearId = mainConfiguration.getOrCreateIntProperty("ironGearItem.id", "item", DefaultProps.IRON_GEAR_ID);
        Property goldenGearId = mainConfiguration.getOrCreateIntProperty("goldenGearItem.id", "item", DefaultProps.GOLDEN_GEAR_ID);
        Property diamondGearId = mainConfiguration.getOrCreateIntProperty("diamondGearItem.id", "item", DefaultProps.DIAMOND_GEAR_ID);
        Property modifyWorld = mainConfiguration.getOrCreateBooleanProperty("modifyWorld", "general", true);
        modifyWorld.comment = "set to false if BuildCraft should not generate custom blocks (e.g. oil)";
        mainConfiguration.save();
        BuildCraftCore.modifyWorld = modifyWorld.value.equals("true");
        gearsInitialized = true;
        woodenGearItem = new ItemBuildCraft(Integer.parseInt(woodenGearId.value)).e(16).a("woodenGearItem");
        CoreProxy.addName(woodenGearItem, "Wooden Gear");
        stoneGearItem = new ItemBuildCraft(Integer.parseInt(stoneGearId.value)).e(17).a("stoneGearItem");
        CoreProxy.addName(stoneGearItem, "Stone Gear");
        ironGearItem = new ItemBuildCraft(Integer.parseInt(ironGearId.value)).e(18).a("ironGearItem");
        CoreProxy.addName(ironGearItem, "Iron Gear");
        goldGearItem = new ItemBuildCraft(Integer.parseInt(goldenGearId.value)).e(19).a("goldGearItem");
        CoreProxy.addName(goldGearItem, "Gold Gear");
        diamondGearItem = new ItemBuildCraft(Integer.parseInt(diamondGearId.value)).e(20).a("diamondGearItem");
        CoreProxy.addName(diamondGearItem, "Diamond Gear");
        mainConfiguration.save();
        ActionManager.registerTriggerProvider(new DefaultTriggerProvider());
        ActionManager.registerActionProvider(new DefaultActionProvider());
    }

    public static void initializeModel(BaseMod mod) {
        blockByEntityModel = ModLoader.getUniqueBlockModelID((BaseMod)mod, (boolean)true);
        legacyPipeModel = ModLoader.getUniqueBlockModelID((BaseMod)mod, (boolean)true);
        markerModel = ModLoader.getUniqueBlockModelID((BaseMod)mod, (boolean)false);
        oilModel = ModLoader.getUniqueBlockModelID((BaseMod)mod, (boolean)false);
    }

    static {
        bufferedDescriptions = new TreeMap();
        initialized = false;
        gearsInitialized = false;
        triggerMachineActive = new TriggerMachine(DefaultProps.TRIGGER_MACHINE_ACTIVE, true);
        triggerMachineInactive = new TriggerMachine(DefaultProps.TRIGGER_MACHINE_INACTIVE, false);
        triggerEmptyInventory = new TriggerInventory(DefaultProps.TRIGGER_EMPTY_INVENTORY, TriggerInventory.State.Empty);
        triggerContainsInventory = new TriggerInventory(DefaultProps.TRIGGER_CONTAINS_INVENTORY, TriggerInventory.State.Contains);
        triggerSpaceInventory = new TriggerInventory(DefaultProps.TRIGGER_SPACE_INVENTORY, TriggerInventory.State.Space);
        triggerFullInventory = new TriggerInventory(DefaultProps.TRIGGER_FULL_INVENTORY, TriggerInventory.State.Full);
        triggerEmptyLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_EMPTY_LIQUID, TriggerLiquidContainer.State.Empty);
        triggerContainsLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_CONTAINS_LIQUID, TriggerLiquidContainer.State.Contains);
        triggerSpaceLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_SPACE_LIQUID, TriggerLiquidContainer.State.Space);
        triggerFullLiquid = new TriggerLiquidContainer(DefaultProps.TRIGGER_FULL_LIQUID, TriggerLiquidContainer.State.Full);
        triggerRedstoneActive = new TriggerRedstoneInput(DefaultProps.TRIGGER_REDSTONE_ACTIVE, true);
        triggerRedstoneInactive = new TriggerRedstoneInput(DefaultProps.TRIGGER_REDSTONE_INACTIVE, false);
        actionRedstone = new ActionRedstoneOutput(DefaultProps.ACTION_REDSTONE);
        actionOn = new ActionMachineControl(DefaultProps.ACTION_ON, ActionMachineControl.Mode.On);
        actionOff = new ActionMachineControl(DefaultProps.ACTION_OFF, ActionMachineControl.Mode.Off);
        actionLoop = new ActionMachineControl(DefaultProps.ACTION_LOOP, ActionMachineControl.Mode.Loop);
        loadDefaultRecipes = true;
        forcePneumaticPower = false;
        consumeWaterSources = true;
        itemBptProps = new BptItem[yr.e.length];
    }

    public static enum RenderMode {
        Full,
        NoDynamic;

    }
}

