/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.bptblocks.BptBlockBed;
import buildcraft.api.bptblocks.BptBlockCustomStack;
import buildcraft.api.bptblocks.BptBlockDelegate;
import buildcraft.api.bptblocks.BptBlockDirt;
import buildcraft.api.bptblocks.BptBlockDoor;
import buildcraft.api.bptblocks.BptBlockIgnore;
import buildcraft.api.bptblocks.BptBlockIgnoreMeta;
import buildcraft.api.bptblocks.BptBlockInventory;
import buildcraft.api.bptblocks.BptBlockLever;
import buildcraft.api.bptblocks.BptBlockLiquid;
import buildcraft.api.bptblocks.BptBlockPiston;
import buildcraft.api.bptblocks.BptBlockPumpkin;
import buildcraft.api.bptblocks.BptBlockRedstoneRepeater;
import buildcraft.api.bptblocks.BptBlockRotateInventory;
import buildcraft.api.bptblocks.BptBlockRotateMeta;
import buildcraft.api.bptblocks.BptBlockSign;
import buildcraft.api.bptblocks.BptBlockStairs;
import buildcraft.api.bptblocks.BptBlockWallSide;
import buildcraft.api.filler.FillerManager;
import buildcraft.builders.BlockArchitect;
import buildcraft.builders.BlockBlueprintLibrary;
import buildcraft.builders.BlockBuilder;
import buildcraft.builders.BlockFiller;
import buildcraft.builders.BlockMarker;
import buildcraft.builders.BlockPathMarker;
import buildcraft.builders.BptBlockFiller;
import buildcraft.builders.BuildersSaveManager;
import buildcraft.builders.FillerFillAll;
import buildcraft.builders.FillerFillPyramid;
import buildcraft.builders.FillerFillStairs;
import buildcraft.builders.FillerFillWalls;
import buildcraft.builders.FillerFlattener;
import buildcraft.builders.FillerRegistry;
import buildcraft.builders.FillerRemover;
import buildcraft.builders.GuiHandler;
import buildcraft.builders.IBuilderHook;
import buildcraft.builders.ItemBptBluePrint;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileFiller;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.BptPlayerIndex;
import buildcraft.core.BptRootIndex;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.mod_BuildCraftBuilders;
import buildcraft.mod_BuildCraftCore;
import forge.IGuiHandler;
import forge.ISaveEventHandler;
import forge.MinecraftForge;
import forge.Property;
import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeMap;

public class BuildCraftBuilders {
    public static final int LIBRARY_PAGE_SIZE = 12;
    public static final int MAX_BLUEPRINTS_NAME_SIZE = 88;
    public static BlockMarker markerBlock;
    public static BlockPathMarker pathMarkerBlock;
    public static BlockFiller fillerBlock;
    public static BlockBuilder builderBlock;
    public static BlockArchitect architectBlock;
    public static BlockBlueprintLibrary libraryBlock;
    public static ItemBptTemplate templateItem;
    public static ItemBptBluePrint blueprintItem;
    public static boolean fillerDestroy;
    private static boolean initialized;
    private static BptRootIndex rootBptIndex;
    public static TreeMap playerLibrary;
    private static LinkedList hooks;

    public static void load() {
        FillerManager.registry = new FillerRegistry();
        MinecraftForge.setGuiHandler((BaseMod)mod_BuildCraftBuilders.instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.registerSaveHandler((ISaveEventHandler)new BuildersSaveManager());
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        mod_BuildCraftCore.initialize();
        BuildCraftCore.initializeGears();
        Property templateItemId = BuildCraftCore.mainConfiguration.getOrCreateIntProperty("templateItem.id", "item", DefaultProps.TEMPLATE_ITEM_ID);
        Property blueprintItemId = BuildCraftCore.mainConfiguration.getOrCreateIntProperty("blueprintItem.id", "item", DefaultProps.BLUEPRINT_ITEM_ID);
        Property markerId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("marker.id", DefaultProps.MARKER_ID);
        Property pathMarkerId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("pathMarker.id", DefaultProps.PATH_MARKER_ID);
        Property fillerId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("filler.id", DefaultProps.FILLER_ID);
        Property builderId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("builder.id", DefaultProps.BUILDER_ID);
        Property architectId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("architect.id", DefaultProps.ARCHITECT_ID);
        Property libraryId = BuildCraftCore.mainConfiguration.getOrCreateBlockIdProperty("blueprintLibrary.id", DefaultProps.BLUEPRINT_LIBRARY_ID);
        Property fillerDestroyProp = BuildCraftCore.mainConfiguration.getOrCreateBooleanProperty("filler.destroy", "general", DefaultProps.FILLER_DESTROY);
        fillerDestroyProp.comment = "If true, Filler will destroy blocks instead of breaking them.";
        fillerDestroy = Boolean.parseBoolean(fillerDestroyProp.value);
        BuildCraftCore.mainConfiguration.save();
        templateItem = new ItemBptTemplate(Integer.parseInt(templateItemId.value));
        templateItem.a("templateItem");
        CoreProxy.addName((Object)templateItem, "Template");
        blueprintItem = new ItemBptBluePrint(Integer.parseInt(blueprintItemId.value));
        blueprintItem.a("blueprintItem");
        CoreProxy.addName((Object)blueprintItem, "Blueprint");
        markerBlock = new BlockMarker(Integer.parseInt(markerId.value));
        CoreProxy.registerBlock(markerBlock.a("markerBlock"));
        CoreProxy.addName((Object)markerBlock, "Land Mark");
        pathMarkerBlock = new BlockPathMarker(Integer.parseInt(pathMarkerId.value));
        CoreProxy.registerBlock(pathMarkerBlock.a("pathMarkerBlock"));
        CoreProxy.addName((Object)pathMarkerBlock, "Path Mark");
        fillerBlock = new BlockFiller(Integer.parseInt(fillerId.value));
        CoreProxy.registerBlock(fillerBlock.a("fillerBlock"));
        CoreProxy.addName((Object)fillerBlock, "Filler");
        builderBlock = new BlockBuilder(Integer.parseInt(builderId.value));
        CoreProxy.registerBlock(builderBlock.a("builderBlock"));
        CoreProxy.addName((Object)builderBlock, "Builder");
        architectBlock = new BlockArchitect(Integer.parseInt(architectId.value));
        CoreProxy.registerBlock(architectBlock.a("architectBlock"));
        CoreProxy.addName((Object)architectBlock, "Architect Table");
        libraryBlock = new BlockBlueprintLibrary(Integer.parseInt(libraryId.value));
        CoreProxy.registerBlock(libraryBlock.a("libraryBlock"));
        CoreProxy.addName((Object)libraryBlock, "Blueprint Library");
        CoreProxy.registerTileEntity(TileMarker.class, "Marker");
        CoreProxy.registerTileEntity(TileFiller.class, "Filler");
        CoreProxy.registerTileEntity(TileBuilder.class, "net.minecraft.src.builders.TileBuilder");
        CoreProxy.registerTileEntity(TileArchitect.class, "net.minecraft.src.builders.TileTemplate");
        CoreProxy.registerTileEntity(TilePathMarker.class, "net.minecraft.src.builders.TilePathMarker");
        CoreProxy.registerTileEntity(TileBlueprintLibrary.class, "net.minecraft.src.builders.TileBlueprintLibrary");
        FillerManager.registry.addRecipe(new FillerFillAll(), new Object[]{"bbb", "bbb", "bbb", Character.valueOf('b'), new aan(pb.al, 1)});
        FillerManager.registry.addRecipe(new FillerFlattener(), new Object[]{"   ", "ggg", "bbb", Character.valueOf('g'), pb.M, Character.valueOf('b'), pb.al});
        FillerManager.registry.addRecipe(new FillerRemover(), new Object[]{"ggg", "ggg", "ggg", Character.valueOf('g'), pb.M});
        FillerManager.registry.addRecipe(new FillerFillWalls(), new Object[]{"bbb", "b b", "bbb", Character.valueOf('b'), pb.al});
        FillerManager.registry.addRecipe(new FillerFillPyramid(), new Object[]{"   ", " b ", "bbb", Character.valueOf('b'), pb.al});
        FillerManager.registry.addRecipe(new FillerFillStairs(), new Object[]{"  b", " bb", "bbb", Character.valueOf('b'), pb.al});
        BuildCraftCore.mainConfiguration.save();
        new BptBlock(0);
        new BptBlockIgnore(pb.aS.bO);
        new BptBlockIgnore(pb.X.bO);
        new BptBlockIgnore(pb.aT.bO);
        new BptBlockIgnore(pb.aa.bO);
        new BptBlockDirt(pb.v.bO);
        new BptBlockDirt(pb.u.bO);
        new BptBlockDirt(pb.aA.bO);
        new BptBlockDelegate(pb.aP.bO, pb.aQ.bO);
        new BptBlockDelegate(pb.aC.bO, pb.aB.bO);
        new BptBlockDelegate(pb.ac.bO, pb.Z.bO);
        new BptBlockWallSide(pb.aq.bO);
        new BptBlockWallSide(pb.aQ.bO);
        new BptBlockRotateMeta(pb.aF.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateMeta(pb.bv.bO, new int[]{0, 1, 2, 3}, true);
        new BptBlockRotateInventory(pb.aB.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(pb.au.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(pb.bj.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(pb.P.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(pb.bF.bO);
        new BptBlockRotateMeta(pb.bu.bO, new int[]{1, 4, 8, 2}, false);
        new BptBlockRotateMeta(pb.bk.bO, new int[]{0, 1, 2, 3}, false);
        new BptBlockLever(pb.aR.bO);
        new BptBlockLever(pb.aJ.bO);
        new BptBlockCustomStack(pb.t.bO, new aan(pb.t));
        new BptBlockCustomStack(pb.av.bO, new aan(yr.aC));
        new BptBlockCustomStack(pb.aj.bO, new aan(pb.ak, 2));
        new BptBlockCustomStack(pb.bg.bO, new aan(yr.aZ));
        new BptBlockCustomStack(pb.az.bO, new aan(yr.S));
        new BptBlockCustomStack(pb.bs.bO, new aan(yr.bg));
        new BptBlockCustomStack(pb.bt.bO, new aan(yr.bh));
        new BptBlockCustomStack(pb.bd.bO, new aan(pb.bd));
        new BptBlockRedstoneRepeater(pb.bi.bO);
        new BptBlockRedstoneRepeater(pb.bh.bO);
        new BptBlockLiquid(pb.B.bO, new aan(yr.ax));
        new BptBlockLiquid(pb.A.bO, new aan(yr.ax));
        new BptBlockLiquid(pb.D.bO, new aan(yr.ay));
        new BptBlockLiquid(pb.C.bO, new aan(yr.ay));
        new BptBlockIgnoreMeta(pb.aG.bO);
        new BptBlockIgnoreMeta(pb.T.bO);
        new BptBlockIgnoreMeta(pb.U.bO);
        new BptBlockIgnoreMeta(pb.bq.bO);
        new BptBlockPiston(pb.Z.bO);
        new BptBlockPiston(pb.V.bO);
        new BptBlockPumpkin(pb.bf.bO);
        new BptBlockStairs(pb.aH.bO);
        new BptBlockStairs(pb.at.bO);
        new BptBlockStairs(pb.bC.bO);
        new BptBlockStairs(pb.bw.bO);
        new BptBlockStairs(pb.bx.bO);
        new BptBlockDoor(pb.aE.bO, new aan(yr.av));
        new BptBlockDoor(pb.aL.bO, new aan(yr.aB));
        new BptBlockBed(pb.S.bO);
        new BptBlockSign(pb.aI.bO, true);
        new BptBlockSign(pb.aD.bO, false);
        new BptBlockRotateInventory(BuildCraftBuilders.architectBlock.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(BuildCraftBuilders.builderBlock.bO, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(BuildCraftBuilders.libraryBlock.bO);
        new BptBlockWallSide(BuildCraftBuilders.markerBlock.bO);
        new BptBlockWallSide(BuildCraftBuilders.pathMarkerBlock.bO);
        new BptBlockFiller(BuildCraftBuilders.fillerBlock.bO);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftBuilders.loadRecipes();
        }
    }

    public static void loadRecipes() {
        CoreProxy.addCraftingRecipe(new aan((yr)templateItem, 1), new Object[]{"ppp", "pip", "ppp", Character.valueOf('i'), new aan(yr.aW, 1, 0), Character.valueOf('p'), yr.aK});
        CoreProxy.addCraftingRecipe(new aan((yr)blueprintItem, 1), new Object[]{"ppp", "pip", "ppp", Character.valueOf('i'), new aan(yr.aW, 1, 4), Character.valueOf('p'), yr.aK});
        CoreProxy.addCraftingRecipe(new aan((pb)markerBlock, 1), new Object[]{"l ", "r ", Character.valueOf('l'), new aan(yr.aW, 1, 4), Character.valueOf('r'), pb.aQ});
        CoreProxy.addCraftingRecipe(new aan((pb)pathMarkerBlock, 1), new Object[]{"l ", "r ", Character.valueOf('l'), new aan(yr.aW, 1, 2), Character.valueOf('r'), pb.aQ});
        CoreProxy.addCraftingRecipe(new aan((pb)fillerBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new aan(yr.aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new aan(yr.aW, 1, 11), Character.valueOf('c'), pb.ay, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('C'), pb.au});
        CoreProxy.addCraftingRecipe(new aan((pb)builderBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new aan(yr.aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new aan(yr.aW, 1, 11), Character.valueOf('c'), pb.ay, Character.valueOf('g'), BuildCraftCore.diamondGearItem, Character.valueOf('C'), pb.au});
        CoreProxy.addCraftingRecipe(new aan((pb)architectBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new aan(yr.aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new aan(yr.aW, 1, 11), Character.valueOf('c'), pb.ay, Character.valueOf('g'), BuildCraftCore.diamondGearItem, Character.valueOf('C'), new aan((yr)templateItem, 1)});
        CoreProxy.addCraftingRecipe(new aan((pb)libraryBlock, 1), new Object[]{"bbb", "bBb", "bbb", Character.valueOf('b'), new aan((yr)blueprintItem), Character.valueOf('B'), pb.an});
    }

    public static BptPlayerIndex getPlayerIndex(String name) {
        BptRootIndex rootIndex = BuildCraftBuilders.getBptRootIndex();
        if (!playerLibrary.containsKey(name)) {
            try {
                playerLibrary.put(name, new BptPlayerIndex(name + ".list", rootIndex));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (BptPlayerIndex)playerLibrary.get(name);
    }

    public static BptRootIndex getBptRootIndex() {
        if (rootBptIndex == null) {
            try {
                rootBptIndex = new BptRootIndex("index.txt");
                rootBptIndex.loadIndex();
                for (IBuilderHook hook : hooks) {
                    hook.rootIndexInitialized(rootBptIndex);
                }
                rootBptIndex.importNewFiles();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rootBptIndex;
    }

    public static void addHook(IBuilderHook hook) {
        if (!hooks.contains(hook)) {
            hooks.add(hook);
        }
    }

    static {
        initialized = false;
        playerLibrary = new TreeMap();
        hooks = new LinkedList();
    }
}

